<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['position', 'limit' => 1, 'class' => '']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['position', 'limit' => 1, 'class' => '']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
$ads = isset($adsByPosition[$position]) ? $adsByPosition[$position]->take($limit) : collect([]);
?>

<?php if($ads->count() > 0): ?>
    <div class="advertisement-container <?php echo e($class); ?>">
        <?php $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="advertisement-item mb-3" data-ad-id="<?php echo e($ad->id); ?>">
                <?php if($ad->ad_type == 'banner' && $ad->image_path): ?>
                    <a href="<?php echo e(route('ad.click', $ad->id)); ?>" target="_blank" onclick="trackAdView(<?php echo e($ad->id); ?>)">
                        <img src="<?php echo e(asset('storage/' . $ad->image_path)); ?>" 
                            alt="<?php echo e($ad->title); ?>" 
                            class="img-fluid ad-image"
                            <?php if($ad->size): ?>
                                style="width: <?php echo e(explode('x', $ad->size)[0]); ?>px; height: <?php echo e(explode('x', $ad->size)[1]); ?>px;"
                            <?php endif; ?>
                        >
                    </a>
                <?php elseif($ad->ad_type == 'html' && $ad->html_content): ?>
                    <div class="ad-html-content" onclick="trackAdView(<?php echo e($ad->id); ?>)">
                        <?php echo $ad->html_content; ?>

                    </div>
                <?php elseif($ad->ad_type == 'text'): ?>
                    <div class="ad-text-content">
                        <a href="<?php echo e(route('ad.click', $ad->id)); ?>" target="_blank" onclick="trackAdView(<?php echo e($ad->id); ?>)">
                            <h4><?php echo e($ad->title); ?></h4>
                            <p><?php echo e($ad->html_content); ?></p>
                        </a>
                    </div>
                <?php elseif($ad->ad_type == 'video' && $ad->html_content): ?>
                    <div class="ad-video-content" onclick="trackAdView(<?php echo e($ad->id); ?>)">
                        <div class="text-center">
                            <h5 class="mb-2"><?php echo e($ad->title); ?></h5>
                            <div class="embed-responsive embed-responsive-16by9">
                                <?php echo $ad->html_content; ?>

                            </div>
                            <?php if($ad->target_url): ?>
                                <div class="mt-2">
                                    <a href="<?php echo e(route('ad.click', $ad->id)); ?>" target="_blank" class="btn btn-sm btn-primary">
                                        مشاهده بیشتر
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php elseif($ad->ad_type == 'slider' && $ad->image_path): ?>
                    <div class="ad-slider-content" onclick="trackAdView(<?php echo e($ad->id); ?>)">
                        <div id="ad-slider-<?php echo e($ad->id); ?>" class="carousel slide" data-ride="carousel">
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <img src="<?php echo e(asset('storage/' . $ad->image_path)); ?>" class="d-block w-100" alt="<?php echo e($ad->title); ?>">
                                    <div class="carousel-caption d-none d-md-block">
                                        <h5><?php echo e($ad->title); ?></h5>
                                    </div>
                                </div>
                                <?php if($ad->html_content): ?>
                                    <?php
                                        $extraImages = json_decode($ad->html_content, true);
                                    ?>
                                    <?php if(is_array($extraImages)): ?>
                                        <?php $__currentLoopData = $extraImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="carousel-item">
                                                <img src="<?php echo e(asset('storage/' . $image['path'])); ?>" class="d-block w-100" alt="<?php echo e($image['title'] ?? $ad->title); ?>">
                                                <div class="carousel-caption d-none d-md-block">
                                                    <h5><?php echo e($image['title'] ?? $ad->title); ?></h5>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <a class="carousel-control-prev" href="#ad-slider-<?php echo e($ad->id); ?>" role="button" data-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="sr-only">قبلی</span>
                            </a>
                            <a class="carousel-control-next" href="#ad-slider-<?php echo e($ad->id); ?>" role="button" data-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="sr-only">بعدی</span>
                            </a>
                        </div>
                    </div>
                <?php elseif($ad->ad_type == 'featured'): ?>
                    <div class="ad-featured-content p-3 bg-light border rounded">
                        <div class="text-center">
                            <?php if($ad->image_path): ?>
                                <img src="<?php echo e(asset('storage/' . $ad->image_path)); ?>" 
                                    alt="<?php echo e($ad->title); ?>" 
                                    class="img-fluid mb-2"
                                    style="max-height: 150px;"
                                >
                            <?php endif; ?>
                            <h4 class="text-primary"><?php echo e($ad->title); ?></h4>
                            <?php if($ad->html_content): ?>
                                <div class="my-2"><?php echo $ad->html_content; ?></div>
                            <?php endif; ?>
                            <?php if($ad->target_url): ?>
                                <a href="<?php echo e(route('ad.click', $ad->id)); ?>" class="btn btn-primary mt-2" target="_blank" onclick="trackAdView(<?php echo e($ad->id); ?>)">
                                    مشاهده بیشتر
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php elseif($ad->ad_type == 'popup'): ?>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            setTimeout(function() {
                                showPopupAdInline(<?php echo e($ad->id); ?>, '<?php echo e($ad->title); ?>', '<?php echo e(asset('storage/' . $ad->image_path)); ?>', '<?php echo addslashes($ad->html_content); ?>', '<?php echo e($ad->target_url); ?>', '<?php echo e($ad->ad_type); ?>');
                            }, 3000);
                        });

                        function showPopupAdInline(id, title, imagePath, htmlContent, targetUrl, adType) {
                            const container = document.createElement('div');
                            container.className = 'popup-ad-overlay';
                            container.setAttribute('data-ad-id', id);

                            let content = `
                                <div class="popup-ad-container">
                                    <div class="popup-ad-header">
                                        <h5>${title}</h5>
                                        <button class="popup-ad-close">&times;</button>
                                    </div>
                                    <div class="popup-ad-body">`;
                            
                            if (adType === 'banner' && imagePath) {
                                content += `
                                    <a href="<?php echo e(url('/ad/click')); ?>/${id}" target="_blank">
                                        <img src="${imagePath}" alt="${title}" class="img-fluid">
                                    </a>`;
                            } else if (htmlContent) {
                                content += htmlContent;
                            }
                            
                            content += `
                                    </div>
                                </div>
                            `;

                            container.innerHTML = content;
                            document.body.appendChild(container);

                            // Track view
                            trackAdView(id);

                            // Add event listener to close button
                            container.querySelector('.popup-ad-close').addEventListener('click', function() {
                                document.body.removeChild(container);
                            });
                        }
                    </script>
                    <style>
                        .popup-ad-overlay {
                            position: fixed;
                            top: 0;
                            left: 0;
                            width: 100%;
                            height: 100%;
                            background-color: rgba(0, 0, 0, 0.7);
                            display: flex;
                            justify-content: center;
                            align-items: center;
                            z-index: 9999;
                        }
                        .popup-ad-container {
                            background-color: white;
                            border-radius: 5px;
                            max-width: 90%;
                            max-height: 90%;
                            overflow: auto;
                            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
                        }
                        .popup-ad-header {
                            display: flex;
                            justify-content: space-between;
                            align-items: center;
                            padding: 10px 15px;
                            background-color: #f8f9fa;
                            border-bottom: 1px solid #dee2e6;
                        }
                        .popup-ad-close {
                            background: none;
                            border: none;
                            font-size: 24px;
                            cursor: pointer;
                            color: #6c757d;
                        }
                        .popup-ad-body {
                            padding: 15px;
                        }
                    </style>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    
    <script>
        function trackAdView(adId) {
            fetch('/ad/view/' + adId, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            });
        }
        
        document.addEventListener('DOMContentLoaded', function() {
            // Track views for displayed ads
            document.querySelectorAll('.advertisement-item').forEach(function(item) {
                const adId = item.getAttribute('data-ad-id');
                if (adId) {
                    trackAdView(adId);
                }
            });
        });
    </script>
<?php endif; ?> <?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/components/advertisement.blade.php ENDPATH**/ ?>