<?php
    $lang = \App\Models\Language::where('code', app()->getLocale())->first();
?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($lang && $lang->direction == 'rtl' ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'پنل مدیریت'); ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/fonts.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/sidebar.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/theme/monokai.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/templates.css')); ?>">
    <style>
        body {
            font-family: 'IRANSans', Tahoma, Arial, sans-serif;
            background-color: #f8f9fc;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .wrapper {
            display: flex;
            flex: 1;
        }
        .content {
            margin-right: 260px;
            flex: 1;
            padding: 20px;
            transition: all 0.3s ease;
        }
        .topbar {
            background-color: white;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            border-bottom: 1px solid #e3e6f0;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .topbar-toggler {
            background-color: transparent;
            border: none;
            color: #4e73df;
            font-size: 24px;
            cursor: pointer;
        }
        .user-dropdown {
            position: relative;
        }
        .user-dropdown-toggle {
            display: flex;
            align-items: center;
            cursor: pointer;
            padding: 5px 10px;
            border-radius: 4px;
        }
        .user-dropdown-toggle:hover {
            background-color: #f8f9fc;
        }
        .user-dropdown-toggle span {
            margin-right: 10px;
            font-weight: 500;
        }
        .user-dropdown-toggle img {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            object-fit: cover;
            border: 1px solid #e3e6f0;
        }
        .user-dropdown-menu {
            position: absolute;
            left: 0;
            top: 100%;
            background-color: white;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            border-radius: 4px;
            width: 250px;
            z-index: 100;
            padding: 10px 0;
            display: none;
        }
        .user-dropdown-menu.show {
            display: block;
        }
        .user-dropdown-item {
            display: block;
            padding: 8px 15px;
            color: #3a3b45;
            text-decoration: none;
            transition: all 0.2s ease;
        }
        .user-dropdown-item:hover {
            background-color: #f8f9fc;
            color: #4e73df;
        }
        .user-dropdown-divider {
            border-top: 1px solid #e3e6f0;
            margin: 5px 0;
        }
        .page-title {
            margin-bottom: 25px;
            font-weight: 500;
            color: #5a5c69;
        }
        .card {
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
            border: none;
            border-radius: 0.5rem;
            margin-bottom: 25px;
        }
        .card-header {
            background-color: #f8f9fc;
            border-bottom: 1px solid #e3e6f0;
            padding: 15px 20px;
            font-weight: 700;
            color: #4e73df;
        }
        .card-body {
            padding: 20px;
        }
        .card-footer {
            background-color: #f8f9fc;
            border-top: 1px solid #e3e6f0;
            padding: 15px 20px;
        }
        .btn-primary {
            background-color: #4e73df;
            border-color: #4e73df;
        }
        .btn-primary:hover {
            background-color: #3a5ccc;
            border-color: #3a5ccc;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-control {
            border-radius: 5px;
            font-size: 14px;
            padding: 10px 15px;
            border: 1px solid #e3e6f0;
        }
        .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.25rem rgba(78, 115, 223, 0.25);
        }
        .table th {
            font-weight: 700;
            background-color: #f8f9fc;
            white-space: nowrap;
        }
        .pagination {
            margin-bottom: 0;
        }
        .select2-container {
            width: 100% !important;
        }
        .select2-container--default .select2-selection--single {
            height: 42px;
            border: 1px solid #e3e6f0;
            border-radius: 5px;
        }
        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 42px;
            padding-right: 15px;
        }
        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 40px;
        }
        /* For dark mode */
        .dark-mode {
            background-color: #121212;
            color: #e0e0e0;
        }
        .dark-mode .topbar,
        .dark-mode .card,
        .dark-mode .user-dropdown-menu {
            background-color: #1e1e1e;
            color: #e0e0e0;
            border-color: #333;
        }
        .dark-mode .card-header,
        .dark-mode .card-footer,
        .dark-mode .table th {
            background-color: #2d2d2d;
            color: #e0e0e0;
            border-color: #333;
        }
        .dark-mode .form-control,
        .dark-mode .table {
            background-color: #1e1e1e;
            color: #e0e0e0;
            border-color: #333;
        }
        .dark-mode .user-dropdown-toggle:hover,
        .dark-mode .user-dropdown-item:hover {
            background-color: #2d2d2d;
        }
        .dark-mode .user-dropdown-divider {
            border-color: #333;
        }
        .dark-mode .user-dropdown-item {
            color: #e0e0e0;
        }
        .flag-emoji {
            font-size: 1.5em !important;
            line-height: 1 !important;
            display: inline-block !important;
            vertical-align: middle !important;
            font-family: 'Segoe UI Emoji', 'Apple Color Emoji', 'Noto Color Emoji', 'Arial', sans-serif !important;
            font-style: normal !important;
            font-weight: normal !important;
        }
    </style>
    <?php echo $__env->yieldContent('styles'); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <div class="wrapper">
        <!-- سایدبار مدیریت - بارگذاری به صورت کامپوننت مجزا برای ساختار تمیزتر -->
        <?php echo $__env->make('admin.components.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Content -->
        <div class="content" id="content">
            <div class="topbar">
                <button class="topbar-toggler" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>

                <div class="d-flex align-items-center">
                    <div class="navbar-nav ml-auto">
                        <?php if (isset($component)) { $__componentOriginal8d3bff7d7383a45350f7495fc470d934 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8d3bff7d7383a45350f7495fc470d934 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.language-switcher','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('language-switcher'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8d3bff7d7383a45350f7495fc470d934)): ?>
<?php $attributes = $__attributesOriginal8d3bff7d7383a45350f7495fc470d934; ?>
<?php unset($__attributesOriginal8d3bff7d7383a45350f7495fc470d934); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8d3bff7d7383a45350f7495fc470d934)): ?>
<?php $component = $__componentOriginal8d3bff7d7383a45350f7495fc470d934; ?>
<?php unset($__componentOriginal8d3bff7d7383a45350f7495fc470d934); ?>
<?php endif; ?>
                    </div>

                    <div class="user-dropdown">
                        <div class="user-dropdown-toggle" id="userDropdown">
                            <img src="https://ui-avatars.com/api/?name=<?php echo e(Auth::guard('admin')->user() ? Auth::guard('admin')->user()->name : 'Guest'); ?>&background=4e73df&color=fff" alt="User">
                            <span><?php echo e(Auth::guard('admin')->user() ? Auth::guard('admin')->user()->name : 'مهمان'); ?></span>
                            <i class="fas fa-chevron-down mr-2"></i>
                        </div>

                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <?php if(Auth::guard('admin')->check()): ?>
                            <a href="<?php echo e(route('admin.profile')); ?>" class="user-dropdown-item">
                                <i class="fas fa-user-circle"></i> پروفایل
                            </a>
                            <a href="<?php echo e(route('admin.change-password')); ?>" class="user-dropdown-item">
                                <i class="fas fa-key"></i> تغییر رمز عبور
                            </a>
                            <?php else: ?>
                            <a href="<?php echo e(route('admin.login')); ?>" class="user-dropdown-item">
                                <i class="fas fa-sign-in-alt"></i> ورود
                            </a>
                            <?php endif; ?>
                            <div class="user-dropdown-divider"></div>
                            <a href="#" class="user-dropdown-item" id="darkModeToggle">
                                <i class="fas fa-moon"></i> حالت شب
                            </a>
                            <div class="user-dropdown-divider"></div>
                            <form action="<?php echo e(route('admin.logout')); ?>" method="POST" id="logout-form">
                                <?php echo csrf_field(); ?>
                                <a href="#" class="user-dropdown-item" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <i class="fas fa-sign-out-alt"></i> خروج
                                </a>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.all.min.js"></script>

    <!-- Error Handler - Load First -->
    <script src="<?php echo e(asset('js/utils/error-handler.js')); ?>"></script>

    <!-- Heat Layer Optimizer - Load after error handler -->
    <script src="<?php echo e(asset('js/utils/leaflet-heat-optimizer.js')); ?>"></script>

    <script src="<?php echo e(asset('js/hierarchical-selects.js')); ?>"></script>
    <script src="<?php echo e(asset('js/boundary-display.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/css/css.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/javascript/javascript.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/addon/edit/matchbrackets.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/addon/edit/closebrackets.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/addon/edit/closetag.min.js"></script>
    <script>
        $(document).ready(function() {
            // Setup CSRF token for AJAX requests
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // Toggle sidebar
            $('#sidebarToggle').on('click', function() {
                $('body').toggleClass('sidebar-collapsed');
                $('#sidebar').toggleClass('show');
            });

            // Toggle submenu on mobile
            $('.dropdown-toggle').on('click', function(e) {
                e.preventDefault();
                $(this).next('.submenu').toggleClass('show');
            });

            // Toggle user dropdown
            $('#userDropdown').on('click', function() {
                $('#userDropdownMenu').toggleClass('show');
            });

            // Close dropdowns when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('.user-dropdown').length) {
                    $('#userDropdownMenu').removeClass('show');
                }
            });

            // Initialize Select2
            $('.select2').select2({
                dir: 'rtl',
                language: 'fa'
            });

            // Bootstrap 5 Modal Helper Functions
            window.showModal = function(modalId) {
                var modalEl = document.getElementById(modalId);
                if (modalEl) {
                    var modal = new bootstrap.Modal(modalEl);
                    modal.show();
                }
            };

            window.hideModal = function(modalId) {
                var modalEl = document.getElementById(modalId);
                if (modalEl) {
                    var modal = bootstrap.Modal.getInstance(modalEl);
                    if (modal) modal.hide();
                }
            };

            // Fix for Bootstrap 5 modals when triggered by jQuery
            $.fn.modal = function(action) {
                if (action === 'show') {
                    var modalEl = document.getElementById(this.attr('id'));
                    var modal = new bootstrap.Modal(modalEl);
                    modal.show();
                } else if (action === 'hide') {
                    var modalEl = document.getElementById(this.attr('id'));
                    var modal = bootstrap.Modal.getInstance(modalEl);
                    if (modal) modal.hide();
                }
                return this;
            };

            // Add Bootstrap 4 compatibility for data-toggle/data-target attributes
            $(document).on('click', '[data-toggle="modal"]', function() {
                var targetId = $(this).data('target').replace('#', '');
                window.showModal(targetId);
            });

            $(document).on('click', '[data-dismiss="modal"]', function() {
                var modal = $(this).closest('.modal');
                var modalId = modal.attr('id');
                window.hideModal(modalId);
            });

            // Dark mode toggle
            $('#darkModeToggle').on('click', function(e) {
                e.preventDefault();
                $('body').toggleClass('dark-mode');

                // Save preference to localStorage
                if ($('body').hasClass('dark-mode')) {
                    localStorage.setItem('darkMode', 'enabled');
                    $(this).html('<i class="fas fa-sun"></i> حالت روز');
                } else {
                    localStorage.setItem('darkMode', 'disabled');
                    $(this).html('<i class="fas fa-moon"></i> حالت شب');
                }
            });

            // Check dark mode preference
            if (localStorage.getItem('darkMode') === 'enabled') {
                $('body').addClass('dark-mode');
                $('#darkModeToggle').html('<i class="fas fa-sun"></i> حالت روز');
            }

            // Confirm delete
            $('.delete-confirm').on('click', function(e) {
                e.preventDefault();
                var form = $(this).closest('form');

                Swal.fire({
                    title: 'آیا مطمئن هستید؟',
                    text: 'این عملیات قابل بازگشت نیست!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'بله، حذف کن!',
                    cancelButtonText: 'انصراف'
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });

            // Auto hide alerts after 5 seconds
            setTimeout(function() {
                $('.alert').fadeOut('slow');
            }, 5000);
        });
    </script>
    <script src="<?php echo e(asset('js/admin/templates.js')); ?>"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/layouts/app.blade.php ENDPATH**/ ?>