<?php $__env->startSection('title', 'ثبت مکان جدید'); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css" />
<style>
    /* Modern Form Styles */
    body {
        font-family: 'IRANSans', 'Tahoma', Arial, sans-serif !important;
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
        min-height: 100vh;
    }

    .main-content {
        background: transparent;
    }

    .form-wizard {
        background: white;
        border-radius: 20px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        margin: 2rem 0;
    }

    .wizard-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 2rem;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .wizard-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        pointer-events: none;
    }

    .wizard-title {
        font-size: 1.75rem;
        font-weight: 700;
        margin: 0;
        position: relative;
        z-index: 1;
    }

    .wizard-subtitle {
        font-size: 1rem;
        opacity: 0.9;
        margin: 0.5rem 0 0 0;
        position: relative;
        z-index: 1;
    }

    /* Progress Steps */
    .progress-steps {
        display: flex;
        justify-content: space-between;
        margin: 2rem 0;
        padding: 0 2rem;
        position: relative;
        z-index: 1;
    }

    .step {
        display: flex;
        flex-direction: column;
        align-items: center;
        flex: 1;
        position: relative;
    }

    .step-number {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.2);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        margin-bottom: 0.5rem;
        transition: all 0.3s ease;
    }

    .step.active .step-number {
        background: white;
        color: #667eea;
        transform: scale(1.1);
    }

    .step.completed .step-number {
        background: #4ade80;
        color: white;
    }

    .step-title {
        font-size: 0.875rem;
        text-align: center;
        opacity: 0.8;
    }

    .step.active .step-title {
        opacity: 1;
        font-weight: 600;
    }

    .step-line {
        position: absolute;
        top: 20px;
        left: 50%;
        right: -50%;
        height: 2px;
        background: rgba(255, 255, 255, 0.2);
        z-index: -1;
    }

    .step:last-child .step-line {
        display: none;
    }

    .step.completed .step-line {
        background: #4ade80;
    }

    /* Form Sections */
    .form-section {
        background: white;
        border-radius: 16px;
        padding: 2rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .form-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(135deg, #667eea, #764ba2);
        transition: all 0.3s ease;
    }

    .form-section:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.1);
    }

    .form-section:hover::before {
        width: 8px;
    }

    .section-header {
        display: flex;
        align-items: center;
        margin-bottom: 2rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #f1f5f9;
    }

    .section-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.25rem;
        margin-left: 1rem;
    }

    .section-content h3 {
        font-size: 1.25rem;
        font-weight: 700;
        color: #1e293b;
        margin: 0 0 0.25rem 0;
    }

    .section-content p {
        font-size: 0.875rem;
        color: #64748b;
        margin: 0;
    }

    /* Modern Form Controls */
    .modern-input-group {
        margin-bottom: 1.5rem;
        position: relative;
    }

    .modern-label {
        font-size: 0.875rem;
        font-weight: 600;
        color: #374151;
        margin-bottom: 0.5rem;
        display: block;
    }

    .required-asterisk {
        color: #ef4444;
        margin-right: 0.25rem;
    }

    .modern-input,
    .modern-select,
    .modern-textarea {
        width: 100%;
        padding: 0.875rem 1rem;
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        font-size: 0.875rem;
        color: #374151;
        background: white;
        transition: all 0.3s ease;
        font-family: inherit;
    }

    .modern-input:focus,
    .modern-select:focus,
    .modern-textarea:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        transform: translateY(-1px);
    }

    .modern-input:hover,
    .modern-select:hover,
    .modern-textarea:hover {
        border-color: #d1d5db;
    }

    .modern-select {
        cursor: pointer;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3e%3c/svg%3e");
        background-position: left 0.75rem center;
        background-repeat: no-repeat;
        background-size: 1.5em 1.5em;
        padding-left: 2.5rem;
    }

    .modern-select:disabled {
        background-color: #f9fafb;
        color: #9ca3af;
        cursor: not-allowed;
        opacity: 0.7;
    }

    .modern-select option {
        padding: 0.5rem;
        color: #374151;
        background: white;
    }

    .modern-select optgroup {
        font-weight: 600;
        color: #6b7280;
        background: #f9fafb;
    }

    .input-help {
        font-size: 0.75rem;
        color: #6b7280;
        margin-top: 0.25rem;
        display: flex;
        align-items: center;
        gap: 0.25rem;
    }

    .input-error {
        color: #ef4444;
        font-size: 0.75rem;
        margin-top: 0.25rem;
        display: flex;
        align-items: center;
        gap: 0.25rem;
    }

    .modern-input.error,
    .modern-select.error,
    .modern-textarea.error {
        border-color: #ef4444;
        box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
    }

    /* Map Styles */
    .map-container {
        position: relative;
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        margin-bottom: 1rem;
    }

    #mapid {
        height: 400px;
        width: 100%;
        border: none;
    }

    .map-controls {
        position: absolute;
        top: 1rem;
        right: 1rem;
        z-index: 1000;
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }

    .map-btn {
        background: white;
        border: none;
        border-radius: 8px;
        padding: 0.75rem;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        cursor: pointer;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.875rem;
        font-weight: 500;
        color: #374151;
    }

    .map-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
    }

    .map-btn.primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .coordinates-display {
        background: #f8fafc;
        border-radius: 12px;
        padding: 1rem;
        margin-top: 1rem;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
    }

    .coordinate-item {
        display: flex;
        flex-direction: column;
        gap: 0.25rem;
    }

    .coordinate-label {
        font-size: 0.75rem;
        font-weight: 600;
        color: #6b7280;
    }

    .coordinate-value {
        font-size: 0.875rem;
        font-weight: 500;
        color: #374151;
        background: white;
        padding: 0.5rem;
        border-radius: 8px;
        border: 1px solid #e5e7eb;
    }

    /* Upload Area Styles */
    .upload-area {
        border: 2px dashed #d1d5db;
        border-radius: 16px;
        padding: 3rem 2rem;
        text-align: center;
        background: #f9fafb;
        transition: all 0.3s ease;
        cursor: pointer;
        position: relative;
        overflow: hidden;
    }

    .upload-area:hover {
        border-color: #667eea;
        background: #f0f4ff;
    }

    .upload-area.dragover {
        border-color: #667eea;
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.1), rgba(118, 75, 162, 0.1));
        transform: scale(1.02);
    }

    .upload-content {
        position: relative;
        z-index: 1;
    }

    .upload-icon {
        font-size: 3rem;
        color: #9ca3af;
        margin-bottom: 1rem;
        transition: all 0.3s ease;
    }

    .upload-area:hover .upload-icon {
        color: #667eea;
        transform: scale(1.1);
    }

    .upload-content h4 {
        font-size: 1.25rem;
        font-weight: 600;
        color: #374151;
        margin-bottom: 0.5rem;
    }

    .upload-content p {
        color: #6b7280;
        margin-bottom: 1rem;
    }

    .upload-input {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        cursor: pointer;
    }

    /* Image Preview Grid */
    .image-preview-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
        gap: 1rem;
        margin-top: 1rem;
    }

    .preview-item {
        position: relative;
        border-radius: 12px;
        overflow: hidden;
        background: white;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }

    .preview-item:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    }

    .preview-item img {
        width: 100%;
        height: 150px;
        object-fit: cover;
    }

    .preview-item .remove-btn {
        position: absolute;
        top: 0.5rem;
        right: 0.5rem;
        background: rgba(239, 68, 68, 0.9);
        color: white;
        border: none;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 0.875rem;
    }

    .preview-item .remove-btn:hover {
        background: #dc2626;
        transform: scale(1.1);
    }

    .preview-item .image-info {
        padding: 0.75rem;
        background: white;
    }

    .preview-item .image-name {
        font-size: 0.75rem;
        color: #374151;
        font-weight: 500;
        margin-bottom: 0.25rem;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .preview-item .image-size {
        font-size: 0.625rem;
        color: #6b7280;
    }

    /* Form Actions */
    .form-actions {
        background: white;
        border-radius: 16px;
        padding: 2rem;
        margin-top: 2rem;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .progress-info {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }

    .progress-text {
        font-size: 0.875rem;
        font-weight: 600;
        color: #374151;
    }

    .progress-bar-container {
        width: 200px;
        height: 8px;
        background: #e5e7eb;
        border-radius: 4px;
        overflow: hidden;
    }

    .progress-bar {
        height: 100%;
        background: linear-gradient(135deg, #667eea, #764ba2);
        border-radius: 4px;
        transition: width 0.3s ease;
        width: 0%;
    }

    .progress-percentage {
        font-size: 0.75rem;
        font-weight: 600;
        color: #667eea;
    }

    .submit-btn {
        background: linear-gradient(135deg, #667eea, #764ba2);
        border: none;
        border-radius: 12px;
        padding: 0.875rem 2rem;
        font-weight: 600;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
    }

    .submit-btn:disabled {
        opacity: 0.7;
        cursor: not-allowed;
        transform: none;
    }

    .btn-loading {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }

    /* Select2 Customization */
    .select2-container--default .select2-selection--multiple {
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        padding: 0.5rem;
        min-height: 50px;
    }

    .select2-container--default .select2-selection--multiple:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        background: linear-gradient(135deg, #667eea, #764ba2);
        border: none;
        border-radius: 8px;
        color: white;
        padding: 0.25rem 0.75rem;
        margin: 0.25rem;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
        color: white;
        margin-left: 0.5rem;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .wizard-header {
            padding: 1.5rem;
        }

        .wizard-title {
            font-size: 1.5rem;
        }

        .progress-steps {
            flex-direction: column;
            gap: 1rem;
        }

        .step {
            flex-direction: row;
            justify-content: flex-start;
            text-align: right;
        }

        .step-number {
            margin-bottom: 0;
            margin-left: 1rem;
        }

        .step-line {
            display: none;
        }

        .form-section {
            padding: 1.5rem;
        }

        .section-header {
            flex-direction: column;
            align-items: flex-start;
            text-align: right;
        }

        .section-icon {
            margin: 0 0 1rem 0;
        }

        .upload-area {
            padding: 2rem 1rem;
        }

        .form-actions .d-flex {
            flex-direction: column;
            gap: 1rem;
        }

        .progress-info {
            order: 2;
        }

        .action-buttons {
            order: 1;
            display: flex;
            gap: 1rem;
        }

        .action-buttons .btn {
            flex: 1;
        }

        .coordinates-display {
            grid-template-columns: 1fr;
        }

        .map-controls {
            position: static;
            display: flex;
            flex-direction: row;
            gap: 0.5rem;
            margin-bottom: 1rem;
        }

        .map-btn {
            flex: 1;
            font-size: 0.75rem;
            padding: 0.5rem;
        }
    }

    /* Animation */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .form-section {
        animation: fadeInUp 0.6s ease forwards;
    }

    .form-section:nth-child(1) { animation-delay: 0.1s; }
    .form-section:nth-child(2) { animation-delay: 0.2s; }
    .form-section:nth-child(3) { animation-delay: 0.3s; }
    .form-section:nth-child(4) { animation-delay: 0.4s; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">
            <div class="form-wizard">
                <!-- Wizard Header -->
                <div class="wizard-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h1 class="wizard-title">
                                <i class="fas fa-map-marker-alt me-3"></i>
                                ثبت مکان جدید
                            </h1>
                            <p class="wizard-subtitle">مکان خود را با جزئیات کامل معرفی کنید تا دیگران بتوانند آن را کشف کنند</p>
                        </div>
                        <a href="<?php echo e(route('user.locations.index')); ?>" class="btn btn-light btn-lg">
                            <i class="fas fa-arrow-right me-2"></i>
                            بازگشت
                        </a>
                    </div>

                    <!-- Progress Steps -->
                    <div class="progress-steps">
                        <div class="step active" data-step="1">
                            <div class="step-number">1</div>
                            <div class="step-title">اطلاعات اصلی</div>
                            <div class="step-line"></div>
                        </div>
                        <div class="step" data-step="2">
                            <div class="step-number">2</div>
                            <div class="step-title">موقعیت مکانی</div>
                            <div class="step-line"></div>
                        </div>
                        <div class="step" data-step="3">
                            <div class="step-number">3</div>
                            <div class="step-title">اطلاعات تماس</div>
                            <div class="step-line"></div>
                        </div>
                        <div class="step" data-step="4">
                            <div class="step-number">4</div>
                            <div class="step-title">تصاویر و جزئیات</div>
                        </div>
                    </div>
                </div>

                <!-- Form Content -->
                <div class="wizard-content p-4">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger border-0 shadow-sm mb-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-exclamation-triangle me-3 text-danger"></i>
                                <div>
                                    <h6 class="alert-heading mb-1">خطاهای زیر را برطرف کنید:</h6>
                                    <ul class="mb-0 list-unstyled">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="text-sm">• <?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <form action="<?php echo e(route('user.locations.store')); ?>" method="POST" enctype="multipart/form-data" id="locationForm">
                        <?php echo csrf_field(); ?>

                        <!-- Step 1: Basic Information -->
                        <div class="form-section" data-step="1">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-info-circle"></i>
                                </div>
                                <div class="section-content">
                                    <h3>اطلاعات اصلی مکان</h3>
                                    <p>نام، دسته‌بندی و توضیحات مکان خود را وارد کنید</p>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="title">
                                            <span class="required-asterisk">*</span>
                                            عنوان مکان
                                        </label>
                                        <input type="text"
                                               name="title"
                                               id="title"
                                               class="modern-input"
                                               value="<?php echo e(old('title')); ?>"
                                               placeholder="مثال: رستوران سنتی کوهستان"
                                               required>
                                        <div class="input-help">
                                            <i class="fas fa-info-circle"></i>
                                            نام مکان را به صورت واضح و جذاب وارد کنید
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="category_id">
                                            <span class="required-asterisk">*</span>
                                            دسته‌بندی
                                        </label>
                                        <select name="category_id" id="category_id" class="modern-select" required>
                                            <option value="">دسته‌بندی مناسب را انتخاب کنید</option>
                                            <?php $__currentLoopData = $categoriesForDropdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($category['is_parent']): ?>
                                                    <optgroup label="<?php echo e($category['text']); ?>">
                                                        <option value="<?php echo e($category['id']); ?>" <?php echo e(old('category_id') == $category['id'] ? 'selected' : ''); ?>>
                                                            <?php echo e($category['emoji'] ?? '📍'); ?> <?php echo e($category['text']); ?>

                                                        </option>
                                                        <?php $__currentLoopData = $categoriesForDropdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(!$childCategory['is_parent'] && isset($childCategory['parent_id']) && $childCategory['parent_id'] == $category['id']): ?>
                                                                <option value="<?php echo e($childCategory['id']); ?>" <?php echo e(old('category_id') == $childCategory['id'] ? 'selected' : ''); ?>>
                                                                    <?php echo e($childCategory['emoji'] ?? '📍'); ?> <?php echo e($childCategory['text']); ?>

                                                                </option>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </optgroup>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-tags"></i>
                                            دسته‌بندی مناسب برای مکان خود انتخاب کنید
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="description">
                                            <span class="required-asterisk">*</span>
                                            توضیحات مکان
                                        </label>
                                        <textarea name="description"
                                                  id="description"
                                                  class="modern-textarea"
                                                  rows="4"
                                                  placeholder="توضیح کاملی از مکان، امکانات، ویژگی‌ها و تجربه‌ای که ارائه می‌دهد بنویسید..."
                                                  required><?php echo e(old('description')); ?></textarea>
                                        <div class="input-help">
                                            <i class="fas fa-pen"></i>
                                            توضیحات جذاب و کامل باعث جلب توجه بیشتر کاربران می‌شود
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Step 2: Location Information -->
                        <div class="form-section" data-step="2">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-map-marked-alt"></i>
                                </div>
                                <div class="section-content">
                                    <h3>موقعیت جغرافیایی</h3>
                                    <p>آدرس دقیق و موقعیت مکان خود را مشخص کنید</p>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="country_id">
                                            <span class="required-asterisk">*</span>
                                            کشور
                                        </label>
                                        <select name="country_id" id="country_id" class="modern-select" required>
                                            <option value="">کشور را انتخاب کنید</option>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country->id); ?>" <?php echo e(old('country_id', 1) == $country->id ? 'selected' : ''); ?>>
                                                    <?php echo e($country->flag ?? '🏳️'); ?> <?php echo e($country->name ?? $country->name_fa ?? $country->native_name ?? $country->name_en); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-globe"></i>
                                            کشور محل قرارگیری مکان
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="province_id">
                                            <span class="required-asterisk">*</span>
                                            استان
                                        </label>
                                        <select name="province_id" id="province_id" class="modern-select" required <?php echo e(old('country_id', 1) == 1 ? '' : 'disabled'); ?>>
                                            <option value="">استان را انتخاب کنید</option>
                                            <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($province->id); ?>" <?php echo e(old('province_id') == $province->id ? 'selected' : ''); ?>>
                                                    <?php echo e($province->name_fa ?? $province->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-map"></i>
                                            ابتدا کشور را انتخاب کنید
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="county_id">
                                            <span class="required-asterisk">*</span>
                                            شهرستان
                                        </label>
                                        <select name="county_id" id="county_id" class="modern-select" required <?php echo e(old('province_id') ? '' : 'disabled'); ?>>
                                            <option value="">ابتدا استان را انتخاب کنید</option>
                                            <?php if(old('county_id') && old('province_id')): ?>
                                                <?php $__currentLoopData = $counties->where('province_id', old('province_id')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $county): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($county->id); ?>" <?php echo e(old('county_id') == $county->id ? 'selected' : ''); ?>>
                                                        <?php echo e($county->name_fa ?? $county->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-city"></i>
                                            شهرستان محل قرارگیری مکان
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="city_id">
                                            <span class="required-asterisk">*</span>
                                            شهر
                                        </label>
                                        <select name="city_id" id="city_id" class="modern-select" required <?php echo e(old('county_id') ? '' : 'disabled'); ?>>
                                            <option value="">ابتدا شهرستان را انتخاب کنید</option>
                                            <?php if(old('city_id') && old('county_id')): ?>
                                                <?php $__currentLoopData = $cities->where('county_id', old('county_id')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($city->id); ?>" <?php echo e(old('city_id') == $city->id ? 'selected' : ''); ?>>
                                                        <?php echo e($city->name_fa ?? $city->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-building"></i>
                                            شهر محل قرارگیری مکان
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="district_id">بخش</label>
                                        <select name="district_id" id="district_id" class="modern-select" <?php echo e(old('county_id') ? '' : 'disabled'); ?>>
                                            <option value="">انتخاب کنید (اختیاری)</option>
                                            <?php if(old('district_id') && old('county_id')): ?>
                                                <?php $__currentLoopData = $districts->where('county_id', old('county_id')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($district->id); ?>" <?php echo e(old('district_id') == $district->id ? 'selected' : ''); ?>>
                                                        <?php echo e($district->name_fa ?? $district->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-map-pin"></i>
                                            بخش یا ناحیه (در صورت وجود)
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="village_id">روستا</label>
                                        <select name="village_id" id="village_id" class="modern-select" <?php echo e(old('district_id') ? '' : 'disabled'); ?>>
                                            <option value="">انتخاب کنید (اختیاری)</option>
                                            <?php if(old('village_id') && old('district_id')): ?>
                                                <?php $__currentLoopData = $villages->where('district_id', old('district_id')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $village): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($village->id); ?>" <?php echo e(old('village_id') == $village->id ? 'selected' : ''); ?>>
                                                        <?php echo e($village->name_fa ?? $village->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-home"></i>
                                            روستا (در صورت وجود)
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-8">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="address">
                                            <span class="required-asterisk">*</span>
                                            آدرس دقیق
                                        </label>
                                        <textarea name="address"
                                                  id="address"
                                                  class="modern-textarea"
                                                  rows="3"
                                                  placeholder="آدرس کامل و دقیق مکان را وارد کنید..."
                                                  required><?php echo e(old('address')); ?></textarea>
                                        <div class="input-help">
                                            <i class="fas fa-location-arrow"></i>
                                            آدرس کامل شامل خیابان، کوچه و پلاک
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="zone_id">منطقه</label>
                                        <select name="zone_id" id="zone_id" class="modern-select" <?php echo e(old('city_id') ? '' : 'disabled'); ?>>
                                            <option value="">انتخاب کنید (اختیاری)</option>
                                            <?php if(old('zone_id') && old('city_id')): ?>
                                                <?php $__currentLoopData = $zones->where('city_id', old('city_id')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($zone->id); ?>" <?php echo e(old('zone_id') == $zone->id ? 'selected' : ''); ?>>
                                                        <?php echo e($zone->name_fa ?? $zone->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-layer-group"></i>
                                            منطقه شهری (در صورت وجود)
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Interactive Map Section -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="modern-input-group">
                                        <label class="modern-label">
                                            <span class="required-asterisk">*</span>
                                            موقعیت جغرافیایی روی نقشه
                                        </label>
                                        <div class="input-help mb-3">
                                            <i class="fas fa-mouse-pointer"></i>
                                            روی نقشه کلیک کنید تا موقعیت دقیق مکان مشخص شود
                                        </div>

                                        <div class="map-container">
                                            <div class="map-controls">
                                                <button type="button" id="get-location-btn" class="map-btn primary">
                                                    <i class="fas fa-crosshairs"></i>
                                                    موقعیت فعلی من
                                                </button>
                                                <button type="button" id="search-address-btn" class="map-btn">
                                                    <i class="fas fa-search"></i>
                                                    جستجو در نقشه
                                                </button>
                                            </div>
                                            <div id="mapid"></div>
                                        </div>

                                        <div class="coordinates-display">
                                            <div class="coordinate-item">
                                                <div class="coordinate-label">طول جغرافیایی (Longitude)</div>
                                                <input type="text" name="longitude" id="longitude" class="coordinate-value" value="<?php echo e(old('longitude')); ?>" readonly>
                                            </div>
                                            <div class="coordinate-item">
                                                <div class="coordinate-label">عرض جغرافیایی (Latitude)</div>
                                                <input type="text" name="latitude" id="latitude" class="coordinate-value" value="<?php echo e(old('latitude')); ?>" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Step 3: Contact Information -->
                        <div class="form-section" data-step="3">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="section-content">
                                    <h3>اطلاعات تماس و دسترسی</h3>
                                    <p>راه‌های ارتباط و ساعات کاری مکان را مشخص کنید</p>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="phone">شماره تماس</label>
                                        <input type="tel"
                                               name="phone"
                                               id="phone"
                                               class="modern-input"
                                               value="<?php echo e(old('phone')); ?>"
                                               placeholder="مثال: 021-12345678">
                                        <div class="input-help">
                                            <i class="fas fa-phone-alt"></i>
                                            شماره تماس مکان (اختیاری)
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="website">وب‌سایت</label>
                                        <input type="url"
                                               name="website"
                                               id="website"
                                               class="modern-input"
                                               value="<?php echo e(old('website')); ?>"
                                               placeholder="https://example.com">
                                        <div class="input-help">
                                            <i class="fas fa-globe"></i>
                                            آدرس وب‌سایت مکان (اختیاری)
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="working_hours">ساعات کاری</label>
                                        <input type="text"
                                               name="working_hours"
                                               id="working_hours"
                                               class="modern-input"
                                               value="<?php echo e(old('working_hours')); ?>"
                                               placeholder="مثال: 8:00 تا 22:00">
                                        <div class="input-help">
                                            <i class="fas fa-clock"></i>
                                            ساعات فعالیت مکان (اختیاری)
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Step 4: Images and Additional Details -->
                        <div class="form-section" data-step="4">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-images"></i>
                                </div>
                                <div class="section-content">
                                    <h3>تصاویر و جزئیات تکمیلی</h3>
                                    <p>تصاویر جذاب و اطلاعات تکمیلی مکان خود را اضافه کنید</p>
                                </div>
                            </div>

                            <!-- Image Upload Section -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <div class="modern-input-group">
                                        <label class="modern-label">
                                            <span class="required-asterisk">*</span>
                                            تصاویر مکان
                                        </label>
                                        <div class="upload-area" id="uploadArea">
                                            <div class="upload-content">
                                                <i class="fas fa-cloud-upload-alt upload-icon"></i>
                                                <h4>تصاویر خود را اینجا بکشید یا کلیک کنید</h4>
                                                <p>حداقل یک تصویر الزامی است • حداکثر 5 تصویر • هر تصویر حداکثر 2MB</p>
                                                <input type="file" name="images[]" id="images" class="upload-input" multiple accept="image/*" required>
                                                <button type="button" class="btn btn-primary mt-2" onclick="document.getElementById('images').click()">
                                                    <i class="fas fa-plus me-2"></i>انتخاب تصاویر
                                                </button>
                                            </div>
                                        </div>
                                        <div class="image-preview-grid" id="imagePreview"></div>
                                    </div>
                                </div>
                            </div>

                            <!-- Additional Information -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="facilities">امکانات موجود</label>
                                        <select name="facilities[]" id="facilities" class="modern-select select2-multiple" multiple>
                                            <option value="پارکینگ" <?php echo e(in_array('پارکینگ', old('facilities', [])) ? 'selected' : ''); ?>>🅿️ پارکینگ</option>
                                            <option value="رستوران" <?php echo e(in_array('رستوران', old('facilities', [])) ? 'selected' : ''); ?>>🍽️ رستوران</option>
                                            <option value="کافی‌شاپ" <?php echo e(in_array('کافی‌شاپ', old('facilities', [])) ? 'selected' : ''); ?>>☕ کافی‌شاپ</option>
                                            <option value="سرویس بهداشتی" <?php echo e(in_array('سرویس بهداشتی', old('facilities', [])) ? 'selected' : ''); ?>>🚻 سرویس بهداشتی</option>
                                            <option value="دسترسی معلولین" <?php echo e(in_array('دسترسی معلولین', old('facilities', [])) ? 'selected' : ''); ?>>♿ دسترسی معلولین</option>
                                            <option value="فروشگاه" <?php echo e(in_array('فروشگاه', old('facilities', [])) ? 'selected' : ''); ?>>🛍️ فروشگاه</option>
                                            <option value="WiFi رایگان" <?php echo e(in_array('WiFi رایگان', old('facilities', [])) ? 'selected' : ''); ?>>📶 WiFi رایگان</option>
                                            <option value="تراس" <?php echo e(in_array('تراس', old('facilities', [])) ? 'selected' : ''); ?>>🏞️ تراس</option>
                                            <option value="باغ" <?php echo e(in_array('باغ', old('facilities', [])) ? 'selected' : ''); ?>>🌳 باغ</option>
                                            <option value="استخر" <?php echo e(in_array('استخر', old('facilities', [])) ? 'selected' : ''); ?>>🏊 استخر</option>
                                        </select>
                                        <div class="input-help">
                                            <i class="fas fa-list-check"></i>
                                            امکانات و خدمات موجود در مکان
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="tags">برچسب‌ها</label>
                                        <input type="text"
                                               name="tags"
                                               id="tags"
                                               class="modern-input"
                                               value="<?php echo e(old('tags')); ?>"
                                               placeholder="مثال: طبیعت، کوهستان، آرامش">
                                        <div class="input-help">
                                            <i class="fas fa-hashtag"></i>
                                            برچسب‌ها را با کاما جدا کنید
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="entrance_fee">هزینه ورودی</label>
                                        <input type="text"
                                               name="entrance_fee"
                                               id="entrance_fee"
                                               class="modern-input"
                                               value="<?php echo e(old('entrance_fee')); ?>"
                                               placeholder="مثال: رایگان یا 50,000 تومان">
                                        <div class="input-help">
                                            <i class="fas fa-money-bill"></i>
                                            هزینه ورود به مکان (اختیاری)
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="visit_duration">زمان مورد نیاز برای بازدید</label>
                                        <input type="text"
                                               name="visit_duration"
                                               id="visit_duration"
                                               class="modern-input"
                                               value="<?php echo e(old('visit_duration')); ?>"
                                               placeholder="مثال: 2-3 ساعت">
                                        <div class="input-help">
                                            <i class="fas fa-hourglass-half"></i>
                                            زمان پیشنهادی برای بازدید کامل
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="best_time_to_visit">بهترین زمان بازدید</label>
                                        <input type="text"
                                               name="best_time_to_visit"
                                               id="best_time_to_visit"
                                               class="modern-input"
                                               value="<?php echo e(old('best_time_to_visit')); ?>"
                                               placeholder="مثال: بهار و پاییز">
                                        <div class="input-help">
                                            <i class="fas fa-calendar-alt"></i>
                                            بهترین فصل یا زمان برای بازدید
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="features">ویژگی‌های خاص</label>
                                        <input type="text"
                                               name="features"
                                               id="features"
                                               class="modern-input"
                                               value="<?php echo e(old('features')); ?>"
                                               placeholder="مثال: منظره زیبا، هوای پاک، آرامش">
                                        <div class="input-help">
                                            <i class="fas fa-star"></i>
                                            ویژگی‌های منحصر به فرد مکان
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="modern-input-group">
                                        <label class="modern-label" for="rules">قوانین و نکات مهم</label>
                                        <textarea name="rules"
                                                  id="rules"
                                                  class="modern-textarea"
                                                  rows="3"
                                                  placeholder="قوانین بازدید، نکات ایمنی، محدودیت‌ها و توصیه‌های مهم..."><?php echo e(old('rules')); ?></textarea>
                                        <div class="input-help">
                                            <i class="fas fa-exclamation-triangle"></i>
                                            قوانین و نکات مهم برای بازدیدکنندگان
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Submit Section -->
                        <div class="form-actions">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="form-progress">
                                    <div class="progress-info">
                                        <span class="progress-text">پیشرفت تکمیل فرم</span>
                                        <div class="progress-bar-container">
                                            <div class="progress-bar" id="formProgress"></div>
                                        </div>
                                        <span class="progress-percentage" id="progressPercentage">0%</span>
                                    </div>
                                </div>
                                <div class="action-buttons">
                                    <button type="button" class="btn btn-outline-secondary btn-lg me-3" onclick="window.history.back()">
                                        <i class="fas fa-times me-2"></i>
                                        انصراف
                                    </button>
                                    <button type="submit" class="btn btn-primary btn-lg submit-btn" id="submitBtn">
                                        <i class="fas fa-paper-plane me-2"></i>
                                        ثبت مکان
                                        <div class="btn-loading" style="display: none;">
                                            <i class="fas fa-spinner fa-spin"></i>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>
<script>
$(document).ready(function() {
    console.log('Document ready, jQuery version:', $.fn.jquery);
    // Modern Form Handler Class
    class ModernLocationForm {
        constructor() {
            this.currentStep = 1;
            this.totalSteps = 4;
            this.map = null;
            this.marker = null;
            this.selectedFiles = [];
            this.maxFiles = 5;
            this.maxFileSize = 2 * 1024 * 1024; // 2MB

            this.init();
        }

        init() {
            console.log('Initializing ModernLocationForm...');

            // Wait a bit for DOM to be fully ready
            setTimeout(() => {
                this.initializeMap();
                this.initializeSelect2();
                this.initializeImageUpload();
                this.initializeFormValidation();
                this.initializeProgressTracking();
                this.initializeCascadingDropdowns();
                this.updateProgress();

                // Force initial state check
                this.forceInitialState();
            }, 100);
        }

        // Force initial dropdown states
        forceInitialState() {
            console.log('Forcing initial dropdown states...');

            // Check if Iran is selected
            const countryId = $('#country_id').val();
            console.log('Initial country ID:', countryId);

            if (countryId == 1 || countryId == '1') {
                console.log('Iran is selected, enabling province dropdown');
                $('#province_id').prop('disabled', false);

                // Trigger change event to cascade
                $('#country_id').trigger('change');
            }
        }

        // Initialize Interactive Map
        initializeMap() {
            this.map = L.map('mapid').setView([32.4279, 53.6880], 5);

            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
                maxZoom: 19
            }).addTo(this.map);

            // Set marker from old values if exists
            <?php if(old('latitude') && old('longitude')): ?>
                this.marker = L.marker([<?php echo e(old('latitude')); ?>, <?php echo e(old('longitude')); ?>]).addTo(this.map);
                this.map.setView([<?php echo e(old('latitude')); ?>, <?php echo e(old('longitude')); ?>], 13);
            <?php endif; ?>

            // Add marker on click
            this.map.on('click', (e) => {
                this.addMarker(e.latlng.lat, e.latlng.lng);
            });

            // Get user's current location
            document.getElementById('get-location-btn').addEventListener('click', () => {
                this.getCurrentLocation();
            });
        }

        addMarker(lat, lng) {
            if (this.marker) {
                this.map.removeLayer(this.marker);
            }

            this.marker = L.marker([lat, lng]).addTo(this.map);

            // Set form values
            document.getElementById('latitude').value = lat.toFixed(6);
            document.getElementById('longitude').value = lng.toFixed(6);

            // Update progress
            this.updateProgress();

            // Show success animation
            this.showNotification('موقعیت با موفقیت انتخاب شد', 'success');
        }

        getCurrentLocation() {
            if (!navigator.geolocation) {
                this.showNotification('مرورگر شما از سرویس موقعیت‌یابی پشتیبانی نمی‌کند', 'error');
                return;
            }

            const btn = document.getElementById('get-location-btn');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال دریافت...';
            btn.disabled = true;

            navigator.geolocation.getCurrentPosition(
                (position) => {
                    const lat = position.coords.latitude;
                    const lng = position.coords.longitude;

                    this.addMarker(lat, lng);
                    this.map.setView([lat, lng], 15);

                    btn.innerHTML = originalText;
                    btn.disabled = false;
                },
                (error) => {
                    let message = 'خطا در دریافت موقعیت: ';
                    switch (error.code) {
                        case error.PERMISSION_DENIED:
                            message += 'دسترسی به موقعیت مکانی رد شد';
                            break;
                        case error.POSITION_UNAVAILABLE:
                            message += 'اطلاعات موقعیت در دسترس نیست';
                            break;
                        case error.TIMEOUT:
                            message += 'درخواست با تایم‌اوت مواجه شد';
                            break;
                        default:
                            message += 'خطای ناشناخته';
                            break;
                    }

                    this.showNotification(message, 'error');
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                },
                {
                    enableHighAccuracy: true,
                    timeout: 10000,
                    maximumAge: 60000
                }
            );
        }

        // Initialize Select2
        initializeSelect2() {
            $('.select2-multiple').select2({
                dir: 'rtl',
                language: 'fa',
                placeholder: 'انتخاب کنید',
                allowClear: true,
                width: '100%'
            });
        }

        // Initialize Image Upload with Drag & Drop
        initializeImageUpload() {
            const uploadArea = document.getElementById('uploadArea');
            const fileInput = document.getElementById('images');
            const previewContainer = document.getElementById('imagePreview');

            // Drag and drop events
            uploadArea.addEventListener('dragover', (e) => {
                e.preventDefault();
                uploadArea.classList.add('dragover');
            });

            uploadArea.addEventListener('dragleave', (e) => {
                e.preventDefault();
                uploadArea.classList.remove('dragover');
            });

            uploadArea.addEventListener('drop', (e) => {
                e.preventDefault();
                uploadArea.classList.remove('dragover');

                const files = Array.from(e.dataTransfer.files);
                this.handleFiles(files);
            });

            // File input change
            fileInput.addEventListener('change', (e) => {
                const files = Array.from(e.target.files);
                this.handleFiles(files);
            });
        }

        handleFiles(files) {
            // Filter valid image files
            const validFiles = files.filter(file => {
                if (!file.type.startsWith('image/')) {
                    this.showNotification(`فایل ${file.name} یک تصویر معتبر نیست`, 'error');
                    return false;
                }

                if (file.size > this.maxFileSize) {
                    this.showNotification(`حجم فایل ${file.name} بیش از 2MB است`, 'error');
                    return false;
                }

                return true;
            });

            // Check total files limit
            if (this.selectedFiles.length + validFiles.length > this.maxFiles) {
                this.showNotification(`حداکثر ${this.maxFiles} تصویر می‌توانید انتخاب کنید`, 'error');
                return;
            }

            // Add files to selection
            validFiles.forEach(file => {
                this.selectedFiles.push(file);
                this.createImagePreview(file);
            });

            this.updateFileInput();
            this.updateProgress();
        }

        createImagePreview(file) {
            const reader = new FileReader();
            const previewContainer = document.getElementById('imagePreview');

            reader.onload = (e) => {
                const previewItem = document.createElement('div');
                previewItem.className = 'preview-item';
                previewItem.dataset.fileName = file.name;

                previewItem.innerHTML = `
                    <img src="${e.target.result}" alt="${file.name}">
                    <button type="button" class="remove-btn" onclick="locationForm.removeImage('${file.name}')">
                        <i class="fas fa-times"></i>
                    </button>
                    <div class="image-info">
                        <div class="image-name">${file.name}</div>
                        <div class="image-size">${this.formatFileSize(file.size)}</div>
                    </div>
                `;

                previewContainer.appendChild(previewItem);
            };

            reader.readAsDataURL(file);
        }

        removeImage(fileName) {
            // Remove from selected files
            this.selectedFiles = this.selectedFiles.filter(file => file.name !== fileName);

            // Remove preview
            const previewItem = document.querySelector(`[data-file-name="${fileName}"]`);
            if (previewItem) {
                previewItem.remove();
            }

            this.updateFileInput();
            this.updateProgress();
        }

        updateFileInput() {
            const fileInput = document.getElementById('images');
            const dt = new DataTransfer();

            this.selectedFiles.forEach(file => {
                dt.items.add(file);
            });

            fileInput.files = dt.files;
        }

        formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }

        // Initialize Form Validation
        initializeFormValidation() {
            const form = document.getElementById('locationForm');
            const submitBtn = document.getElementById('submitBtn');

            form.addEventListener('submit', (e) => {
                e.preventDefault();

                if (this.validateForm()) {
                    this.submitForm();
                }
            });

            // Real-time validation
            const requiredFields = form.querySelectorAll('[required]');
            requiredFields.forEach(field => {
                field.addEventListener('blur', () => {
                    this.validateField(field);
                    this.updateProgress();
                });

                field.addEventListener('input', () => {
                    this.clearFieldError(field);
                });
            });
        }

        validateForm() {
            const form = document.getElementById('locationForm');
            const requiredFields = form.querySelectorAll('[required]');
            let isValid = true;

            requiredFields.forEach(field => {
                if (!this.validateField(field)) {
                    isValid = false;
                }
            });

            // Validate coordinates
            const lat = document.getElementById('latitude').value;
            const lng = document.getElementById('longitude').value;

            if (!lat || !lng) {
                this.showNotification('لطفاً موقعیت مکان را روی نقشه انتخاب کنید', 'error');
                isValid = false;
            }

            // Validate images
            if (this.selectedFiles.length === 0) {
                this.showNotification('لطفاً حداقل یک تصویر انتخاب کنید', 'error');
                isValid = false;
            }

            return isValid;
        }

        validateField(field) {
            const value = field.value.trim();
            let isValid = true;

            if (field.hasAttribute('required') && !value) {
                this.showFieldError(field, 'این فیلد الزامی است');
                isValid = false;
            } else if (field.type === 'email' && value && !this.isValidEmail(value)) {
                this.showFieldError(field, 'فرمت ایمیل صحیح نیست');
                isValid = false;
            } else if (field.type === 'url' && value && !this.isValidUrl(value)) {
                this.showFieldError(field, 'فرمت URL صحیح نیست');
                isValid = false;
            } else {
                this.clearFieldError(field);
            }

            return isValid;
        }

        showFieldError(field, message) {
            field.classList.add('error');

            let errorElement = field.parentNode.querySelector('.input-error');
            if (!errorElement) {
                errorElement = document.createElement('div');
                errorElement.className = 'input-error';
                field.parentNode.appendChild(errorElement);
            }

            errorElement.innerHTML = `<i class="fas fa-exclamation-circle"></i> ${message}`;
        }

        clearFieldError(field) {
            field.classList.remove('error');
            const errorElement = field.parentNode.querySelector('.input-error');
            if (errorElement) {
                errorElement.remove();
            }
        }

        isValidEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }

        isValidUrl(url) {
            try {
                new URL(url);
                return true;
            } catch {
                return false;
            }
        }

        // Initialize Progress Tracking
        initializeProgressTracking() {
            // Update progress on form changes
            const form = document.getElementById('locationForm');
            form.addEventListener('input', () => {
                setTimeout(() => this.updateProgress(), 100);
            });

            form.addEventListener('change', () => {
                setTimeout(() => this.updateProgress(), 100);
            });
        }

        updateProgress() {
            const form = document.getElementById('locationForm');
            const requiredFields = form.querySelectorAll('[required]');
            const totalFields = requiredFields.length + 2; // +2 for coordinates and images

            let completedFields = 0;

            // Check required fields
            requiredFields.forEach(field => {
                if (field.value.trim()) {
                    completedFields++;
                }
            });

            // Check coordinates
            const lat = document.getElementById('latitude').value;
            const lng = document.getElementById('longitude').value;
            if (lat && lng) {
                completedFields++;
            }

            // Check images
            if (this.selectedFiles.length > 0) {
                completedFields++;
            }

            const percentage = Math.round((completedFields / totalFields) * 100);

            // Update progress bar
            const progressBar = document.getElementById('formProgress');
            const progressText = document.getElementById('progressPercentage');

            if (progressBar && progressText) {
                progressBar.style.width = percentage + '%';
                progressText.textContent = percentage + '%';
            }

            // Update step indicators
            this.updateStepIndicators();
        }

        updateStepIndicators() {
            const steps = document.querySelectorAll('.step');

            steps.forEach((step, index) => {
                const stepNumber = index + 1;
                const stepData = step.dataset.step;

                if (this.isStepCompleted(stepNumber)) {
                    step.classList.add('completed');
                    step.classList.remove('active');
                } else if (stepNumber === this.currentStep) {
                    step.classList.add('active');
                    step.classList.remove('completed');
                } else {
                    step.classList.remove('active', 'completed');
                }
            });
        }

        isStepCompleted(stepNumber) {
            switch (stepNumber) {
                case 1: // Basic Information
                    const title = document.getElementById('title').value;
                    const category = document.getElementById('category_id').value;
                    const description = document.getElementById('description').value;
                    return title && category && description;

                case 2: // Location Information
                    const country = document.getElementById('country_id').value;
                    const province = document.getElementById('province_id').value;
                    const county = document.getElementById('county_id').value;
                    const city = document.getElementById('city_id').value;
                    const address = document.getElementById('address').value;
                    const lat = document.getElementById('latitude').value;
                    const lng = document.getElementById('longitude').value;
                    return country && province && county && city && address && lat && lng;

                case 3: // Contact Information (optional)
                    return true; // This step is optional

                case 4: // Images and Additional Details
                    return this.selectedFiles.length > 0;

                default:
                    return false;
            }
        }

        // Initialize Cascading Dropdowns
        initializeCascadingDropdowns() {
            const self = this;

            // Wait for DOM to be fully ready
            $(document).ready(function() {
                console.log('Initializing cascading dropdowns...');

                // Country change event
                $(document).on('change', '#country_id', function() {
                    const countryId = $(this).val();
                    console.log('Country changed:', countryId);

                    if (countryId == 1) { // Iran
                        $('#province_id').prop('disabled', false);
                        console.log('Province dropdown enabled');
                    } else {
                        self.resetLocationDropdowns();
                    }
                    self.updateProgress();
                });

                // Province change event
                $(document).on('change', '#province_id', function() {
                    const provinceId = $(this).val();
                    console.log('Province changed:', provinceId);

                    if (provinceId) {
                        $('#county_id').prop('disabled', false);
                        self.loadCounties(provinceId);
                        self.resetSubLocationDropdowns();
                        console.log('County dropdown enabled');
                    } else {
                        self.resetSubLocationDropdowns();
                    }
                    self.updateProgress();
                });

                // County change event
                $(document).on('change', '#county_id', function() {
                    const countyId = $(this).val();
                    console.log('County changed:', countyId);

                    if (countyId) {
                        $('#city_id').prop('disabled', false);
                        $('#district_id').prop('disabled', false);
                        self.loadCities(countyId);
                        self.loadDistricts(countyId);
                        self.resetDependentDropdowns();
                        console.log('City and District dropdowns enabled');
                    } else {
                        self.resetDependentDropdowns();
                    }
                    self.updateProgress();
                });

                // City change event
                $(document).on('change', '#city_id', function() {
                    const cityId = $(this).val();
                    console.log('City changed:', cityId);

                    if (cityId) {
                        $('#zone_id').prop('disabled', false);
                        self.loadZones(cityId);
                        console.log('Zone dropdown enabled');
                    } else {
                        $('#zone_id').html('<option value="">انتخاب کنید</option>').prop('disabled', true);
                    }
                    self.updateProgress();
                });

                // District change event
                $(document).on('change', '#district_id', function() {
                    const districtId = $(this).val();
                    console.log('District changed:', districtId);

                    if (districtId) {
                        $('#village_id').prop('disabled', false);
                        self.loadVillages(districtId);
                        console.log('Village dropdown enabled');
                    } else {
                        $('#village_id').html('<option value="">انتخاب کنید</option>').prop('disabled', true);
                    }
                    self.updateProgress();
                });

                // Initialize state based on current values
                self.initializeDropdownStates();
            });
        }

        // Initialize dropdown states based on current values
        initializeDropdownStates() {
            // Use setTimeout to ensure DOM is fully ready
            setTimeout(() => {
                const countryId = $('#country_id').val();
                const provinceId = $('#province_id').val();
                const countyId = $('#county_id').val();
                const cityId = $('#city_id').val();
                const districtId = $('#district_id').val();

                console.log('Initializing dropdown states:', {
                    countryId, provinceId, countyId, cityId, districtId
                });

                // Force enable province for Iran
                if (countryId == 1 || countryId == '1') {
                    console.log('Enabling province dropdown for Iran');
                    $('#province_id').prop('disabled', false);

                    if (provinceId) {
                        console.log('Enabling county dropdown');
                        $('#county_id').prop('disabled', false);

                        if (countyId) {
                            console.log('Enabling city and district dropdowns');
                            $('#city_id').prop('disabled', false);
                            $('#district_id').prop('disabled', false);

                            if (cityId) {
                                console.log('Enabling zone dropdown');
                                $('#zone_id').prop('disabled', false);
                            }

                            if (districtId) {
                                console.log('Enabling village dropdown');
                                $('#village_id').prop('disabled', false);
                            }
                        }
                    }
                } else {
                    console.log('Country is not Iran, disabling all location dropdowns');
                    this.resetLocationDropdowns();
                }
            }, 500);
        }

        resetLocationDropdowns() {
            console.log('Resetting location dropdowns');
            $('#province_id').html('<option value="">انتخاب کنید</option>').prop('disabled', true);
            this.resetSubLocationDropdowns();
        }

        resetSubLocationDropdowns() {
            console.log('Resetting sub-location dropdowns');
            $('#county_id').html('<option value="">ابتدا استان را انتخاب کنید</option>').prop('disabled', true);
            this.resetDependentDropdowns();
        }

        resetDependentDropdowns() {
            console.log('Resetting dependent dropdowns');
            $('#city_id').html('<option value="">ابتدا شهرستان را انتخاب کنید</option>').prop('disabled', true);
            $('#district_id').html('<option value="">انتخاب کنید</option>').prop('disabled', true);
            $('#village_id').html('<option value="">انتخاب کنید</option>').prop('disabled', true);
            $('#zone_id').html('<option value="">انتخاب کنید</option>').prop('disabled', true);
        }

        async loadCounties(provinceId) {
            console.log('Loading counties for province:', provinceId);

            // Show loading state
            $('#county_id').html('<option value="">در حال بارگیری...</option>').prop('disabled', true);

            try {
                const response = await fetch(`/api/provinces/${provinceId}/counties`);
                const result = await response.json();

                console.log('Counties response:', result);

                if (result.success && result.data) {
                    let options = '<option value="">شهرستان را انتخاب کنید</option>';
                    result.data.forEach(county => {
                        const name = county.name_fa || county.name;
                        options += `<option value="${county.id}">${name}</option>`;
                    });

                    $('#county_id').html(options).prop('disabled', false);
                    console.log(`Loaded ${result.data.length} counties`);
                } else {
                    throw new Error(result.message || 'خطا در دریافت شهرستان‌ها');
                }
            } catch (error) {
                console.error('Error loading counties:', error);
                $('#county_id').html('<option value="">خطا در بارگیری</option>').prop('disabled', true);
                this.showNotification('خطا در بارگیری شهرستان‌ها', 'error');
            }
        }

        async loadCities(countyId) {
            console.log('Loading cities for county:', countyId);

            // Show loading state
            $('#city_id').html('<option value="">در حال بارگیری...</option>').prop('disabled', true);

            try {
                const response = await fetch(`/api/counties/${countyId}/cities`);
                const result = await response.json();

                console.log('Cities response:', result);

                if (result.success && result.data) {
                    let options = '<option value="">شهر را انتخاب کنید</option>';
                    result.data.forEach(city => {
                        const name = city.name_fa || city.name;
                        options += `<option value="${city.id}">${name}</option>`;
                    });

                    $('#city_id').html(options).prop('disabled', false);
                    console.log(`Loaded ${result.data.length} cities`);
                } else {
                    throw new Error(result.message || 'خطا در دریافت شهرها');
                }
            } catch (error) {
                console.error('Error loading cities:', error);
                $('#city_id').html('<option value="">خطا در بارگیری</option>').prop('disabled', true);
                this.showNotification('خطا در بارگیری شهرها', 'error');
            }
        }

        async loadDistricts(countyId) {
            console.log('Loading districts for county:', countyId);

            // Show loading state
            $('#district_id').html('<option value="">در حال بارگیری...</option>').prop('disabled', true);

            try {
                const response = await fetch(`/api/counties/${countyId}/districts`);
                const result = await response.json();

                console.log('Districts response:', result);

                if (result.success && result.data) {
                    let options = '<option value="">انتخاب کنید</option>';
                    result.data.forEach(district => {
                        const name = district.name_fa || district.name;
                        options += `<option value="${district.id}">${name}</option>`;
                    });

                    $('#district_id').html(options).prop('disabled', false);
                    console.log(`Loaded ${result.data.length} districts`);
                } else {
                    throw new Error(result.message || 'خطا در دریافت بخش‌ها');
                }
            } catch (error) {
                console.error('Error loading districts:', error);
                $('#district_id').html('<option value="">خطا در بارگیری</option>').prop('disabled', true);
                this.showNotification('خطا در بارگیری بخش‌ها', 'error');
            }
        }

        async loadZones(cityId) {
            console.log('Loading zones for city:', cityId);

            // Show loading state
            $('#zone_id').html('<option value="">در حال بارگیری...</option>').prop('disabled', true);

            try {
                const response = await fetch(`/api/cities/${cityId}/zones`);
                const result = await response.json();

                console.log('Zones response:', result);

                if (result.success && result.data) {
                    let options = '<option value="">انتخاب کنید</option>';
                    result.data.forEach(zone => {
                        const name = zone.name_fa || zone.name;
                        options += `<option value="${zone.id}">${name}</option>`;
                    });

                    $('#zone_id').html(options).prop('disabled', false);
                    console.log(`Loaded ${result.data.length} zones`);
                } else {
                    throw new Error(result.message || 'خطا در دریافت مناطق');
                }
            } catch (error) {
                console.error('Error loading zones:', error);
                $('#zone_id').html('<option value="">خطا در بارگیری</option>').prop('disabled', true);
                this.showNotification('خطا در بارگیری مناطق', 'error');
            }
        }

        async loadVillages(districtId) {
            console.log('Loading villages for district:', districtId);

            // Show loading state
            $('#village_id').html('<option value="">در حال بارگیری...</option>').prop('disabled', true);

            try {
                const response = await fetch(`/api/districts/${districtId}/villages`);
                const result = await response.json();

                console.log('Villages response:', result);

                if (result.success && result.data) {
                    let options = '<option value="">انتخاب کنید</option>';
                    result.data.forEach(village => {
                        const name = village.name_fa || village.name;
                        options += `<option value="${village.id}">${name}</option>`;
                    });

                    $('#village_id').html(options).prop('disabled', false);
                    console.log(`Loaded ${result.data.length} villages`);
                } else {
                    throw new Error(result.message || 'خطا در دریافت روستاها');
                }
            } catch (error) {
                console.error('Error loading villages:', error);
                $('#village_id').html('<option value="">خطا در بارگیری</option>').prop('disabled', true);
                this.showNotification('خطا در بارگیری روستاها', 'error');
            }
        }

        // Submit Form
        submitForm() {
            const submitBtn = document.getElementById('submitBtn');
            const btnText = submitBtn.querySelector('i').nextSibling;
            const btnLoading = submitBtn.querySelector('.btn-loading');

            // Show loading state
            submitBtn.disabled = true;
            btnText.textContent = ' در حال ثبت...';
            btnLoading.style.display = 'block';

            // Submit the form
            document.getElementById('locationForm').submit();
        }

        // Show Notification
        showNotification(message, type = 'info') {
            // Create notification element
            const notification = document.createElement('div');
            notification.className = `notification notification-${type}`;
            notification.innerHTML = `
                <div class="notification-content">
                    <i class="fas fa-${this.getNotificationIcon(type)}"></i>
                    <span>${message}</span>
                </div>
                <button class="notification-close" onclick="this.parentElement.remove()">
                    <i class="fas fa-times"></i>
                </button>
            `;

            // Add to page
            document.body.appendChild(notification);

            // Auto remove after 5 seconds
            setTimeout(() => {
                if (notification.parentElement) {
                    notification.remove();
                }
            }, 5000);
        }

        getNotificationIcon(type) {
            switch (type) {
                case 'success': return 'check-circle';
                case 'error': return 'exclamation-circle';
                case 'warning': return 'exclamation-triangle';
                default: return 'info-circle';
            }
        }
    }

    // Initialize the form
    window.locationForm = new ModernLocationForm();

    // Test dropdown functionality
    setTimeout(function() {
        console.log('Testing dropdown states...');
        console.log('Country value:', $('#country_id').val());
        console.log('Province disabled:', $('#province_id').prop('disabled'));
        console.log('County disabled:', $('#county_id').prop('disabled'));

        // Force enable province if country is Iran
        if ($('#country_id').val() == 1) {
            console.log('Forcing province enable...');
            $('#province_id').prop('disabled', false);
        }
    }, 1000);
});
</script>

<!-- Notification Styles -->
<style>
.notification {
    position: fixed;
    top: 20px;
    right: 20px;
    background: white;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    padding: 1rem 1.5rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    z-index: 10000;
    min-width: 300px;
    animation: slideInRight 0.3s ease;
}

.notification-success {
    border-left: 4px solid #10b981;
}

.notification-error {
    border-left: 4px solid #ef4444;
}

.notification-warning {
    border-left: 4px solid #f59e0b;
}

.notification-info {
    border-left: 4px solid #3b82f6;
}

.notification-content {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.notification-content i {
    font-size: 1.25rem;
}

.notification-success .notification-content i {
    color: #10b981;
}

.notification-error .notification-content i {
    color: #ef4444;
}

.notification-warning .notification-content i {
    color: #f59e0b;
}

.notification-info .notification-content i {
    color: #3b82f6;
}

.notification-close {
    background: none;
    border: none;
    color: #6b7280;
    cursor: pointer;
    padding: 0.25rem;
    border-radius: 4px;
    transition: all 0.2s ease;
}

.notification-close:hover {
    background: #f3f4f6;
    color: #374151;
}

@keyframes slideInRight {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/user/locations/create.blade.php ENDPATH**/ ?>