@props(['ads', 'layout' => 'grid', 'title' => null])

@if($ads && $ads->count() > 0)
    <div class="ad-section ad-layout-{{ $layout }}">
        @if($title)
            <h2 class="ad-section-title">{{ $title }}</h2>
        @endif
        
        @if($layout === 'carousel')
            <div class="owl-carousel ad-carousel">
                @foreach($ads as $ad)
                    <div class="carousel-item">
                        <x-ad-card :locationAd="$ad" />
                    </div>
                @endforeach
            </div>
        @else
            <div class="ad-grid">
                @foreach($ads as $ad)
                    <div class="grid-item">
                        <x-ad-card :locationAd="$ad" />
                    </div>
                @endforeach
            </div>
        @endif
    </div>
    
    @if($layout === 'carousel')
        @push('scripts')
        <script>
            $(document).ready(function(){
                $(".ad-carousel").owlCarousel({
                    rtl: true,
                    loop: true,
                    margin: 20,
                    nav: true,
                    dots: false,
                    autoplay: true,
                    autoplayTimeout: 5000,
                    responsive: {
                        0: { items: 1 },
                        576: { items: 2 },
                        992: { items: 3 },
                        1200: { items: 4 }
                    }
                });
            });
        </script>
        @endpush
    @endif
@endif 