@props(['locationAd'])

@php
$location = $locationAd->location;
$package = $locationAd->package;
$cardDesign = $package->cardDesign;
$badgeText = $locationAd->getBadgeTextAttribute();
$badgeColor = $locationAd->getBadgeColorAttribute();
@endphp

<div class="location-card {{ $cardDesign->css_class }}" 
    style="border-color: {{ $package->card_border_color }}; 
           background-color: {{ $package->card_background_color }}; 
           color: {{ $package->card_text_color }};">
    
    @if($badgeText)
        <div class="badge" style="background-color: {{ $badgeColor }};">
            {{ $badgeText }}
        </div>
    @endif
    
    @if($location->images)
        @php
            $imageArray = json_decode($location->images, true);
            $mainImage = !empty($imageArray) ? array_values($imageArray)[0] : null;
        @endphp
        
        @if($mainImage)
            <div class="location-image">
                <img src="{{ asset('storage/' . $mainImage) }}" alt="{{ $location->title }}">
            </div>
        @endif
    @endif
    
    <div class="location-content">
        <h3 class="location-title">{{ $location->title }}</h3>
        
        @if($location->category_fa)
            <div class="location-category">{{ $location->category_fa }}</div>
        @endif
        
        @if($location->Slogan)
            <div class="location-slogan">{{ $location->Slogan }}</div>
        @endif
        
        @if($location->address)
            <div class="location-address">
                <i class="fas fa-map-marker-alt"></i> {{ Str::limit($location->getStructuredAddress(app()->getLocale()), 50) }}
            </div>
        @endif
        
        <div class="location-footer">
            @if($location->star_rating)
                <div class="location-rating">
                    @for($i = 1; $i <= 5; $i++)
                        <i class="fas fa-star {{ $i <= $location->star_rating ? 'active' : '' }}"></i>
                    @endfor
                </div>
            @endif
            
            <a href="{{ route('locations.show', $location->title_id) }}" class="view-details">مشاهده جزئیات</a>
        </div>
    </div>
</div> 