@extends('layouts.admin')

@section('title', 'مدیریت منوی کاربری')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت منوی کاربری</h1>
        <div class="d-flex gap-2">
            <button type="button" class="btn btn-success btn-sm" onclick="addNewButton()">
                <i class="fas fa-plus"></i> افزودن دکمه جدید
            </button>
            <button type="button" class="btn btn-warning btn-sm" onclick="resetToDefault()">
                <i class="fas fa-undo"></i> بازگشت به پیش‌فرض
            </button>
        </div>
    </div>

    <!-- Language Selector -->
    <div class="row mb-4">
        <div class="col-md-3">
            <label for="language_select" class="form-label">انتخاب زبان:</label>
            <select class="form-select" id="language_select" onchange="changeLanguage(this.value)">
                <option value="fa" {{ $languageCode == 'fa' ? 'selected' : '' }}>فارسی</option>
                <option value="en" {{ $languageCode == 'en' ? 'selected' : '' }}>English</option>
            </select>
        </div>
    </div>

    <!-- User Menu Buttons Management -->
    <div class="row">
        <!-- Guest Buttons -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">دکمه‌های مهمان</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.user-menu.update-buttons') }}" method="POST">
                        @csrf
                        <input type="hidden" name="language_code" value="{{ $languageCode }}">
                        <input type="hidden" name="button_type" value="guest">
                        
                        <div id="guest-buttons-container">
                            @foreach($guestButtons as $index => $button)
                                <div class="button-item border rounded p-3 mb-3" data-index="{{ $index }}">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="mb-0">{{ $button->button_text }}</h6>
                                        <div>
                                            <button type="button" 
                                                    class="btn btn-sm {{ $button->is_visible ? 'btn-success' : 'btn-secondary' }}"
                                                    onclick="toggleButtonVisibility({{ $button->id }}, this)">
                                                <i class="fas {{ $button->is_visible ? 'fa-eye' : 'fa-eye-slash' }}"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" onclick="removeButton(this)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <input type="hidden" name="buttons[{{ $index }}][button_key]" value="{{ $button->button_key }}">
                                    
                                    <div class="form-group">
                                        <label>متن دکمه</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_text]" 
                                               value="{{ $button->button_text }}"
                                               required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>آدرس لینک</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_url]" 
                                               value="{{ $button->button_url }}"
                                               placeholder="/login">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>آیکون</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_icon]" 
                                               value="{{ $button->button_icon }}"
                                               placeholder="fas fa-sign-in-alt">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>ترتیب نمایش</label>
                                        <input type="number" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][sort_order]" 
                                               value="{{ $button->sort_order }}"
                                               min="0">
                                    </div>
                                    
                                    <input type="hidden" name="buttons[{{ $index }}][is_visible]" value="{{ $button->is_visible ? '1' : '0' }}">
                                    <input type="hidden" name="buttons[{{ $index }}][show_for_guests]" value="1">
                                    <input type="hidden" name="buttons[{{ $index }}][show_for_users]" value="0">
                                </div>
                            @endforeach
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> ذخیره دکمه‌های مهمان
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- User Buttons -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-success">دکمه‌های کاربر</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.user-menu.update-buttons') }}" method="POST">
                        @csrf
                        <input type="hidden" name="language_code" value="{{ $languageCode }}">
                        <input type="hidden" name="button_type" value="user">
                        
                        <div id="user-buttons-container">
                            @foreach($userButtons as $index => $button)
                                <div class="button-item border rounded p-3 mb-3" data-index="{{ $index }}">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="mb-0">{{ $button->button_text }}</h6>
                                        <div>
                                            <button type="button" 
                                                    class="btn btn-sm {{ $button->is_visible ? 'btn-success' : 'btn-secondary' }}"
                                                    onclick="toggleButtonVisibility({{ $button->id }}, this)">
                                                <i class="fas {{ $button->is_visible ? 'fa-eye' : 'fa-eye-slash' }}"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" onclick="removeButton(this)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <input type="hidden" name="buttons[{{ $index }}][button_key]" value="{{ $button->button_key }}">
                                    
                                    <div class="form-group">
                                        <label>متن دکمه</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_text]" 
                                               value="{{ $button->button_text }}"
                                               required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>آدرس لینک</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_url]" 
                                               value="{{ $button->button_url }}"
                                               placeholder="/user/profile">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>آیکون</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_icon]" 
                                               value="{{ $button->button_icon }}"
                                               placeholder="fas fa-user">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>ترتیب نمایش</label>
                                        <input type="number" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][sort_order]" 
                                               value="{{ $button->sort_order }}"
                                               min="0">
                                    </div>
                                    
                                    <input type="hidden" name="buttons[{{ $index }}][is_visible]" value="{{ $button->is_visible ? '1' : '0' }}">
                                    <input type="hidden" name="buttons[{{ $index }}][show_for_guests]" value="0">
                                    <input type="hidden" name="buttons[{{ $index }}][show_for_users]" value="1">
                                </div>
                            @endforeach
                        </div>

                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save"></i> ذخیره دکمه‌های کاربر
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Shared Buttons -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">دکمه‌های مشترک</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.user-menu.update-buttons') }}" method="POST">
                        @csrf
                        <input type="hidden" name="language_code" value="{{ $languageCode }}">
                        <input type="hidden" name="button_type" value="shared">
                        
                        <div id="shared-buttons-container">
                            @foreach($sharedButtons as $index => $button)
                                <div class="button-item border rounded p-3 mb-3" data-index="{{ $index }}">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="mb-0">{{ $button->button_text }}</h6>
                                        <div>
                                            <button type="button" 
                                                    class="btn btn-sm {{ $button->is_visible ? 'btn-success' : 'btn-secondary' }}"
                                                    onclick="toggleButtonVisibility({{ $button->id }}, this)">
                                                <i class="fas {{ $button->is_visible ? 'fa-eye' : 'fa-eye-slash' }}"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" onclick="removeButton(this)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <input type="hidden" name="buttons[{{ $index }}][button_key]" value="{{ $button->button_key }}">
                                    
                                    <div class="form-group">
                                        <label>متن دکمه</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_text]" 
                                               value="{{ $button->button_text }}"
                                               required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>آدرس لینک</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_url]" 
                                               value="{{ $button->button_url }}"
                                               placeholder="/user/locations/create">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>آیکون</label>
                                        <input type="text" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][button_icon]" 
                                               value="{{ $button->button_icon }}"
                                               placeholder="fas fa-plus">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>ترتیب نمایش</label>
                                        <input type="number" 
                                               class="form-control" 
                                               name="buttons[{{ $index }}][sort_order]" 
                                               value="{{ $button->sort_order }}"
                                               min="0">
                                    </div>
                                    
                                    <input type="hidden" name="buttons[{{ $index }}][is_visible]" value="{{ $button->is_visible ? '1' : '0' }}">
                                    <input type="hidden" name="buttons[{{ $index }}][show_for_guests]" value="1">
                                    <input type="hidden" name="buttons[{{ $index }}][show_for_users]" value="1">
                                </div>
                            @endforeach
                        </div>

                        <button type="submit" class="btn btn-warning">
                            <i class="fas fa-save"></i> ذخیره دکمه‌های مشترک
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Button Modal -->
<div class="modal fade" id="addButtonModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">افزودن دکمه جدید</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.user-menu.add-button') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="language_code" value="{{ $languageCode }}">
                    
                    <div class="form-group">
                        <label for="button_type">نوع دکمه</label>
                        <select class="form-control" id="button_type" name="button_type" required>
                            <option value="guest">دکمه مهمان</option>
                            <option value="user">دکمه کاربر</option>
                            <option value="shared">دکمه مشترک</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="new_button_key">کلید دکمه (منحصر به فرد)</label>
                        <input type="text" class="form-control" id="new_button_key" name="button_key" required>
                        <small class="form-text text-muted">مثال: my_custom_button</small>
                    </div>
                    
                    <div class="form-group">
                        <label for="new_button_text">متن دکمه</label>
                        <input type="text" class="form-control" id="new_button_text" name="button_text" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="new_button_url">آدرس لینک</label>
                        <input type="text" class="form-control" id="new_button_url" name="button_url">
                    </div>
                    
                    <div class="form-group">
                        <label for="new_button_icon">آیکون</label>
                        <input type="text" class="form-control" id="new_button_icon" name="button_icon">
                    </div>
                    
                    <div class="form-group">
                        <label for="new_sort_order">ترتیب نمایش</label>
                        <input type="number" class="form-control" id="new_sort_order" name="sort_order" value="0" min="0">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-primary">افزودن دکمه</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function changeLanguage(langCode) {
    window.location.href = '{{ route("admin.user-menu.index") }}?lang=' + langCode;
}

function addNewButton() {
    $('#addButtonModal').modal('show');
}

function removeButton(button) {
    if (confirm('آیا از حذف این دکمه اطمینان دارید؟')) {
        $(button).closest('.button-item').remove();
        updateButtonIndices();
    }
}

function updateButtonIndices() {
    $('.button-item').each(function(index) {
        $(this).attr('data-index', index);
        $(this).find('input, select').each(function() {
            const name = $(this).attr('name');
            if (name) {
                const newName = name.replace(/buttons\[\d+\]/, `buttons[${index}]`);
                $(this).attr('name', newName);
            }
        });
    });
}

function toggleButtonVisibility(buttonId, element) {
    $.ajax({
        url: `/admin/user-menu/buttons/${buttonId}/toggle-visibility`,
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                const btn = $(element);
                const icon = btn.find('i');
                
                if (response.is_visible) {
                    btn.removeClass('btn-secondary').addClass('btn-success');
                    icon.removeClass('fa-eye-slash').addClass('fa-eye');
                } else {
                    btn.removeClass('btn-success').addClass('btn-secondary');
                    icon.removeClass('fa-eye').addClass('fa-eye-slash');
                }
                
                // Update hidden input
                btn.closest('.button-item').find('input[name*="[is_visible]"]').val(response.is_visible ? '1' : '0');
                
                showAlert('success', response.message);
            }
        },
        error: function() {
            showAlert('error', 'خطا در تغییر وضعیت دکمه');
        }
    });
}

function resetToDefault() {
    if (confirm('آیا از بازگشت به تنظیمات پیش‌فرض اطمینان دارید؟ تمام تغییرات فعلی از بین خواهد رفت.')) {
        window.location.href = '{{ route("admin.user-menu.reset-default") }}?lang={{ $languageCode }}';
    }
}

function showAlert(type, message) {
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;
    $('.container-fluid').prepend(alertHtml);
}
</script>
@endpush
