@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">ویرایش ترجمه</h1>
        <a href="{{ route('admin.translations.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right"></i> بازگشت به لیست
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-body">
            <form action="{{ route('admin.translations.update', $translation) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="form-group">
                    <label for="key">کلید ترجمه</label>
                    <input type="text" class="form-control" id="key" value="{{ $translation->key }}" disabled>
                </div>

                <div class="form-group">
                    <label for="value">مقدار ترجمه</label>
                    <textarea class="form-control @error('value') is-invalid @enderror" id="value" name="value" rows="3" required>{{ old('value', $translation->value) }}</textarea>
                    @error('value')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="language_code">زبان</label>
                    <input type="text" class="form-control" id="language_code" value="{{ $translation->language->name }}" disabled>
                </div>

                <div class="form-group">
                    <label for="group">گروه</label>
                    <input type="text" class="form-control" id="group" value="{{ $translation->group }}" disabled>
                </div>

                <div class="form-group">
                    <label for="namespace">فضای نام</label>
                    <input type="text" class="form-control" id="namespace" value="{{ $translation->namespace }}" disabled>
                </div>

                <button type="submit" class="btn btn-primary">بروزرسانی ترجمه</button>
            </form>
        </div>
    </div>
</div>
@endsection 