@extends('admin.layouts.app')

@section('title', 'جستجوی پیشرفته دیتابیس')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">جستجوی پیشرفته در دیتابیس</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.tools.advanced-search') }}" method="GET" id="advancedSearchForm">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="table">انتخاب جدول</label>
                                    <select class="form-control" id="table" name="table" required>
                                        <option value="">انتخاب کنید</option>
                                        @foreach($tableInfo as $table => $columns)
                                            <option value="{{ $table }}">{{ $table }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="column">انتخاب ستون</label>
                                    <select class="form-control" id="column" name="column" required>
                                        <option value="">ابتدا جدول را انتخاب کنید</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="search">عبارت جستجو</label>
                                    <input type="text" class="form-control" id="search" name="search" placeholder="عبارت مورد نظر را وارد کنید">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">جستجو</button>
                            </div>
                        </div>
                    </form>

                    @if(isset($results))
                    <div class="mt-4">
                        <h4>نتایج جستجو</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        @foreach($results->first() as $key => $value)
                                            <th>{{ $key }}</th>
                                        @endforeach
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($results as $row)
                                        <tr>
                                            @foreach($row as $value)
                                                <td>{{ $value }}</td>
                                            @endforeach
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('#table').change(function() {
        var table = $(this).val();
        var columns = @json($tableInfo);
        
        $('#column').empty();
        $('#column').append('<option value="">انتخاب کنید</option>');
        
        if (table && columns[table]) {
            columns[table].forEach(function(column) {
                $('#column').append('<option value="' + column + '">' + column + '</option>');
            });
        }
    });
});
</script>
@endpush
@endsection 