@foreach($templates as $template)
    <tr>
        <td>
            <i class="fas fa-file-alt text-primary ml-1"></i>
            <span class="font-weight-bold">{{ $template->template_name ?? '-' }}</span>
        </td>
        <td>
            <i class="fas fa-folder-open text-info ml-1"></i>
            <span>{{ $template->category->category_fa ?? '-' }}</span>
        </td>
        <td>
            @php
                $features = $template->features;
                if (is_string($features)) {
                    $features = json_decode($features, true);
                }
                if (!is_array($features)) {
                    $features = [];
                }
                $availableFeatures = config('features.available', []);
                $activeCount = 0;
            @endphp
            <div class="d-flex flex-wrap">
            @foreach($features as $key => $settings)
                @if(isset($settings['is_enabled']) && $settings['is_enabled'] && isset($availableFeatures[$key]))
                    @php $activeCount++; @endphp
                    <span class="badge badge-light border mr-1 mb-1 px-2 py-1 shadow-sm" data-toggle="tooltip" title="{{ $availableFeatures[$key]['title'] }}">
                        <i class="{{ $availableFeatures[$key]['icon'] ?? 'fas fa-star' }} text-{{ $availableFeatures[$key]['color'] ?? 'primary' }}"></i>
                    </span>
                @endif
            @endforeach
            @if($activeCount === 0)
                <span class="text-muted small">فاقد ویژگی فعال</span>
            @endif
            </div>
        </td>
        <td class="text-center">
            <a href="{{ route('admin.templates.edit', $template) }}" class="btn btn-info btn-circle btn-sm mx-1 shadow" data-toggle="tooltip" title="ویرایش">
                <i class="fas fa-edit"></i>
            </a>
            <form action="{{ route('admin.templates.destroy', $template) }}" method="POST" class="d-inline-block" onsubmit="return confirm('آیا مطمئن هستید؟');">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger btn-circle btn-sm mx-1 shadow" data-toggle="tooltip" title="حذف">
                    <i class="fas fa-trash"></i>
                </button>
            </form>
        </td>
    </tr>
@endforeach 