@extends('admin.layouts.app')

@section('title', 'آنالیز و گزارش‌گیری امتیازات')

@section('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.css">
<style>
    .analytics-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
        border: none;
        margin-bottom: 25px;
        transition: transform 0.3s ease;
    }
    .analytics-card:hover {
        transform: translateY(-5px);
    }
    .analytics-card .card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px 15px 0 0;
        border: none;
        padding: 20px;
    }
    .metric-card {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        border-radius: 15px;
        color: white;
        padding: 25px;
        text-align: center;
        margin-bottom: 20px;
        transition: transform 0.3s ease;
    }
    .metric-card:hover {
        transform: scale(1.05);
    }
    .metric-card.warning {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }
    .metric-card.info {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }
    .metric-card.primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }
    .page-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px;
        padding: 30px;
        margin-bottom: 30px;
    }
    .chart-container {
        position: relative;
        height: 400px;
        margin-bottom: 20px;
    }
    .ranking-item {
        display: flex;
        align-items: center;
        padding: 15px;
        border-bottom: 1px solid #e3e6f0;
        transition: background-color 0.3s ease;
    }
    .ranking-item:hover {
        background-color: #f8f9fc;
    }
    .ranking-number {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        margin-left: 15px;
    }
    .ranking-number.gold {
        background: linear-gradient(135deg, #ffd700, #ffed4e);
        color: #333;
    }
    .ranking-number.silver {
        background: linear-gradient(135deg, #c0c0c0, #e8e8e8);
        color: #333;
    }
    .ranking-number.bronze {
        background: linear-gradient(135deg, #cd7f32, #daa520);
        color: white;
    }
    .ranking-number.default {
        background: #6c757d;
        color: white;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h2 class="mb-2">
                    <i class="fas fa-chart-line me-3"></i>
                    آنالیز و گزارش‌گیری امتیازات
                </h2>
                <p class="mb-0 opacity-75">تحلیل جامع عملکرد سیستم امتیازدهی و نظرات</p>
            </div>
            <div class="col-md-4 text-end">
                <div class="btn-group">
                    <a href="{{ route('admin.ratings.index') }}" class="btn btn-light">
                        <i class="fas fa-list"></i> لیست امتیازات
                    </a>
                    <a href="{{ route('admin.ratings.settings') }}" class="btn btn-light">
                        <i class="fas fa-cog"></i> تنظیمات
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Key Metrics -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="metric-card">
                <div class="h3 mb-2">{{ $analytics['user_engagement']['repeat_reviewers'] ?? 0 }}</div>
                <div>کاربران فعال</div>
                <small class="opacity-75">کاربرانی که بیش از یک نظر داده‌اند</small>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="metric-card warning">
                <div class="h3 mb-2">{{ $analytics['user_engagement']['verified_reviews'] ?? 0 }}</div>
                <div>نظرات تایید شده</div>
                <small class="opacity-75">نظرات با هویت تایید شده</small>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="metric-card info">
                <div class="h3 mb-2">{{ number_format($analytics['user_engagement']['helpful_votes_total'] ?? 0) }}</div>
                <div>کل رای‌های مفید</div>
                <small class="opacity-75">مجموع رای‌های مفید به نظرات</small>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="metric-card primary">
                <div class="h3 mb-2">{{ number_format(($analytics['user_engagement']['avg_helpful_ratio'] ?? 0) * 100, 1) }}%</div>
                <div>نرخ مفید بودن</div>
                <small class="opacity-75">میانگین نرخ مفید بودن نظرات</small>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row">
        <!-- Rating Trends Chart -->
        <div class="col-lg-8">
            <div class="analytics-card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-chart-line me-2"></i>
                        روند امتیازات (30 روز گذشته)
                    </h5>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="ratingTrendsChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Category Performance -->
        <div class="col-lg-4">
            <div class="analytics-card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-chart-pie me-2"></i>
                        عملکرد دسته‌بندی‌ها
                    </h5>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="categoryPerformanceChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Category Details and Location Rankings -->
    <div class="row">
        <!-- Category Details Table -->
        <div class="col-lg-8">
            <div class="analytics-card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-table me-2"></i>
                        جزئیات عملکرد دسته‌بندی‌ها
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>دسته‌بندی</th>
                                    <th>تعداد امتیاز</th>
                                    <th>میانگین کلی</th>
                                    <th>خدمات</th>
                                    <th>نظافت</th>
                                    <th>موقعیت</th>
                                    <th>قیمت</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($analytics['category_performance'] ?? [] as $category)
                                <tr>
                                    <td>
                                        <strong>{{ $category->category }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary">{{ number_format($category->total_ratings) }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @for($i = 1; $i <= 5; $i++)
                                                <i class="fas fa-star {{ $i <= round($category->avg_rating) ? 'text-warning' : 'text-muted' }} me-1"></i>
                                            @endfor
                                            <span class="ms-2">{{ number_format($category->avg_rating, 1) }}</span>
                                        </div>
                                    </td>
                                    <td>{{ $category->avg_service ? number_format($category->avg_service, 1) : '-' }}</td>
                                    <td>{{ $category->avg_cleanliness ? number_format($category->avg_cleanliness, 1) : '-' }}</td>
                                    <td>{{ $category->avg_location ? number_format($category->avg_location, 1) : '-' }}</td>
                                    <td>{{ $category->avg_price ? number_format($category->avg_price, 1) : '-' }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center text-muted">داده‌ای یافت نشد</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Locations -->
        <div class="col-lg-4">
            <div class="analytics-card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-trophy me-2"></i>
                        برترین مکان‌ها
                    </h5>
                </div>
                <div class="card-body p-0">
                    @forelse($analytics['location_rankings'] ?? [] as $index => $location)
                    <div class="ranking-item">
                        <div class="ranking-number {{ $index == 0 ? 'gold' : ($index == 1 ? 'silver' : ($index == 2 ? 'bronze' : 'default')) }}">
                            {{ $index + 1 }}
                        </div>
                        <div class="flex-grow-1">
                            <div class="fw-bold">{{ $location->location->title ?? 'نامشخص' }}</div>
                            <div class="small text-muted">
                                <div class="d-flex align-items-center">
                                    @for($i = 1; $i <= 5; $i++)
                                        <i class="fas fa-star {{ $i <= round($location->average_rating) ? 'text-warning' : 'text-muted' }} me-1"></i>
                                    @endfor
                                    <span>{{ number_format($location->average_rating, 1) }}</span>
                                </div>
                                <div>{{ number_format($location->total_ratings) }} امتیاز</div>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="text-center p-4 text-muted">
                        <i class="fas fa-trophy fa-3x mb-3 opacity-50"></i>
                        <p>هنوز رتبه‌بندی موجود نیست</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
$(document).ready(function() {
    // Rating Trends Chart
    const trendsCtx = document.getElementById('ratingTrendsChart').getContext('2d');
    new Chart(trendsCtx, {
        type: 'line',
        data: {
            labels: [
                @foreach($analytics['rating_trends'] ?? [] as $trend)
                    '{{ $trend->date }}',
                @endforeach
            ],
            datasets: [{
                label: 'میانگین امتیاز',
                data: [
                    @foreach($analytics['rating_trends'] ?? [] as $trend)
                        {{ $trend->avg_rating }},
                    @endforeach
                ],
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                tension: 0.4
            }, {
                label: 'تعداد امتیازات',
                data: [
                    @foreach($analytics['rating_trends'] ?? [] as $trend)
                        {{ $trend->count }},
                    @endforeach
                ],
                borderColor: 'rgb(255, 99, 132)',
                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                yAxisID: 'y1',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            scales: {
                x: {
                    display: true,
                    title: {
                        display: true,
                        text: 'تاریخ'
                    }
                },
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    title: {
                        display: true,
                        text: 'میانگین امتیاز'
                    },
                    min: 0,
                    max: 5
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    title: {
                        display: true,
                        text: 'تعداد امتیازات'
                    },
                    grid: {
                        drawOnChartArea: false,
                    },
                }
            }
        }
    });

    // Category Performance Chart
    const categoryCtx = document.getElementById('categoryPerformanceChart').getContext('2d');
    new Chart(categoryCtx, {
        type: 'doughnut',
        data: {
            labels: [
                @foreach($analytics['category_performance'] ?? [] as $category)
                    '{{ $category->category }}',
                @endforeach
            ],
            datasets: [{
                data: [
                    @foreach($analytics['category_performance'] ?? [] as $category)
                        {{ $category->total_ratings }},
                    @endforeach
                ],
                backgroundColor: [
                    '#FF6384',
                    '#36A2EB',
                    '#FFCE56',
                    '#4BC0C0',
                    '#9966FF',
                    '#FF9F40'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
});
</script>
@endsection
