@extends('admin.layouts.app')

@section('title', 'پیام‌های ارسال شده')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">پیام‌های ارسال شده</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>گیرنده</th>
                                    <th>موضوع</th>
                                    <th>تاریخ ارسال</th>
                                    <th>وضعیت</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($messages as $message)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $message->recipient_name }}</td>
                                    <td>{{ $message->subject }}</td>
                                    <td>@dateTimeByLocale($message->created_at)</td>
                                    <td>
                                        @if($message->read_at)
                                            <span class="badge badge-success">خوانده شده</span>
                                        @else
                                            <span class="badge badge-warning">خوانده نشده</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.messages.show', $message) }}" class="btn btn-sm btn-info">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <form action="{{ route('admin.messages.destroy', $message) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این پیام اطمینان دارید؟')">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">هیچ پیام ارسال شده‌ای وجود ندارد.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    {{ $messages->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 