@extends('admin.layouts.app')

@section('title', 'افزودن مکان جدید')

@section('styles')
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin="" />
    <style>
        #location-map {
            height: 400px;
            width: 100%;
            border-radius: 0.35rem;
            margin-bottom: 1rem;
        }
        .nested-select option {
            font-size: 14px;
        }
        .select-container {
            margin-bottom: 1rem;
        }
        .geo-select-container {
            border: 1px solid #e3e6f0;
            border-radius: 0.35rem;
            padding: 1rem;
            margin-bottom: 1rem;
            background-color: #f8f9fc;
        }
        .geo-select-container h6 {
            margin-bottom: 1rem;
            color: #4e73df;
        }
        .category-row {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 10px;
        }
        .category-row > div {
            flex: 1;
            min-width: 200px;
        }
    </style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">افزودن مکان جدید</h1>
        <a href="{{ route('admin.locations.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-right fa-sm text-white-50 ml-1"></i> بازگشت به لیست
        </a>
    </div>

    <!-- Content Row -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">مشخصات مکان</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.locations.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <!-- اطلاعات پایه -->
                    <div class="col-md-6">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="m-0 font-weight-bold text-primary">اطلاعات پایه</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="title">عنوان مکان <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" required>
                                    @error('title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="title_id">شناسه یکتا (به انگلیسی)</label>
                                    <input type="text" class="form-control @error('title_id') is-invalid @enderror" id="title_id" name="title_id" value="{{ old('title_id') }}">
                                    <small class="form-text text-muted">بدون فاصله و حروف خاص. مثال: grand_hotel</small>
                                    @error('title_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="category_id">دسته‌بندی</label>
                                    <select name="category_id" id="category_id" class="form-control @error('category_id') is-invalid @enderror">
                                        <option value="">انتخاب دسته‌بندی</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                                {{ $category->getTranslatedName(app()->getLocale()) }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="description">توضیحات</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                                    @error('description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="slogan">شعار</label>
                                    <input type="text" class="form-control @error('Slogan') is-invalid @enderror" id="slogan" name="Slogan" value="{{ old('Slogan') }}">
                                    @error('Slogan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="emoji">ایموجی</label>
                                    <input type="text" class="form-control @error('emoji') is-invalid @enderror" id="emoji" name="emoji" value="{{ old('emoji') }}">
                                    @error('emoji')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">وضعیت فعال</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- اطلاعات تماس و موقعیت -->
                    <div class="col-md-6">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="m-0 font-weight-bold text-primary">اطلاعات تماس و موقعیت</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="phone">شماره تماس</label>
                                    <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone') }}">
                                    @error('phone')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="url">وب‌سایت</label>
                                    <input type="url" class="form-control @error('url') is-invalid @enderror" id="url" name="url" value="{{ old('url') }}">
                                    @error('url')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="open_hours">ساعت شروع</label>
                                            <input type="time" class="form-control @error('open_hours') is-invalid @enderror" id="open_hours" name="open_hours" value="{{ old('open_hours') }}">
                                            @error('open_hours')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="closing_hours">ساعت پایان</label>
                                            <input type="time" class="form-control @error('closing_hours') is-invalid @enderror" id="closing_hours" name="closing_hours" value="{{ old('closing_hours') }}">
                                            @error('closing_hours')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- موقعیت جغرافیایی -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">موقعیت جغرافیایی</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="geo-select-container">
                                    <h6 class="font-weight-bold">انتخاب منطقه جغرافیایی</h6>

                                    <div class="form-group">
                                        <label for="country_id">کشور</label>
                                        <select class="form-control country-flag-select @error('country_id') is-invalid @enderror" id="country_id" name="country_id">
                                            <option value="">انتخاب کنید</option>
                                            @foreach($countries as $id => $name)
                                                @php
                                                    $flag = '';
                                                    if (is_object($name) && isset($name->flag)) $flag = $name->flag;
                                                    elseif (is_array($name) && isset($name['flag'])) $flag = $name['flag'];
                                                @endphp
                                                <option value="{{ $id }}" {{ old('country_id') == $id ? 'selected' : '' }}>
                                                    {{ $flag }} {{ is_object($name) ? $name->name : (is_array($name) ? $name['name'] : $name) }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('country_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="province_id">استان</label>
                                        <select class="form-control @error('province_id') is-invalid @enderror" id="province_id" name="province_id">
                                            <option value="">انتخاب کنید</option>
                                            <!-- Options will be loaded by JavaScript -->
                                        </select>
                                        @error('province_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="county_id">شهرستان</label>
                                        <select class="form-control @error('county_id') is-invalid @enderror" id="county_id" name="county_id">
                                            <option value="">انتخاب کنید</option>
                                            <!-- Options will be loaded by JavaScript -->
                                        </select>
                                        @error('county_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="district_id">بخش</label>
                                        <select class="form-control @error('district_id') is-invalid @enderror" id="district_id" name="district_id">
                                            <option value="">انتخاب کنید</option>
                                            <!-- Options will be loaded by JavaScript -->
                                        </select>
                                        @error('district_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="city_id">شهر</label>
                                                <select class="form-control @error('city_id') is-invalid @enderror" id="city_id" name="city_id">
                                                    <option value="">انتخاب کنید</option>
                                                    <!-- Options will be loaded by JavaScript -->
                                                </select>
                                                @error('city_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="village_id">روستا</label>
                                                <select class="form-control @error('village_id') is-invalid @enderror" id="village_id" name="village_id">
                                                    <option value="">انتخاب کنید</option>
                                                    <!-- Options will be loaded by JavaScript -->
                                                </select>
                                                @error('village_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="zone_id">منطقه</label>
                                        <select class="form-control @error('zone_id') is-invalid @enderror" id="zone_id" name="zone_id">
                                            <option value="">انتخاب کنید</option>
                                            <!-- Options will be loaded by JavaScript -->
                                        </select>
                                        @error('zone_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="address">آدرس</label>
                                        <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address" rows="2" data-auto-update="true">{{ old('address') }}</textarea>
                                        <small class="form-text text-muted">آدرس به صورت خودکار براساس انتخاب‌های بالا و موقعیت روی نقشه تکمیل می‌شود.</small>
                                        @error('address')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="lat">عرض جغرافیایی</label>
                                            <input type="text" class="form-control @error('lat') is-invalid @enderror" id="lat" name="lat" value="{{ old('lat') }}">
                                            @error('lat')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="lng">طول جغرافیایی</label>
                                            <input type="text" class="form-control @error('lng') is-invalid @enderror" id="lng" name="lng" value="{{ old('lng') }}">
                                            @error('lng')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="location-map">موقعیت روی نقشه</label>
                                    <div id="location-map"></div>
                                    <small class="form-text text-muted">روی نقشه کلیک کنید تا مکان مورد نظر انتخاب شود.</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- امکانات -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">امکانات</h6>
                    </div>
                    <div class="card-body">
                        @foreach($amenityTypes as $type)
                            <h6 class="mt-3 mb-2">{{ $type->type_name }}</h6>
                            <div class="row mb-2">
                                @foreach($amenities->where('type_id', $type->id) as $amenity)
                                    <div class="col-md-3 mb-2">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="amenity{{ $amenity->id }}" name="amenities[{{ $amenity->id }}]" value="1" {{ (old('amenities') && isset(old('amenities')[$amenity->id])) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="amenity{{ $amenity->id }}">
                                                <i class="{{ $amenity->icon }}"></i> {{ $amenity->title }}
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- تصاویر و تگ‌ها -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">تصاویر و تگ‌ها</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="images">آپلود تصاویر</label>
                            <input type="file" class="form-control-file @error('images') is-invalid @enderror" id="images" name="images[]" multiple>
                            <small class="form-text text-muted">می‌توانید چند تصویر را همزمان انتخاب کنید</small>
                            @error('images')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="tags">برچسب‌ها</label>
                            <input type="text" class="form-control @error('tags') is-invalid @enderror" id="tags" name="tags" value="{{ old('tags') }}">
                            <small class="form-text text-muted">برچسب‌ها را با کاما جدا کنید</small>
                            @error('tags')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- دکمه‌های ثبت -->
                <div class="text-left mb-4">
                    <button type="submit" class="btn btn-primary">ثبت مکان جدید</button>
                    <a href="{{ route('admin.locations.index') }}" class="btn btn-secondary">انصراف</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
    <script src="{{ asset('js/hierarchical-selects.js') }}"></script>
    <script src="{{ asset('js/boundary-display.js') }}"></script>
@endsection