@extends('admin.layouts.app')

@section('title', 'مشخصات محله')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>مشخصات محله</h4>
                <div>
                    <a href="{{ route('admin.geography.zones.edit', $item->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> ویرایش
                    </a>
                    <a href="{{ route('admin.geography.zones.index') }}" class="btn btn-secondary">
                        <i class="fas fa-list"></i> بازگشت به لیست
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">شناسه محله</th>
                            <td>{{ $item->id }}</td>
                        </tr>
                        <tr>
                            <th>نام</th>
                            <td>{{ $item->name }}</td>
                        </tr>
                        <tr>
                            <th>نام انگلیسی</th>
                            <td>{{ $item->name_en ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Slug</th>
                            <td><code>{{ $item->slug }}</code></td>
                        </tr>
                        <tr>
                            <th>شهر</th>
                            <td>{{ app()->getLocale() === 'en' ? ($item->city->name_en ?? 'N/A') : ($item->city->name ?? 'N/A') }}</td>
                        </tr>
                        <tr>
                            <th>روستا</th>
                            <td>{{ app()->getLocale() === 'en' ? ($item->village->name_en ?? 'N/A') : ($item->village->name ?? 'N/A') }}</td>
                        </tr>
                        <tr>
                            <th>محله والد</th>
                            <td>{{ app()->getLocale() === 'en' ? ($item->parentZone->name_en ?? 'N/A') : ($item->parentZone->name ?? 'N/A') }}</td>
                        </tr>
                        <tr>
                            <th>نوع منطقه</th>
                            <td>{{ $item->zone_type ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">کد</th>
                            <td>{{ $item->code ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>مساحت</th>
                            <td>{{ isset($item->area) ? number_format($item->area, 2) . ' کیلومتر مربع' : 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>جمعیت</th>
                            <td>{{ isset($item->population) ? number_format($item->population) . ' نفر' : 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>تعداد خانوار</th>
                            <td>{{ isset($item->households) ? number_format($item->households) : 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>کد پستی</th>
                            <td>{{ $item->postal_code ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>وضعیت</th>
                            <td>
                                <span class="badge {{ $item->is_active ? 'bg-success' : 'bg-danger' }}">
                                    {{ $item->is_active ? 'فعال' : 'غیرفعال' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>تاریخ ایجاد</th>
                            <td>{{ $item->created_at ? $item->created_at->format('Y-m-d H:i:s') : 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            @if($item->description)
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>توضیحات</h5>
                    <div class="p-3 border rounded">
                        {{ $item->description }}
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header">
            <h5>محله‌های زیرمجموعه</h5>
        </div>
        <div class="card-body">
            @if(isset($childZones) && $childZones->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>شناسه</th>
                                <th>نام</th>
                                <th>نام انگلیسی</th>
                                <th>نوع</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($childZones as $zone)
                            <tr>
                                <td>{{ $zone->id }}</td>
                                <td>{{ $zone->name }}</td>
                                <td>{{ $zone->name_en ?? '-' }}</td>
                                <td>{{ $zone->zone_type }}</td>
                                <td>
                                    <span class="badge {{ $zone->is_active ? 'bg-success' : 'bg-danger' }}">
                                        {{ $zone->is_active ? 'فعال' : 'غیرفعال' }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('admin.geography.zones.show', $zone->id) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i> نمایش
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted">هیچ محله زیرمجموعه‌ای یافت نشد.</p>
            @endif
        </div>
    </div>
</div>
@endsection 