@extends('admin.layouts.app')

@section('title', 'ویرایش کشور')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>ویرایش کشور</h4>
                <div>
                    <a href="{{ route('admin.geography.countries.show', $item->id) }}" class="btn btn-info">
                        <i class="fas fa-eye"></i> مشاهده جزئیات
                    </a>
                    <a href="{{ route('admin.geography.countries.index') }}" class="btn btn-primary">
                        <i class="fas fa-list"></i> بازگشت به لیست
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <form action="{{ route('admin.geography.countries.update', $item->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="name" class="form-label">نام (به زبان اصلی) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $item->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="name_en" class="form-label">نام (انگلیسی) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name_en') is-invalid @enderror" id="name_en" name="name_en" value="{{ old('name_en', $item->name_en) }}" required>
                            @error('name_en')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="iso_code" class="form-label">کد ISO (2 حرفی) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('iso_code') is-invalid @enderror" id="iso_code" name="iso_code" value="{{ old('iso_code', $item->iso_code) }}" maxlength="2" required>
                            @error('iso_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">کد دو حرفی کشور (ISO 3166-1 alpha-2)</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="iso_code3" class="form-label">کد ISO 3 (3 حرفی) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('iso_code3') is-invalid @enderror" id="iso_code3" name="iso_code3" value="{{ old('iso_code3', $item->iso_code3) }}" maxlength="3" required>
                            @error('iso_code3')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">کد سه حرفی کشور (ISO 3166-1 alpha-3)</small>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="phone_code" class="form-label">کد تلفن</label>
                            <div class="input-group">
                                <span class="input-group-text">+</span>
                                <input type="text" class="form-control @error('phone_code') is-invalid @enderror" id="phone_code" name="phone_code" value="{{ old('phone_code', $item->phone_code) }}">
                            </div>
                            @error('phone_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">کد بین‌المللی شماره تلفن بدون علامت +</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label d-block">وضعیت</label>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="is_active" id="status_active" value="1" {{ old('is_active', $item->is_active) == 1 ? 'checked' : '' }}>
                                <label class="form-check-label" for="status_active">فعال</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="is_active" id="status_inactive" value="0" {{ old('is_active', $item->is_active) == 0 ? 'checked' : '' }}>
                                <label class="form-check-label" for="status_inactive">غیرفعال</label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mt-4">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save"></i> بروزرسانی کشور
                    </button>
                    <a href="{{ route('admin.geography.countries.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> انصراف
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection 