@extends('admin.layouts.app')

@section('title', 'ویرایش دسته‌بندی')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">ویرایش دسته‌بندی</h1>
        <a href="{{ route('admin.categories.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-right fa-sm text-white-50 ml-1"></i> بازگشت به لیست
        </a>
    </div>

    <!-- Content Row -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">مشخصات دسته‌بندی</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.categories.update', $category->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <!-- اطلاعات اصلی -->
                    <div class="col-md-6">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="m-0 font-weight-bold text-primary">اطلاعات اصلی</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="category_fa">نام دسته‌بندی (فارسی) <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('category_fa') is-invalid @enderror" id="category_fa" name="category_fa" value="{{ old('category_fa', $category->category_fa) }}" required>
                                    @error('category_fa')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="category_en">نام دسته‌بندی (انگلیسی)</label>
                                    <input type="text" class="form-control @error('category_en') is-invalid @enderror" id="category_en" name="category_en" value="{{ old('category_en', $category->category_en) }}">
                                    @error('category_en')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="category_ar">نام دسته‌بندی (عربی)</label>
                                    <input type="text" class="form-control @error('category_ar') is-invalid @enderror" id="category_ar" name="category_ar" value="{{ old('category_ar', $category->category_ar) }}">
                                    @error('category_ar')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="category_key">کلید دسته‌بندی <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('category_key') is-invalid @enderror" id="category_key" name="category_key" value="{{ old('category_key', $category->category_key) }}" required>
                                    <small class="form-text text-muted">از حروف انگلیسی، اعداد و خط تیره استفاده کنید. مثال: hotels</small>
                                    @error('category_key')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="parent_id">دسته‌بندی والد</label>
                                    <select class="form-control @error('parent_id') is-invalid @enderror" id="parent_id" name="parent_id">
                                        <option value="">دسته‌بندی اصلی</option>
                                        @foreach($parentCategories as $id => $name)
                                            @if($id != $category->id) {{-- جلوگیری از انتخاب خود دسته‌بندی به عنوان والد --}}
                                                <option value="{{ $id }}" {{ old('parent_id', $category->parent_id) == $id ? 'selected' : '' }}>{{ $name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('parent_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="description_fa">توضیحات فارسی</label>
                                    <textarea class="form-control @error('description_fa') is-invalid @enderror" id="description_fa" name="description_fa" rows="3">{{ old('description_fa', $category->description_fa) }}</textarea>
                                    @error('description_fa')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="description_en">توضیحات انگلیسی</label>
                                    <textarea class="form-control @error('description_en') is-invalid @enderror" id="description_en" name="description_en" rows="3">{{ old('description_en', $category->description_en) }}</textarea>
                                    @error('description_en')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="description_ar">توضیحات عربی</label>
                                    <textarea class="form-control @error('description_ar') is-invalid @enderror" id="description_ar" name="description_ar" rows="3">{{ old('description_ar', $category->description_ar) }}</textarea>
                                    @error('description_ar')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- تنظیمات نمایش -->
                    <div class="col-md-6">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="m-0 font-weight-bold text-primary">تنظیمات نمایش</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="emoji">ایموجی</label>
                                    <input type="text" class="form-control @error('emoji') is-invalid @enderror" id="emoji" name="emoji" value="{{ old('emoji', $category->emoji) }}">
                                    <small class="form-text text-muted">یک ایموجی مرتبط برای نمایش در کنار دسته‌بندی</small>
                                    @error('emoji')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="font_icon">آیکون Font Awesome</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">fa-</span>
                                        </div>
                                        <input type="text" class="form-control @error('font_icon') is-invalid @enderror" id="font_icon" name="font_icon" value="{{ old('font_icon', $category->font_icon) }}">
                                    </div>
                                    <small class="form-text text-muted">نام آیکون از Font Awesome بدون پیشوند fa-</small>
                                    @error('font_icon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="color">رنگ</label>
                                    <input type="color" class="form-control @error('color') is-invalid @enderror" id="color" name="color" value="{{ old('color', $category->color) }}">
                                    @error('color')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="sort_order">اولویت نمایش</label>
                                    <input type="number" class="form-control @error('sort_order') is-invalid @enderror" id="sort_order" name="sort_order" value="{{ old('sort_order', $category->sort_order) }}">
                                    <small class="form-text text-muted">عدد کوچکتر، اولویت بالاتر</small>
                                    @error('sort_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <div class="custom-control custom-switch mb-2">
                                        <input type="checkbox" class="custom-control-input" id="show_in_menu" name="show_in_menu" value="1" {{ old('show_in_menu', $category->show_in_menu) == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_in_menu">نمایش در منو</label>
                                    </div>
                                    
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="show_in_filters" name="show_in_filters" value="1" {{ old('show_in_filters', $category->show_in_filters) == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_in_filters">نمایش در فیلترها</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- دکمه‌های ثبت -->
                <div class="text-left">
                    <button type="submit" class="btn btn-primary">بروزرسانی اطلاعات</button>
                    <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">انصراف</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection 