<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Visit extends Model
{
    protected $fillable = [
        'user_id',
        'location_id',
        'ip_address',
        'user_agent'
    ];

    /**
     * ارتباط با کاربر
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * ارتباط با مکان
     */
    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    /**
     * ثبت بازدید جدید
     */
    public static function record($locationId, $userId = null)
    {
        return static::create([
            'location_id' => $locationId,
            'user_id' => $userId,
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent()
        ]);
    }
} 