@foreach($ratings as $rating)
<div class="rating-card">
    <!-- Rating Header -->
    <div class="rating-header">
        <div class="rating-status status-{{ $rating->status }}">
            @switch($rating->status)
                @case('approved')
                    <i class="fas fa-check"></i> تایید شده
                    @break
                @case('rejected')
                    <i class="fas fa-times"></i> رد شده
                    @break
                @default
                    <i class="fas fa-clock"></i> در انتظار تایید
            @endswitch
        </div>
        
        <h3 class="rating-location">{{ $rating->hotel_name }}</h3>
        <div class="rating-category">
            <i class="fas fa-tag"></i>
            {{ $rating->getLocalizedCategoryName() }}
        </div>
        
        <div class="rating-stars">
            <div class="stars">
                @for($i = 1; $i <= 5; $i++)
                    <i class="fas fa-star {{ $i <= $rating->rating ? 'star' : 'star empty' }}"></i>
                @endfor
            </div>
            <span class="rating-value">{{ $rating->rating }}/5</span>
        </div>
    </div>
    
    <!-- Rating Content -->
    <div class="rating-content">
        @if($rating->positive_comment || $rating->negative_comment)
        <div class="rating-comments">
            @if($rating->positive_comment)
            <div class="comment-section">
                <div class="comment-label">
                    <i class="fas fa-thumbs-up text-success"></i>
                    نکات مثبت
                </div>
                <div class="comment-text positive-comments">{!! $rating->positive_comment !!}</div>
            </div>
            @endif
            
            @if($rating->negative_comment)
            <div class="comment-section">
                <div class="comment-label">
                    <i class="fas fa-thumbs-down text-danger"></i>
                    نکات منفی
                </div>
                <div class="comment-text negative-comments">{!! $rating->negative_comment !!}</div>
            </div>
            @endif
        </div>
        @endif
    </div>
    
    <!-- Rating Meta -->
    <div class="rating-meta">
        <div class="rating-date">
            <i class="fas fa-calendar"></i>
            {{ $rating->timestamp ? jdate($rating->timestamp)->format('Y/m/d H:i') : 'نامشخص' }}
        </div>
        
        <div class="rating-actions">
            <a href="{{ route('user.ratings.show', $rating->id) }}" class="action-btn action-btn-primary">
                <i class="fas fa-eye"></i>
                مشاهده
            </a>
            
            @if($rating->status == 'pending')
            <a href="{{ route('user.ratings.edit', $rating->id) }}" class="action-btn action-btn-secondary">
                <i class="fas fa-edit"></i>
                ویرایش
            </a>
            
            <form action="{{ route('user.ratings.destroy', $rating->id) }}" method="POST" class="d-inline" onsubmit="return confirmDelete(event, '{{ $rating->hotel_name }}')">
                @csrf
                @method('DELETE')
                <button type="submit" class="action-btn action-btn-danger">
                    <i class="fas fa-trash"></i>
                    حذف
                </button>
            </form>
            @endif
        </div>
    </div>
</div>
@endforeach
