@foreach($locations as $location)
<div class="location-card">
    <!-- Location Image -->
    <div class="location-image">
        @php
            $images = [];
            if ($location->images && $location->images->count() > 0) {
                $images = $location->images->pluck('image')->toArray();
            } elseif (is_string($location->images)) {
                $images = json_decode($location->images, true) ?? [];
            } elseif (is_array($location->images)) {
                $images = $location->images;
            }
        @endphp
        
        @if(count($images) > 0)
            <img src="{{ asset('storage/locations/' . $images[0]) }}" alt="{{ $location->title }}">
        @else
            <div class="location-image-placeholder">
                <i class="fas fa-image"></i>
            </div>
        @endif
        
        <!-- Status Badge -->
        <div class="location-status status-{{ $location->is_active == 1 ? 'approved' : ($location->is_active == -1 ? 'rejected' : 'pending') }}">
            @if($location->is_active == 1)
                <i class="fas fa-check"></i> تایید شده
            @elseif($location->is_active == -1)
                <i class="fas fa-times"></i> رد شده
            @else
                <i class="fas fa-clock"></i> در انتظار تایید
            @endif
        </div>
    </div>
    
    <!-- Location Content -->
    <div class="location-content">
        <h3 class="location-title">{{ $location->title }}</h3>
        
        <div class="location-meta">
            <div class="location-meta-item">
                <i class="fas fa-map-marker-alt location-meta-icon"></i>
                <span>
                    {{ $location->province ? $location->province->name_fa : '' }}
                    @if($location->city)
                        - {{ $location->city->name_fa }}
                    @endif
                </span>
            </div>
            
            <div class="location-meta-item">
                <i class="fas fa-tag location-meta-icon"></i>
                <span>{{ $location->categoryRelation ? $location->categoryRelation->category_fa : 'دسته‌بندی نامشخص' }}</span>
            </div>
            
            <div class="location-meta-item">
                <i class="fas fa-calendar location-meta-icon"></i>
                <span>{{ $location->created_at ? \App\Helpers\DateHelper::formatByLocale($location->created_at) : 'نامشخص' }}</span>
            </div>
        </div>
        
        @if($location->description)
        <p class="location-description">{{ $location->description }}</p>
        @endif
        
        <!-- Location Stats -->
        <div class="location-stats">
            <div class="location-stat">
                <span class="location-stat-number">{{ $location->ratings_count ?? 0 }}</span>
                <span class="location-stat-label">نظر</span>
            </div>
            <div class="location-stat">
                <span class="location-stat-number">{{ number_format($location->views_count ?? 0) }}</span>
                <span class="location-stat-label">بازدید</span>
            </div>
            <div class="location-stat">
                <span class="location-stat-number">{{ number_format($location->ratings_avg_rating ?? 0, 1) }}</span>
                <span class="location-stat-label">امتیاز</span>
            </div>
        </div>
        
        <!-- Location Actions -->
        <div class="location-actions">
            <a href="{{ route('user.locations.show', $location->id) }}" class="action-btn action-btn-primary">
                <i class="fas fa-eye"></i>
                مشاهده
            </a>
            
            @if($location->is_active == 0)
            <a href="{{ route('user.locations.edit', $location->id) }}" class="action-btn action-btn-secondary">
                <i class="fas fa-edit"></i>
                ویرایش
            </a>
            @endif

            @if($location->is_active == 0)
            <form action="{{ route('user.locations.destroy', $location->id) }}" method="POST" class="d-inline" onsubmit="return confirmDelete(event, '{{ $location->title }}')">
                @csrf
                @method('DELETE')
                <button type="submit" class="action-btn action-btn-danger">
                    <i class="fas fa-trash"></i>
                    حذف
                </button>
            </form>
            @endif
        </div>
    </div>
</div>
@endforeach
