<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بازیابی رمز عبور - مکان‌های ایران</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f8fafc;
            margin: 0;
            padding: 0;
            direction: rtl;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        
        .header h1 {
            margin: 0;
            font-size: 1.8rem;
            font-weight: 700;
        }
        
        .header .icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            color: #fbbf24;
        }
        
        .content {
            padding: 2rem;
        }
        
        .greeting {
            font-size: 1.1rem;
            margin-bottom: 1.5rem;
            color: #374151;
        }
        
        .message {
            background-color: #f3f4f6;
            border-right: 4px solid #667eea;
            padding: 1.5rem;
            margin: 1.5rem 0;
            border-radius: 8px;
        }
        
        .reset-button {
            display: inline-block;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            padding: 1rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            margin: 1.5rem 0;
            text-align: center;
            transition: all 0.3s ease;
        }
        
        .reset-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }
        
        .security-info {
            background-color: #fef3c7;
            border: 1px solid #f59e0b;
            border-radius: 8px;
            padding: 1rem;
            margin: 1.5rem 0;
        }
        
        .security-info h3 {
            color: #92400e;
            margin: 0 0 0.5rem 0;
            font-size: 1rem;
        }
        
        .security-info ul {
            margin: 0;
            padding-right: 1.5rem;
            color: #92400e;
        }
        
        .security-info li {
            margin-bottom: 0.5rem;
        }
        
        .details {
            background-color: #f9fafb;
            border-radius: 8px;
            padding: 1rem;
            margin: 1.5rem 0;
            font-size: 0.9rem;
            color: #6b7280;
        }
        
        .details strong {
            color: #374151;
        }
        
        .footer {
            background-color: #f3f4f6;
            padding: 1.5rem;
            text-align: center;
            color: #6b7280;
            font-size: 0.9rem;
        }
        
        .footer a {
            color: #667eea;
            text-decoration: none;
        }
        
        .footer a:hover {
            text-decoration: underline;
        }
        
        .warning {
            background-color: #fef2f2;
            border: 1px solid #fca5a5;
            border-radius: 8px;
            padding: 1rem;
            margin: 1.5rem 0;
            color: #991b1b;
        }
        
        .warning strong {
            color: #dc2626;
        }
        
        @media (max-width: 600px) {
            .email-container {
                margin: 0;
                border-radius: 0;
            }
            
            .header, .content, .footer {
                padding: 1.5rem;
            }
            
            .reset-button {
                display: block;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="header">
            <div class="icon">🔑</div>
            <h1>بازیابی رمز عبور</h1>
            <p>مکان‌های ایران</p>
        </div>
        
        <!-- Content -->
        <div class="content">
            <div class="greeting">
                سلام {{ $user->full_name }} عزیز،
            </div>
            
            <div class="message">
                <p>درخواست بازیابی رمز عبور برای حساب کاربری شما دریافت شد. برای تغییر رمز عبور خود روی دکمه زیر کلیک کنید:</p>
            </div>
            
            <div style="text-align: center;">
                <a href="{{ $resetUrl }}" class="reset-button">
                    تغییر رمز عبور
                </a>
            </div>
            
            <div class="security-info">
                <h3>🛡️ نکات امنیتی مهم:</h3>
                <ul>
                    <li>این لینک تنها برای <strong>1 ساعت</strong> معتبر است</li>
                    <li>لینک فقط یک بار قابل استفاده است</li>
                    <li>اگر شما این درخواست را نداده‌اید، این ایمیل را نادیده بگیرید</li>
                    <li>هرگز رمز عبور خود را با دیگران به اشتراک نگذارید</li>
                </ul>
            </div>
            
            <div class="details">
                <strong>جزئیات درخواست:</strong><br>
                📅 زمان درخواست: {{ $expiry->subHour()->format('Y/m/d H:i:s') }}<br>
                ⏰ انقضای لینک: {{ $expiry->format('Y/m/d H:i:s') }}<br>
                🌐 آدرس IP: {{ $ipAddress }}<br>
                💻 مرورگر: {{ Str::limit($userAgent, 50) }}
            </div>
            
            <div class="warning">
                <strong>⚠️ هشدار امنیتی:</strong><br>
                اگر این درخواست توسط شما انجام نشده است، ممکن است کسی سعی در دسترسی غیرمجاز به حساب شما داشته باشد. در این صورت:
                <ul>
                    <li>فوراً رمز عبور فعلی خود را تغییر دهید</li>
                    <li>با تیم پشتیبانی ما تماس بگیرید</li>
                    <li>فعالیت‌های مشکوک حساب خود را بررسی کنید</li>
                </ul>
            </div>
            
            <p>اگر دکمه بالا کار نمی‌کند، لینک زیر را کپی کرده و در مرورگر خود باز کنید:</p>
            <div style="background-color: #f3f4f6; padding: 1rem; border-radius: 4px; word-break: break-all; font-family: monospace; font-size: 0.9rem;">
                {{ $resetUrl }}
            </div>
            
            <p style="margin-top: 2rem; color: #6b7280;">
                با تشکر،<br>
                <strong>تیم مکان‌های ایران</strong>
            </p>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <p>
                این ایمیل به صورت خودکار ارسال شده است. لطفاً به آن پاسخ ندهید.<br>
                برای پشتیبانی با ما تماس بگیرید: 
                <a href="mailto:support@iranlocations.com">support@iranlocations.com</a>
            </p>
            <p style="margin-top: 1rem;">
                © {{ date('Y') }} مکان‌های ایران. تمامی حقوق محفوظ است.<br>
                <a href="{{ url('/') }}">بازگشت به سایت</a> | 
                <a href="{{ url('/privacy') }}">حریم خصوصی</a> | 
                <a href="{{ url('/terms') }}">شرایط استفاده</a>
            </p>
        </div>
    </div>
</body>
</html>
