@extends('admin.layouts.app')

@section('title', 'مدیریت قالب‌ها')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6 col-12 mb-2">
            <div class="d-flex align-items-center">
                <h3 class="mb-0"><i class="fas fa-layer-group ml-2"></i> لیست قالب‌ها</h3>
                <span class="badge badge-pill badge-primary ml-2" style="font-size:1rem;">{{ $templates->count() }} قالب</span>
            </div>
        </div>
        <div class="col-md-6 col-12 mb-2 text-md-left text-right">
            <a href="{{ route('admin.templates.create') }}" class="btn btn-gradient-primary btn-lg rounded-pill shadow">
                <i class="fas fa-plus ml-1"></i> ایجاد قالب جدید
            </a>
        </div>
    </div>
    <div class="row mb-3">
        <div class="col-12 col-md-6 mx-auto">
            <input type="text" id="searchInput" class="form-control rounded-pill shadow-sm" placeholder="جستجو در نام یا دسته‌بندی قالب...">
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card shadow-lg rounded-lg">
                <div class="card-body p-0">
                    @if(!empty($templates) && count($templates) > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0" id="templatesTable" style="font-family: 'Vazir', 'IRANSans', Tahoma, sans-serif;">
                                <thead class="thead-light">
                                    <tr>
                                        <th>نام قالب</th>
                                        <th>دسته‌بندی</th>
                                        <th>ویژگی‌های فعال</th>
                                        <th class="text-center">عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($templates as $template)
                                        <tr>
                                            <td>
                                                <i class="fas fa-file-alt text-primary ml-1"></i>
                                                <span class="font-weight-bold">{{ $template->template_name ?? '-' }}</span>
                                            </td>
                                            <td>
                                                <i class="fas fa-folder-open text-info ml-1"></i>
                                                <span>{{ $template->category->category_fa ?? '-' }}</span>
                                            </td>
                                            <td>
                                                @php
                                                    $features = $template->features;
                                                    if (is_string($features)) {
                                                        $features = json_decode($features, true);
                                                    }
                                                    if (!is_array($features)) {
                                                        $features = [];
                                                    }
                                                    $availableFeatures = config('features.available', []);
                                                    $activeCount = 0;
                                                @endphp
                                                <div class="d-flex flex-wrap">
                                                @foreach($features as $key => $settings)
                                                    @if(isset($settings['is_enabled']) && $settings['is_enabled'] && isset($availableFeatures[$key]))
                                                        @php $activeCount++; @endphp
                                                        <span class="badge badge-light border mr-1 mb-1 px-2 py-1 shadow-sm" data-toggle="tooltip" title="{{ $availableFeatures[$key]['title'] }}">
                                                            <i class="{{ $availableFeatures[$key]['icon'] ?? 'fas fa-star' }} text-{{ $availableFeatures[$key]['color'] ?? 'primary' }}"></i>
                                                        </span>
                                                    @endif
                                                @endforeach
                                                @if($activeCount === 0)
                                                    <span class="text-muted small">فاقد ویژگی فعال</span>
                                                @endif
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <a href="{{ route('admin.templates.edit', $template) }}" class="btn btn-info btn-circle btn-sm mx-1 shadow" data-toggle="tooltip" title="ویرایش">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.templates.destroy', $template) }}" method="POST" class="d-inline-block" onsubmit="return confirm('آیا مطمئن هستید؟');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-circle btn-sm mx-1 shadow" data-toggle="tooltip" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info text-center mt-4">
                            هیچ قالبی ثبت نشده است.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    /* استایل جدول مدرن و ریسپانسیو */
    #templatesTable th, #templatesTable td {
        vertical-align: middle !important;
        font-size: 1rem;
    }
    #templatesTable tr {
        transition: box-shadow 0.2s, background 0.2s;
    }
    #templatesTable tr:hover {
        background: #f5f7fa;
        box-shadow: 0 2px 12px rgba(0,0,0,0.04);
    }
    .btn-circle {
        border-radius: 50% !important;
        width: 38px;
        height: 38px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
    }
    .btn-gradient-primary {
        background: linear-gradient(45deg, #007bff, #6610f2);
        color: #fff;
        border: none;
    }
    .btn-gradient-primary:hover {
        background: linear-gradient(45deg, #6610f2, #007bff);
        color: #fff;
    }
    @media (max-width: 768px) {
        #templatesTable, #templatesTable thead, #templatesTable tbody, #templatesTable th, #templatesTable td, #templatesTable tr {
            display: block;
        }
        #templatesTable thead tr {
            display: none;
        }
        #templatesTable tr {
            margin-bottom: 1rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.06);
            border-radius: 12px;
            background: #fff;
        }
        #templatesTable td {
            padding: 1rem 1.5rem;
            text-align: right;
            position: relative;
        }
        #templatesTable td:before {
            content: attr(data-label);
            position: absolute;
            right: 1rem;
            top: 1rem;
            font-weight: bold;
            color: #888;
        }
    }
</style>
@endpush

@push('scripts')
<script>
$(function() {
    // فعال‌سازی Tooltip برای آیکون ویژگی‌ها و دکمه‌ها
    $('[data-toggle="tooltip"]').tooltip();
    
    // جستجوی ایجکس
    var searchTimeout;
    $('#searchInput').on('keyup', function() {
        var value = $(this).val();
        clearTimeout(searchTimeout);
        
        searchTimeout = setTimeout(function() {
            $.ajax({
                url: '{{ route("admin.templates.ajax_search") }}',
                method: 'GET',
                data: {q: value},
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                success: function(response) {
                    if (response.html) {
                        $('#templatesTable tbody').html(response.html);
                        $('[data-toggle="tooltip"]').tooltip();
                    } else if (response.error) {
                        $('#templatesTable tbody').html('<tr><td colspan="4" class="text-center text-danger">' + response.error + '</td></tr>');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('خطا در جستجو:', error);
                    $('#templatesTable tbody').html('<tr><td colspan="4" class="text-center text-danger">خطا در جستجو. لطفا دوباره تلاش کنید.</td></tr>');
                }
            });
        }, 300); // تاخیر 300 میلی‌ثانیه برای جلوگیری از درخواست‌های مکرر
    });
});
</script>
@endpush 