@extends('admin.layouts.app')

@section('title', 'تنظیمات ایمیل')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تنظیمات ایمیل</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.settings.store') }}" method="POST">
                        @csrf
                        
                        <!-- تنظیمات SMTP -->
                        <h4 class="mb-3">تنظیمات SMTP</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mail_host">هاست SMTP</label>
                                    <input type="text" class="form-control @error('mail_host') is-invalid @enderror" 
                                           id="mail_host" name="mail_host" 
                                           value="{{ $settings['mail_host'] ?? old('mail_host') }}">
                                    @error('mail_host')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mail_port">پورت SMTP</label>
                                    <input type="number" class="form-control @error('mail_port') is-invalid @enderror" 
                                           id="mail_port" name="mail_port" 
                                           value="{{ $settings['mail_port'] ?? old('mail_port') }}">
                                    @error('mail_port')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mail_username">نام کاربری SMTP</label>
                                    <input type="text" class="form-control @error('mail_username') is-invalid @enderror" 
                                           id="mail_username" name="mail_username" 
                                           value="{{ $settings['mail_username'] ?? old('mail_username') }}">
                                    @error('mail_username')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mail_password">رمز عبور SMTP</label>
                                    <input type="password" class="form-control @error('mail_password') is-invalid @enderror" 
                                           id="mail_password" name="mail_password" 
                                           value="{{ $settings['mail_password'] ?? old('mail_password') }}">
                                    @error('mail_password')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mail_encryption">نوع رمزنگاری</label>
                                    <select class="form-control @error('mail_encryption') is-invalid @enderror" 
                                            id="mail_encryption" name="mail_encryption">
                                        <option value="tls" {{ ($settings['mail_encryption'] ?? old('mail_encryption')) == 'tls' ? 'selected' : '' }}>TLS</option>
                                        <option value="ssl" {{ ($settings['mail_encryption'] ?? old('mail_encryption')) == 'ssl' ? 'selected' : '' }}>SSL</option>
                                    </select>
                                    @error('mail_encryption')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mail_from_address">آدرس ایمیل فرستنده</label>
                                    <input type="email" class="form-control @error('mail_from_address') is-invalid @enderror" 
                                           id="mail_from_address" name="mail_from_address" 
                                           value="{{ $settings['mail_from_address'] ?? old('mail_from_address') }}">
                                    @error('mail_from_address')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mail_from_name">نام فرستنده</label>
                                    <input type="text" class="form-control @error('mail_from_name') is-invalid @enderror" 
                                           id="mail_from_name" name="mail_from_name" 
                                           value="{{ $settings['mail_from_name'] ?? old('mail_from_name') }}">
                                    @error('mail_from_name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- دکمه‌های عملیات -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">ذخیره تنظیمات</button>
                                <a href="{{ route('admin.settings.index') }}" class="btn btn-secondary">بازگشت</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 