@extends('admin.layouts.app')

@section('title', 'داشبورد امتیازات')

@section('styles')
<style>
    .dashboard-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        border-radius: 15px;
        color: white;
        transition: all 0.3s ease;
        overflow: hidden;
        position: relative;
    }

    .dashboard-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(255,255,255,0.1);
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .dashboard-card:hover::before {
        opacity: 1;
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.15);
    }

    .dashboard-card.card-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .dashboard-card.card-success {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }

    .dashboard-card.card-warning {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }

    .dashboard-card.card-info {
        background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
    }

    .dashboard-card.card-danger {
        background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    }

    .dashboard-card .card-body {
        position: relative;
        z-index: 2;
    }

    .stat-icon {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        font-size: 24px;
    }

    .growth-indicator {
        font-size: 12px;
        padding: 2px 8px;
        border-radius: 12px;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
    }

    .growth-up {
        color: #10b981;
        background: rgba(16, 185, 129, 0.1);
    }

    .growth-down {
        color: #ef4444;
        background: rgba(239, 68, 68, 0.1);
    }

    .chart-container {
        background: white;
        border-radius: 15px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0,0,0,0.05);
        overflow: hidden;
    }

    .chart-container canvas {
        max-height: 400px !important;
    }

    .modern-table {
        background: white;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    }

    .modern-table .table {
        margin-bottom: 0;
    }

    .modern-table .table thead th {
        background: #f8fafc;
        border: none;
        font-weight: 600;
        color: #374151;
        padding: 1rem;
    }

    .modern-table .table tbody td {
        border: none;
        padding: 1rem;
        border-bottom: 1px solid #f1f5f9;
    }

    .rating-stars {
        color: #fbbf24;
    }

    .page-title-modern {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        font-weight: 700;
        font-size: 2rem;
    }

    .breadcrumb-modern {
        background: none;
        padding: 0;
    }

    .breadcrumb-modern .breadcrumb-item a {
        color: #6b7280;
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .breadcrumb-modern .breadcrumb-item a:hover {
        color: #667eea;
    }

    .breadcrumb-modern .breadcrumb-item.active {
        color: #374151;
        font-weight: 500;
    }

    /* Prevent infinite scroll issues */
    body {
        overflow-x: hidden;
    }

    .container-fluid {
        max-width: 100%;
        overflow-x: hidden;
    }

    /* Chart responsiveness */
    canvas {
        max-width: 100% !important;
        height: auto !important;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="page-title-modern mb-2">داشبورد امتیازات</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-modern">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">داشبورد</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.ratings.index') }}">امتیازات</a></li>
                            <li class="breadcrumb-item active">داشبورد امتیازات</li>
                        </ol>
                    </nav>
                </div>
                <div>
                    <button class="btn btn-primary" onclick="refreshDashboard()">
                        <i class="fas fa-sync-alt me-2"></i>به‌روزرسانی
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- KPI Cards -->
    <div class="row mb-4">
        <div class="col-md-6 col-xl-3 mb-3">
            <div class="card dashboard-card card-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-1">{{ number_format($totalRatings) }}</h3>
                            <p class="mb-2 opacity-75">کل امتیازات</p>
                            @if($ratingsGrowth != 0)
                                <span class="growth-indicator {{ $ratingsGrowth > 0 ? 'growth-up' : 'growth-down' }}">
                                    <i class="fas fa-{{ $ratingsGrowth > 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                                    {{ number_format(abs($ratingsGrowth), 1) }}%
                                </span>
                            @endif
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-xl-3 mb-3">
            <div class="card dashboard-card card-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-1">{{ number_format($pendingRatings) }}</h3>
                            <p class="mb-2 opacity-75">در انتظار تایید</p>
                            @if($pendingRatings > 0)
                                <span class="badge bg-light text-dark">
                                    <i class="fas fa-clock me-1"></i>نیاز به بررسی
                                </span>
                            @endif
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-xl-3 mb-3">
            <div class="card dashboard-card card-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-1">{{ number_format($approvedRatings) }}</h3>
                            <p class="mb-2 opacity-75">تایید شده</p>
                            <div class="d-flex align-items-center">
                                <div class="rating-stars me-2">
                                    @for ($i = 1; $i <= 5; $i++)
                                        <i class="fas fa-star {{ $i <= round($averageRating) ? 'text-warning' : 'text-light' }}"></i>
                                    @endfor
                                </div>
                                <span class="small opacity-75">{{ number_format($averageRating, 1) }}</span>
                            </div>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-xl-3 mb-3">
            <div class="card dashboard-card card-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-1">{{ number_format($totalComments) }}</h3>
                            <p class="mb-2 opacity-75">کل نظرات</p>
                            <span class="small opacity-75">
                                {{ number_format($pendingComments) }} در انتظار
                            </span>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-comments"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts and Analytics Section -->
    <div class="row mb-4">
        <!-- Rating Trends Chart -->
        <div class="col-lg-8 mb-4">
            <div class="chart-container">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5 class="card-title mb-0">روند امتیازات (6 ماه اخیر)</h5>
                        <div class="btn-group btn-group-sm" role="group">
                            <button type="button" class="btn btn-outline-primary active" data-period="6">6 ماه</button>
                            <button type="button" class="btn btn-outline-primary" data-period="12">12 ماه</button>
                        </div>
                    </div>
                    <div style="height: 300px;">
                        <canvas id="ratingsChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Rating Distribution -->
        <div class="col-lg-4 mb-4">
            <div class="chart-container">
                <div class="card-body">
                    <h5 class="card-title mb-4">توزیع امتیازات</h5>
                    <div style="height: 250px;">
                        <canvas id="distributionChart"></canvas>
                    </div>
                    <div class="mt-3">
                        <div class="text-center">
                            <h3 class="text-primary mb-1">{{ number_format($averageRating, 1) }}</h3>
                            <div class="rating-stars mb-2">
                                @for ($i = 1; $i <= 5; $i++)
                                    <i class="fas fa-star {{ $i <= round($averageRating) ? 'text-warning' : 'text-muted' }}"></i>
                                @endfor
                            </div>
                            <p class="text-muted small">بر اساس {{ number_format($approvedRatings) }} امتیاز</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activities and Top Locations -->
    <div class="row mb-4">
        <!-- Recent Activities -->
        <div class="col-lg-8 mb-4">
            <div class="modern-table">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5 class="card-title mb-0">فعالیت‌های اخیر</h5>
                        <a href="{{ route('admin.ratings.index') }}" class="btn btn-sm btn-outline-primary">
                            مشاهده همه <i class="fas fa-arrow-left ms-1"></i>
                        </a>
                    </div>

                    @if(count($recentRatings) > 0)
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>مکان</th>
                                        <th>کاربر</th>
                                        <th>امتیاز</th>
                                        <th>نظر</th>
                                        <th>تاریخ</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentRatings as $rating)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-sm bg-light rounded me-2">
                                                    <i class="fas fa-map-marker-alt text-primary"></i>
                                                </div>
                                                <div>
                                                    <h6 class="mb-0">{{ $rating->location->title ?? 'نامشخص' }}</h6>
                                                    <small class="text-muted">{{ $rating->getLocalizedCategoryName() ?? 'عمومی' }}</small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <span class="fw-medium">{{ $rating->name ?? 'ناشناس' }}</span>
                                                @if($rating->email)
                                                    <br><small class="text-muted">{{ $rating->email }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="badge bg-warning text-dark me-2">{{ $rating->rating }}</span>
                                                <div class="rating-stars">
                                                    @for ($i = 1; $i <= 5; $i++)
                                                        <i class="fas fa-star {{ $i <= $rating->rating ? 'text-warning' : 'text-muted' }}"></i>
                                                    @endfor
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="text-muted">{{ \Str::limit($rating->comment, 40) }}</span>
                                        </td>
                                        <td>
                                            <small class="text-muted">{{ $rating->timestamp->diffForHumans() }}</small>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.ratings.index') }}?id={{ $rating->id }}"
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center p-5">
                            <i class="fas fa-star fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">هیچ امتیاز جدیدی در ۳۰ روز گذشته ثبت نشده است</h5>
                            <p class="text-muted">امتیازات جدید در اینجا نمایش داده خواهند شد</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Top Locations -->
        <div class="col-lg-4 mb-4">
            <div class="chart-container">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5 class="card-title mb-0">برترین مکان‌ها</h5>
                        <a href="{{ route('admin.ratings.analytics') }}" class="btn btn-sm btn-outline-primary">
                            آنالیز کامل
                        </a>
                    </div>

                    @if(count($topLocations) > 0)
                        <div class="space-y-3">
                            @foreach($topLocations->take(8) as $index => $locationStat)
                                <div class="d-flex align-items-center p-3 bg-light rounded mb-2">
                                    <div class="me-3">
                                        <span class="badge bg-primary rounded-pill">{{ $index + 1 }}</span>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">{{ $locationStat->location->title ?? 'نامشخص' }}</h6>
                                        <div class="d-flex align-items-center">
                                            <div class="rating-stars me-2">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <i class="fas fa-star {{ $i <= round($locationStat->average_rating) ? 'text-warning' : 'text-muted' }}"></i>
                                                @endfor
                                            </div>
                                            <span class="small text-muted">
                                                {{ number_format($locationStat->average_rating, 1) }}
                                                ({{ number_format($locationStat->total_ratings) }} امتیاز)
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center p-4">
                            <i class="fas fa-trophy fa-3x text-muted mb-3"></i>
                            <h6 class="text-muted">هنوز رتبه‌بندی موجود نیست</h6>
                            <p class="text-muted small">حداقل 3 امتیاز برای هر مکان لازم است</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Category Performance -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="chart-container">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5 class="card-title mb-0">عملکرد دسته‌بندی‌ها</h5>
                        <div class="btn-group btn-group-sm" role="group">
                            <button type="button" class="btn btn-outline-primary active" data-view="chart">نمودار</button>
                            <button type="button" class="btn btn-outline-primary" data-view="table">جدول</button>
                        </div>
                    </div>

                    <div id="categoryChart">
                        <div style="height: 350px;">
                            <canvas id="categoryPerformanceChart"></canvas>
                        </div>
                    </div>

                    <div id="categoryTable" style="display: none;">
                        @if(count($categoryPerformance) > 0)
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>دسته‌بندی</th>
                                            <th>تعداد امتیازات</th>
                                            <th>میانگین امتیاز</th>
                                            <th>عملکرد</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($categoryPerformance as $category)
                                        <tr>
                                            <td>
                                                <span class="fw-medium">{{ $category->category }}</span>
                                            </td>
                                            <td>
                                                <span class="badge bg-primary">{{ number_format($category->total_ratings) }}</span>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <span class="me-2">{{ number_format($category->avg_rating, 1) }}</span>
                                                    <div class="rating-stars">
                                                        @for ($i = 1; $i <= 5; $i++)
                                                            <i class="fas fa-star {{ $i <= round($category->avg_rating) ? 'text-warning' : 'text-muted' }}"></i>
                                                        @endfor
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                @php
                                                    $performance = $category->avg_rating >= 4 ? 'عالی' : ($category->avg_rating >= 3 ? 'خوب' : 'نیاز به بهبود');
                                                    $badgeClass = $category->avg_rating >= 4 ? 'bg-success' : ($category->avg_rating >= 3 ? 'bg-warning' : 'bg-danger');
                                                @endphp
                                                <span class="badge {{ $badgeClass }}">{{ $performance }}</span>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center p-4">
                                <i class="fas fa-chart-bar fa-3x text-muted mb-3"></i>
                                <h6 class="text-muted">هنوز داده‌ای برای نمایش وجود ندارد</h6>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- User Engagement Metrics -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="card dashboard-card card-info">
                <div class="card-body text-center">
                    <div class="stat-icon mx-auto mb-3">
                        <i class="fas fa-users"></i>
                    </div>
                    <h4 class="mb-1">{{ number_format($userEngagement['unique_reviewers']) }}</h4>
                    <p class="mb-0 opacity-75">کاربران فعال</p>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card dashboard-card card-success">
                <div class="card-body text-center">
                    <div class="stat-icon mx-auto mb-3">
                        <i class="fas fa-redo"></i>
                    </div>
                    <h4 class="mb-1">{{ number_format($userEngagement['repeat_reviewers']) }}</h4>
                    <p class="mb-0 opacity-75">کاربران مکرر</p>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card dashboard-card card-warning">
                <div class="card-body text-center">
                    <div class="stat-icon mx-auto mb-3">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h4 class="mb-1">{{ $userEngagement['avg_reviews_per_user'] }}</h4>
                    <p class="mb-0 opacity-75">میانگین امتیاز/کاربر</p>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card dashboard-card card-danger">
                <div class="card-body text-center">
                    <div class="stat-icon mx-auto mb-3">
                        <i class="fas fa-thumbs-up"></i>
                    </div>
                    <h4 class="mb-1">{{ number_format($userEngagement['helpful_votes_total']) }}</h4>
                    <p class="mb-0 opacity-75">رای‌های مفید</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Data from backend with safety checks
    const monthlyTrends = @json($monthlyTrends ?? []);
    const ratingDistribution = @json($ratingDistribution ?? []);
    const categoryPerformance = @json($categoryPerformance ?? []);

    // Debug data
    console.log('Monthly Trends:', monthlyTrends);
    console.log('Rating Distribution:', ratingDistribution);
    console.log('Category Performance:', categoryPerformance);

    // Initialize charts with delay to ensure DOM is ready
    setTimeout(() => {
        try {
            initRatingsChart();
            initDistributionChart();
            initCategoryChart();
            initInteractivity();
        } catch (error) {
            console.error('Error initializing dashboard:', error);
        }
    }, 200);

    // Ratings Trend Chart
    function initRatingsChart() {
        const ctx = document.getElementById('ratingsChart');
        if (!ctx || !monthlyTrends || monthlyTrends.length === 0) {
            console.log('Skipping ratings chart - no data or element');
            return;
        }

        new Chart(ctx, {
            type: 'line',
            data: {
                labels: monthlyTrends.map(item => item.month_short),
                datasets: [{
                    label: 'تعداد امتیازات',
                    data: monthlyTrends.map(item => item.ratings_count),
                    borderColor: '#667eea',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointBackgroundColor: '#667eea',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointRadius: 6
                }, {
                    label: 'میانگین امتیاز',
                    data: monthlyTrends.map(item => item.avg_rating),
                    borderColor: '#f093fb',
                    backgroundColor: 'rgba(240, 147, 251, 0.1)',
                    borderWidth: 3,
                    fill: false,
                    tension: 0.4,
                    pointBackgroundColor: '#f093fb',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointRadius: 6,
                    yAxisID: 'y1'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            usePointStyle: true,
                            padding: 20,
                            font: {
                                family: 'IRANSans, Arial, sans-serif'
                            }
                        }
                    },
                    tooltip: {
                        backgroundColor: 'rgba(0,0,0,0.8)',
                        titleColor: '#fff',
                        bodyColor: '#fff',
                        borderColor: '#667eea',
                        borderWidth: 1,
                        cornerRadius: 8,
                        displayColors: true
                    }
                },
                scales: {
                    y: {
                        type: 'linear',
                        display: true,
                        position: 'left',
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        },
                        ticks: {
                            font: {
                                family: 'IRANSans, Arial, sans-serif'
                            }
                        }
                    },
                    y1: {
                        type: 'linear',
                        display: true,
                        position: 'right',
                        min: 0,
                        max: 5,
                        grid: {
                            drawOnChartArea: false,
                        },
                        ticks: {
                            font: {
                                family: 'IRANSans, Arial, sans-serif'
                            }
                        }
                    },
                    x: {
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        },
                        ticks: {
                            font: {
                                family: 'IRANSans, Arial, sans-serif'
                            }
                        }
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index'
                }
            }
        });
    }

    // Rating Distribution Chart
    function initDistributionChart() {
        const ctx = document.getElementById('distributionChart');
        if (!ctx || !ratingDistribution || Object.keys(ratingDistribution).length === 0) {
            console.log('Skipping distribution chart - no data or element');
            return;
        }

        const distributionData = Object.values(ratingDistribution);
        const distributionLabels = ['1 ستاره', '2 ستاره', '3 ستاره', '4 ستاره', '5 ستاره'];

        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: distributionLabels,
                datasets: [{
                    data: distributionData,
                    backgroundColor: [
                        '#ef4444',
                        '#f97316',
                        '#eab308',
                        '#22c55e',
                        '#10b981'
                    ],
                    borderWidth: 0,
                    hoverBorderWidth: 3,
                    hoverBorderColor: '#fff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            usePointStyle: true,
                            padding: 15,
                            font: {
                                family: 'IRANSans, Arial, sans-serif',
                                size: 12
                            }
                        }
                    },
                    tooltip: {
                        backgroundColor: 'rgba(0,0,0,0.8)',
                        titleColor: '#fff',
                        bodyColor: '#fff',
                        borderColor: '#667eea',
                        borderWidth: 1,
                        cornerRadius: 8,
                        callbacks: {
                            label: function(context) {
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = ((context.parsed / total) * 100).toFixed(1);
                                return context.label + ': ' + context.parsed + ' (' + percentage + '%)';
                            }
                        }
                    }
                },
                cutout: '60%'
            }
        });
    }

    // Category Performance Chart
    function initCategoryChart() {
        const ctx = document.getElementById('categoryPerformanceChart');
        if (!ctx || !categoryPerformance || categoryPerformance.length === 0) {
            console.log('Skipping category chart - no data or element');
            return;
        }

        const categories = categoryPerformance.map(item => item.category);
        const ratings = categoryPerformance.map(item => item.total_ratings);
        const avgRatings = categoryPerformance.map(item => parseFloat(item.avg_rating));

        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: categories,
                datasets: [{
                    label: 'تعداد امتیازات',
                    data: ratings,
                    backgroundColor: 'rgba(102, 126, 234, 0.8)',
                    borderColor: '#667eea',
                    borderWidth: 1,
                    borderRadius: 8,
                    borderSkipped: false,
                    yAxisID: 'y'
                }, {
                    label: 'میانگین امتیاز',
                    data: avgRatings,
                    type: 'line',
                    borderColor: '#f093fb',
                    backgroundColor: 'rgba(240, 147, 251, 0.1)',
                    borderWidth: 3,
                    fill: false,
                    tension: 0.4,
                    pointBackgroundColor: '#f093fb',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointRadius: 6,
                    yAxisID: 'y1'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            usePointStyle: true,
                            padding: 20,
                            font: {
                                family: 'IRANSans, Arial, sans-serif'
                            }
                        }
                    },
                    tooltip: {
                        backgroundColor: 'rgba(0,0,0,0.8)',
                        titleColor: '#fff',
                        bodyColor: '#fff',
                        borderColor: '#667eea',
                        borderWidth: 1,
                        cornerRadius: 8
                    }
                },
                scales: {
                    y: {
                        type: 'linear',
                        display: true,
                        position: 'left',
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        },
                        ticks: {
                            font: {
                                family: 'IRANSans, Arial, sans-serif'
                            }
                        }
                    },
                    y1: {
                        type: 'linear',
                        display: true,
                        position: 'right',
                        min: 0,
                        max: 5,
                        grid: {
                            drawOnChartArea: false,
                        },
                        ticks: {
                            font: {
                                family: 'IRANSans, Arial, sans-serif'
                            }
                        }
                    },
                    x: {
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        },
                        ticks: {
                            font: {
                                family: 'IRANSans, Arial, sans-serif'
                            },
                            maxRotation: 45
                        }
                    }
                }
            }
        });
    }

    // Initialize interactivity
    function initInteractivity() {
        // Category view toggle
        const chartBtn = document.querySelector('[data-view="chart"]');
        const tableBtn = document.querySelector('[data-view="table"]');
        const chartDiv = document.getElementById('categoryChart');
        const tableDiv = document.getElementById('categoryTable');

        if (chartBtn && tableBtn) {
            chartBtn.addEventListener('click', function() {
                chartBtn.classList.add('active');
                tableBtn.classList.remove('active');
                chartDiv.style.display = 'block';
                tableDiv.style.display = 'none';
            });

            tableBtn.addEventListener('click', function() {
                tableBtn.classList.add('active');
                chartBtn.classList.remove('active');
                chartDiv.style.display = 'none';
                tableDiv.style.display = 'block';
            });
        }

        // Refresh dashboard
        window.refreshDashboard = function() {
            // Show loading state
            const refreshBtn = document.querySelector('[onclick="refreshDashboard()"]');
            if (refreshBtn) {
                const originalText = refreshBtn.innerHTML;
                refreshBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>در حال بارگذاری...';
                refreshBtn.disabled = true;

                // Reload page after a short delay
                setTimeout(() => {
                    window.location.reload();
                }, 1000);
            }
        };

        // Add hover effects to cards (throttled)
        document.querySelectorAll('.dashboard-card').forEach(card => {
            let hoverTimeout;

            card.addEventListener('mouseenter', function() {
                clearTimeout(hoverTimeout);
                this.style.transform = 'translateY(-5px)';
            });

            card.addEventListener('mouseleave', function() {
                clearTimeout(hoverTimeout);
                hoverTimeout = setTimeout(() => {
                    this.style.transform = 'translateY(0)';
                }, 50);
            });
        });

        // Animate numbers on load
        animateNumbers();
    }

    // Animate numbers (optimized)
    function animateNumbers() {
        const numberElements = document.querySelectorAll('.dashboard-card h3, .dashboard-card h4');

        numberElements.forEach(element => {
            const text = element.textContent.replace(/,/g, '');
            const finalNumber = parseInt(text);

            // Skip if not a number or if number is too large
            if (isNaN(finalNumber) || finalNumber > 100000) {
                return;
            }

            let currentNumber = 0;
            const increment = Math.max(1, Math.ceil(finalNumber / 30)); // Faster animation
            const timer = setInterval(() => {
                currentNumber += increment;
                if (currentNumber >= finalNumber) {
                    currentNumber = finalNumber;
                    clearInterval(timer);
                }
                element.textContent = Math.floor(currentNumber).toLocaleString();
            }, 50); // Slower interval to reduce CPU usage
        });
    }
});
</script>
@endsection