@extends('layouts.admin')

@section('title', 'ایجاد پکیج تبلیغاتی جدید')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">ایجاد پکیج تبلیغاتی جدید</h1>
        <a href="{{ route('admin.packages.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-right fa-sm text-white-50"></i> بازگشت به لیست
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">فرم ایجاد پکیج تبلیغاتی</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.packages.store') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">نام پکیج <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="package_key">کلید پکیج <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('package_key') is-invalid @enderror" id="package_key" name="package_key" value="{{ old('package_key') }}" required>
                            @error('package_key')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">از حروف انگلیسی و اعداد استفاده کنید. مثال: diamond، gold، etc.</small>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="description">توضیحات</label>
                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                    @error('description')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="price">قیمت (ریال) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control @error('price') is-invalid @enderror" id="price" name="price" value="{{ old('price') }}" required>
                            @error('price')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="duration_days">مدت اعتبار (روز) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control @error('duration_days') is-invalid @enderror" id="duration_days" name="duration_days" value="{{ old('duration_days', 30) }}" required>
                            @error('duration_days')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <hr>
                <h5>تنظیمات ظاهری</h5>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="badge_text">متن نشان روی کارت</label>
                            <input type="text" class="form-control @error('badge_text') is-invalid @enderror" id="badge_text" name="badge_text" value="{{ old('badge_text') }}">
                            @error('badge_text')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="badge_color">رنگ نشان</label>
                            <input type="color" class="form-control @error('badge_color') is-invalid @enderror" id="badge_color" name="badge_color" value="{{ old('badge_color', '#FFC107') }}">
                            @error('badge_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="card_design">طراحی کارت <span class="text-danger">*</span></label>
                            <select class="form-control @error('card_design') is-invalid @enderror" id="card_design" name="card_design" required>
                                <option value="standard" @if(old('card_design') == 'standard') selected @endif>استاندارد</option>
                                <option value="diamond" @if(old('card_design') == 'diamond') selected @endif>الماس</option>
                                <option value="gold" @if(old('card_design') == 'gold') selected @endif>طلایی</option>
                                <option value="silver" @if(old('card_design') == 'silver') selected @endif>نقره‌ای</option>
                                <option value="bronze" @if(old('card_design') == 'bronze') selected @endif>برنزی</option>
                            </select>
                            @error('card_design')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="priority">اولویت نمایش <span class="text-danger">*</span></label>
                            <input type="number" class="form-control @error('priority') is-invalid @enderror" id="priority" name="priority" value="{{ old('priority', 10) }}" required>
                            @error('priority')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">اولویت کوچکتر = نمایش بالاتر</small>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="card_border_color">رنگ حاشیه کارت</label>
                            <input type="color" class="form-control @error('card_border_color') is-invalid @enderror" id="card_border_color" name="card_border_color" value="{{ old('card_border_color', '#4e73df') }}">
                            @error('card_border_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="card_background_color">رنگ پس‌زمینه کارت</label>
                            <input type="color" class="form-control @error('card_background_color') is-invalid @enderror" id="card_background_color" name="card_background_color" value="{{ old('card_background_color', '#ffffff') }}">
                            @error('card_background_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="card_text_color">رنگ متن کارت</label>
                            <input type="color" class="form-control @error('card_text_color') is-invalid @enderror" id="card_text_color" name="card_text_color" value="{{ old('card_text_color', '#000000') }}">
                            @error('card_text_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <div class="custom-control custom-switch">
                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', 1) ? 'checked' : '' }}>
                        <label class="custom-control-label" for="is_active">پکیج فعال باشد</label>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">ذخیره پکیج</button>
            </form>
        </div>
    </div>
</div>
@endsection 