@extends('admin.layouts.app')

@section('title', 'جزئیات شهرستان')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>جزئیات شهرستان</h4>
                <div>
                    <a href="{{ route('admin.geography.counties.edit', $item->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> ویرایش
                    </a>
                    <a href="{{ route('admin.geography.counties.index') }}" class="btn btn-secondary">
                        <i class="fas fa-list"></i> بازگشت به لیست شهرستان‌ها
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">شناسه شهرستان</th>
                            <td>{{ $item->id }}</td>
                        </tr>
                        <tr>
                            <th>نام</th>
                            <td>{{ $item->name }}</td>
                        </tr>
                        <tr>
                            <th>نام انگلیسی</th>
                            <td>{{ $item->name_en ?? 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>استان</th>
                            <td>
                                <a href="{{ route('admin.geography.provinces.show', $item->province_id) }}">
                                    {{ $item->province->name ?? 'ندارد' }}
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>نامک (Slug)</th>
                            <td><code>{{ $item->slug }}</code></td>
                        </tr>
                        <tr>
                            <th>نامک سراسری</th>
                            <td><code>{{ $item->global_slug ?? 'ندارد' }}</code></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">شهر مرکزی</th>
                            <td>{{ $item->center_city_name ?? 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>مساحت</th>
                            <td>{{ isset($item->area) ? number_format($item->area, 2) . ' کیلومتر مربع' : 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>جمعیت</th>
                            <td>{{ isset($item->population) ? number_format($item->population) : 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>کد</th>
                            <td>{{ $item->code ?? 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>وضعیت</th>
                            <td>
                                <span class="badge {{ $item->is_active ? 'bg-success' : 'bg-danger' }}">
                                    {{ $item->is_active ? 'فعال' : 'غیرفعال' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>تاریخ ایجاد</th>
                            <td>{{ $item->created_at ? $item->created_at->format('Y-m-d H:i:s') : 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>تاریخ بروزرسانی</th>
                            <td>{{ $item->updated_at ? $item->updated_at->format('Y-m-d H:i:s') : 'ندارد' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            @if($item->description)
            <div class="row mt-4">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>توضیحات</h5>
                        </div>
                        <div class="card-body">
                            {{ $item->description }}
                        </div>
                    </div>
                </div>
            </div>
            @endif

            {{-- بخش نقشه اگر داده مرزها وجود داشته باشد --}}
            @if(isset($item->boundaries))
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>مرزهای جغرافیایی</h5>
                    <div id="countyMap" style="height: 400px; width: 100%;"></div>
                </div>
            </div>
            @endif
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5>بخش‌ها</h5>
                <a href="{{ route('admin.geography.districts.create') }}" class="btn btn-sm btn-primary">
                    <i class="fas fa-plus"></i> افزودن بخش
                </a>
            </div>
        </div>
        <div class="card-body">
            @if(isset($districts) && $districts->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>شناسه</th>
                                <th>نام</th>
                                <th>نام انگلیسی</th>
                                <th>شهر مرکزی</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($districts as $district)
                            <tr>
                                <td>{{ $district->id }}</td>
                                <td>{{ $district->name }}</td>
                                <td>{{ $district->name_en ?? 'ندارد' }}</td>
                                <td>{{ $district->center_city_name ?? 'ندارد' }}</td>
                                <td>
                                    <span class="badge {{ $district->is_active ? 'bg-success' : 'bg-danger' }}">
                                        {{ $district->is_active ? 'فعال' : 'غیرفعال' }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.geography.districts.show', $district->id) }}" class="btn btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.geography.districts.edit', $district->id) }}" class="btn btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted">هیچ بخشی برای این شهرستان یافت نشد.</p>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')
@if(isset($item->boundaries))
<script>
    // در صورت نیاز، کد مربوط به نمایش نقشه اینجا قرار می‌گیرد
    $(document).ready(function() {
        // اگر قصد پیاده‌سازی قابلیت نقشه دارید، کد آن اینجا قرار می‌گیرد
    });
</script>
@endif
@endsection 