<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LocationContentType extends Model
{
    use HasFactory;

    protected $table = 'location_content_types';

    protected $fillable = [
        'type_key',
        'type_name',
        'icon',
        'description',
        'display_order',
        'is_active',
    ];

    protected $casts = [
        'display_order' => 'integer',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function contents()
    {
        return $this->hasMany(LocationContent::class, 'content_type_id');
    }
}
