<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LocationContent extends Model
{
    use HasFactory;

    protected $table = 'location_contents';

    protected $fillable = [
        'location_id',
        'content_type_id',
        'title',
        'content',
        'extra_data',
        'sort_order',
        'is_active',
    ];

    protected $casts = [
        'extra_data' => 'array',
        'sort_order' => 'integer',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function contentType()
    {
        return $this->belongsTo(LocationContentType::class, 'content_type_id');
    }
}
