<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LocationAmenity extends Model
{
    use HasFactory;

    protected $table = 'location_amenities';

    protected $fillable = [
        'location_id',
        'amenity_id',
        'value',
        'badge',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function amenity()
    {
        return $this->belongsTo(Amenity::class);
    }
}
