<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class Language
{
    /**
     * Handle an incoming request.
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (Session::has('locale')) {
            App::setLocale(Session::get('locale'));
        } else {
            // Set default language based on user's browser or preferences
            $browserLang = substr($request->server('HTTP_ACCEPT_LANGUAGE'), 0, 2);
            $defaultLang = in_array($browserLang, ['fa', 'en']) ? $browserLang : 'en';
            App::setLocale($defaultLang);
            Session::put('locale', $defaultLang);
        }

        return $next($request);
    }
}
