<?php

namespace App\Helpers;

class NumberHelper
{
    /**
     * Format number based on current locale
     *
     * @param int|float $number
     * @param int $decimals
     * @return string
     */
    public static function formatNumber($number, $decimals = 0)
    {
        $locale = app()->getLocale();

        if ($locale === 'fa') {
            // Convert English numbers to Persian
            $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
            $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];

            $formatted = number_format($number, $decimals, '.', ',');
            return str_replace($english, $persian, $formatted);
        }

        return number_format($number, $decimals, '.', ',');
    }

    /**
     * Convert English numbers to Persian
     *
     * @param string|int|float $input
     * @return string
     */
    public static function toPersian($input)
    {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];

        return str_replace($english, $persian, (string)$input);
    }

    /**
     * Convert Persian numbers to English
     *
     * @param string $input
     * @return string
     */
    public static function toEnglish($input)
    {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];

        return str_replace($persian, $english, $input);
    }
} 