<?php $__env->startSection('title', 'مدیریت استان‌ها'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>مدیریت استان‌ها</h4>
                <a href="<?php echo e(route('admin.geography.provinces.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> افزودن استان جدید
                </a>
            </div>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>نام</th>
                            <th>نام انگلیسی</th>
                            <th>کشور</th>
                            <th>مرکز</th>
                            <th>کد</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($province->id); ?></td>
                                <td><?php echo e($province->name); ?></td>
                                <td><?php echo e($province->name_en ?? 'ندارد'); ?></td>
                                <td>
                                    <?php if($province->country): ?>
                                        <a href="<?php echo e(route('admin.geography.countries.show', $province->country_id)); ?>">
                                            <?php echo e($province->country->name); ?>

                                        </a>
                                    <?php else: ?>
                                        ندارد
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($province->center_city_name ?? 'ندارد'); ?></td>
                                <td><?php echo e($province->code ?? 'ندارد'); ?></td>
                                <td>
                                    <span class="badge <?php echo e($province->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                        <?php echo e($province->is_active ? 'فعال' : 'غیرفعال'); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?php echo e(route('admin.geography.provinces.show', $province->id)); ?>" class="btn btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.geography.provinces.edit', $province->id)); ?>" class="btn btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-danger delete-item" 
                                                data-id="<?php echo e($province->id); ?>" 
                                                data-url="<?php echo e(route('admin.geography.provinces.destroy', $province->id)); ?>">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center">هیچ استانی یافت نشد</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if(isset($items) && $items->hasPages()): ?>
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($items->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- مودال تأیید حذف -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">تأیید حذف</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                آیا از حذف این استان اطمینان دارید؟ این عملیات قابل بازگشت نیست.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">حذف</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        let deleteUrl = '';
        let deleteId = '';
        
        $('.delete-item').on('click', function() {
            deleteUrl = $(this).data('url');
            deleteId = $(this).data('id');
            $('#deleteModal').modal('show');
        });
        
        $('#confirmDelete').on('click', function() {
            $.ajax({
                url: deleteUrl,
                type: 'DELETE',
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                },
                success: function(response) {
                    if(response.success) {
                        $('#deleteModal').modal('hide');
                        $('tr[data-id="' + deleteId + '"]').remove();
                        // نمایش پیام موفقیت‌آمیز
                        let alertHtml = '<div class="alert alert-success">' + response.message + '</div>';
                        $('.card-body').prepend(alertHtml);
                        // بارگذاری مجدد صفحه بعد از مدت کوتاهی
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    } else {
                        // نمایش پیام خطا در مودال
                        $('.modal-body').html('<div class="alert alert-danger">' + response.message + '</div>');
                    }
                },
                error: function(xhr) {
                    // نمایش پیام خطا در مودال
                    $('.modal-body').html('<div class="alert alert-danger">خطایی در پردازش درخواست شما رخ داد.</div>');
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/geography/provinces/index.blade.php ENDPATH**/ ?>