<?php
    use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
    $languages = \App\Models\Language::where('is_active', true)->orderBy('order')->get();
    $currentLocale = app()->getLocale();
?>

<!--
    این کامپوننت سوییچر زبان است و پرچم هر زبان را با ایموجی نمایش می‌دهد.
    اگر مقدار name کد کشور باشد (مثلاً FA)، نام صحیح را جایگزین می‌کند.
-->
<div class="language-switcher">
    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($language->code, null, [], true)); ?>"
           class="language-link <?php echo e($currentLocale === $language->code ? 'active' : ''); ?>">
            <?php if($language->flag): ?>
                <span class="flag-emoji" title="<?php echo e($language->native_name); ?>"><?php echo $language->flag; ?></span>
            <?php endif; ?>
            <?php echo e(in_array(strtoupper($language->name), ['FA','EN','AR']) ? $language->native_name : $language->name); ?>

        </a>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<style>
.language-switcher {
    display: flex;
    gap: 10px;
    align-items: center;
}

.language-link {
    padding: 4px 10px;
    border-radius: 6px;
    color: #333;
    text-decoration: none;
    font-weight: 500;
    transition: background 0.2s;
    display: flex;
    align-items: center;
    gap: 5px;
}

.language-link.active {
    background: #f0ad4e;
    color: #fff;
}

.flag-emoji {
    font-size: 1.2em;
    line-height: 1;
    display: inline-block;
    vertical-align: middle;
    font-family: 'Segoe UI Emoji', 'Apple Color Emoji', 'Noto Color Emoji', 'Arial', sans-serif !important;
}

[dir="rtl"] .language-link {
    flex-direction: row-reverse;
}
</style> <?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/components/language-switcher.blade.php ENDPATH**/ ?>