-- آماده‌سازی داده‌های چندزبانه برای هدر و منوی سایت
-- زبان‌ها: فارسی (fa)، انگلیسی (en)، عربی (ar)

-- 1. نمایش وضعیت فعلی
SELECT '=== وضعیت فعلی ===' as status;

SELECT 'تنظیمات هدر موجود:' as type;
SELECT language_code, COUNT(*) as count 
FROM header_settings 
GROUP BY language_code 
ORDER BY language_code;

SELECT 'دکمه‌های کاربری موجود:' as type;
SELECT language_code, COUNT(*) as count 
FROM button_settings 
GROUP BY language_code 
ORDER BY language_code;

-- 2. حذف داده‌های موجود (اختیاری - برای شروع تمیز)
SELECT '=== پاک‌سازی داده‌های موجود ===' as cleanup;

-- ایجاد پشتیبان
CREATE TABLE IF NOT EXISTS header_settings_backup_multilingual AS 
SELECT * FROM header_settings;

CREATE TABLE IF NOT EXISTS button_settings_backup_multilingual AS 
SELECT * FROM button_settings;

-- حذف داده‌های موجود
DELETE FROM header_settings WHERE language_code IN ('fa', 'en', 'ar');
DELETE FROM button_settings WHERE language_code IN ('fa', 'en', 'ar');

SELECT 'داده‌های موجود پاک شدند و پشتیبان ایجاد شد.' as cleanup_result;

-- 3. تنظیمات هدر - زبان فارسی
SELECT '=== تنظیمات هدر فارسی ===' as fa_header;

INSERT INTO header_settings (setting_key, setting_value, language_code, is_active, created_at, updated_at) VALUES
-- تنظیمات اصلی
('site_logo', '/images/logo.png', 'fa', 1, NOW(), NOW()),
('site_title', 'اَلو ایران', 'fa', 1, NOW(), NOW()),

-- تنظیمات جستجو
('show_search_box', '1', 'fa', 1, NOW(), NOW()),
('search_placeholder', 'جستجو در مکان‌ها...', 'fa', 1, NOW(), NOW()),

-- تنظیمات منو
('show_language_switcher', '1', 'fa', 1, NOW(), NOW()),
('show_user_menu', '1', 'fa', 1, NOW(), NOW()),

-- تنظیمات ظاهری
('header_style', 'default', 'fa', 1, NOW(), NOW()),
('sticky_header', '1', 'fa', 1, NOW(), NOW()),
('show_breadcrumb', '1', 'fa', 1, NOW(), NOW()),

-- متن‌های دکمه‌ها
('login_text', 'ورود', 'fa', 1, NOW(), NOW()),
('logout_text', 'خروج', 'fa', 1, NOW(), NOW()),
('add_location_text', 'ثبت مکان جدید', 'fa', 1, NOW(), NOW()),
('add_location_url', '/user/locations/create', 'fa', 1, NOW(), NOW()),
('show_add_location_button', '1', 'fa', 1, NOW(), NOW());

-- 4. تنظیمات هدر - زبان انگلیسی
SELECT '=== تنظیمات هدر انگلیسی ===' as en_header;

INSERT INTO header_settings (setting_key, setting_value, language_code, is_active, created_at, updated_at) VALUES
-- تنظیمات اصلی
('site_logo', '/images/logo.png', 'en', 1, NOW(), NOW()),
('site_title', 'Alo Iran', 'en', 1, NOW(), NOW()),

-- تنظیمات جستجو
('show_search_box', '1', 'en', 1, NOW(), NOW()),
('search_placeholder', 'Search locations...', 'en', 1, NOW(), NOW()),

-- تنظیمات منو
('show_language_switcher', '1', 'en', 1, NOW(), NOW()),
('show_user_menu', '1', 'en', 1, NOW(), NOW()),

-- تنظیمات ظاهری
('header_style', 'default', 'en', 1, NOW(), NOW()),
('sticky_header', '1', 'en', 1, NOW(), NOW()),
('show_breadcrumb', '1', 'en', 1, NOW(), NOW()),

-- متن‌های دکمه‌ها
('login_text', 'Login', 'en', 1, NOW(), NOW()),
('logout_text', 'Logout', 'en', 1, NOW(), NOW()),
('add_location_text', 'Add New Location', 'en', 1, NOW(), NOW()),
('add_location_url', '/user/locations/create', 'en', 1, NOW(), NOW()),
('show_add_location_button', '1', 'en', 1, NOW(), NOW());

-- 5. تنظیمات هدر - زبان عربی
SELECT '=== تنظیمات هدر عربی ===' as ar_header;

INSERT INTO header_settings (setting_key, setting_value, language_code, is_active, created_at, updated_at) VALUES
-- تنظیمات اصلی
('site_logo', '/images/logo.png', 'ar', 1, NOW(), NOW()),
('site_title', 'ألو إيران', 'ar', 1, NOW(), NOW()),

-- تنظیمات جستجو
('show_search_box', '1', 'ar', 1, NOW(), NOW()),
('search_placeholder', 'البحث في المواقع...', 'ar', 1, NOW(), NOW()),

-- تنظیمات منو
('show_language_switcher', '1', 'ar', 1, NOW(), NOW()),
('show_user_menu', '1', 'ar', 1, NOW(), NOW()),

-- تنظیمات ظاهری
('header_style', 'default', 'ar', 1, NOW(), NOW()),
('sticky_header', '1', 'ar', 1, NOW(), NOW()),
('show_breadcrumb', '1', 'ar', 1, NOW(), NOW()),

-- متن‌های دکمه‌ها
('login_text', 'تسجيل الدخول', 'ar', 1, NOW(), NOW()),
('logout_text', 'تسجيل الخروج', 'ar', 1, NOW(), NOW()),
('add_location_text', 'إضافة موقع جديد', 'ar', 1, NOW(), NOW()),
('add_location_url', '/user/locations/create', 'ar', 1, NOW(), NOW()),
('show_add_location_button', '1', 'ar', 1, NOW(), NOW());

-- 6. دکمه‌های کاربری - زبان فارسی
SELECT '=== دکمه‌های کاربری فارسی ===' as fa_buttons;

INSERT INTO button_settings (
    button_key, button_text, button_url, button_icon, button_class, 
    is_visible, show_for_guests, show_for_users, sort_order, language_code, 
    created_at, updated_at
) VALUES
-- دکمه‌های مهمان
('login', 'ورود', '/login', 'fas fa-sign-in-alt', 'btn-auth', 1, 1, 0, 1, 'fa', NOW(), NOW()),
('register', 'ثبت نام', '/register', 'fas fa-user-plus', 'btn-auth', 1, 1, 0, 2, 'fa', NOW(), NOW()),

-- دکمه‌های کاربر وارد شده
('dashboard', 'داشبورد', '/user/dashboard', 'fas fa-tachometer-alt', 'dropdown-item', 1, 0, 1, 1, 'fa', NOW(), NOW()),
('profile', 'پروفایل کاربری', '/user/profile', 'fas fa-user-edit', 'dropdown-item', 1, 0, 1, 2, 'fa', NOW(), NOW()),
('my_locations', 'مکان‌های من', '/user/locations', 'fas fa-map-marker-alt', 'dropdown-item', 1, 0, 1, 3, 'fa', NOW(), NOW()),
('favorites', 'علاقه‌مندی‌ها', '/user/favorites', 'fas fa-heart', 'dropdown-item', 1, 0, 1, 4, 'fa', NOW(), NOW()),
('settings', 'تنظیمات', '/user/settings', 'fas fa-cog', 'dropdown-item', 1, 0, 1, 5, 'fa', NOW(), NOW()),
('logout', 'خروج', '/user/logout', 'fas fa-sign-out-alt', 'dropdown-item', 1, 0, 1, 6, 'fa', NOW(), NOW()),

-- دکمه مشترک
('add_location', 'ثبت مکان جدید', '/user/locations/create', 'fas fa-plus-circle', 'btn-add-place', 1, 1, 1, 10, 'fa', NOW(), NOW());

-- 7. دکمه‌های کاربری - زبان انگلیسی
SELECT '=== دکمه‌های کاربری انگلیسی ===' as en_buttons;

INSERT INTO button_settings (
    button_key, button_text, button_url, button_icon, button_class, 
    is_visible, show_for_guests, show_for_users, sort_order, language_code, 
    created_at, updated_at
) VALUES
-- دکمه‌های مهمان
('login', 'Login', '/login', 'fas fa-sign-in-alt', 'btn-auth', 1, 1, 0, 1, 'en', NOW(), NOW()),
('register', 'Register', '/register', 'fas fa-user-plus', 'btn-auth', 1, 1, 0, 2, 'en', NOW(), NOW()),

-- دکمه‌های کاربر وارد شده
('dashboard', 'Dashboard', '/user/dashboard', 'fas fa-tachometer-alt', 'dropdown-item', 1, 0, 1, 1, 'en', NOW(), NOW()),
('profile', 'User Profile', '/user/profile', 'fas fa-user-edit', 'dropdown-item', 1, 0, 1, 2, 'en', NOW(), NOW()),
('my_locations', 'My Locations', '/user/locations', 'fas fa-map-marker-alt', 'dropdown-item', 1, 0, 1, 3, 'en', NOW(), NOW()),
('favorites', 'Favorites', '/user/favorites', 'fas fa-heart', 'dropdown-item', 1, 0, 1, 4, 'en', NOW(), NOW()),
('settings', 'Settings', '/user/settings', 'fas fa-cog', 'dropdown-item', 1, 0, 1, 5, 'en', NOW(), NOW()),
('logout', 'Logout', '/user/logout', 'fas fa-sign-out-alt', 'dropdown-item', 1, 0, 1, 6, 'en', NOW(), NOW()),

-- دکمه مشترک
('add_location', 'Add New Location', '/user/locations/create', 'fas fa-plus-circle', 'btn-add-place', 1, 1, 1, 10, 'en', NOW(), NOW());

-- 8. دکمه‌های کاربری - زبان عربی
SELECT '=== دکمه‌های کاربری عربی ===' as ar_buttons;

INSERT INTO button_settings (
    button_key, button_text, button_url, button_icon, button_class, 
    is_visible, show_for_guests, show_for_users, sort_order, language_code, 
    created_at, updated_at
) VALUES
-- دکمه‌های مهمان
('login', 'تسجيل الدخول', '/login', 'fas fa-sign-in-alt', 'btn-auth', 1, 1, 0, 1, 'ar', NOW(), NOW()),
('register', 'إنشاء حساب', '/register', 'fas fa-user-plus', 'btn-auth', 1, 1, 0, 2, 'ar', NOW(), NOW()),

-- دکمه‌های کاربر وارد شده
('dashboard', 'لوحة التحكم', '/user/dashboard', 'fas fa-tachometer-alt', 'dropdown-item', 1, 0, 1, 1, 'ar', NOW(), NOW()),
('profile', 'الملف الشخصي', '/user/profile', 'fas fa-user-edit', 'dropdown-item', 1, 0, 1, 2, 'ar', NOW(), NOW()),
('my_locations', 'مواقعي', '/user/locations', 'fas fa-map-marker-alt', 'dropdown-item', 1, 0, 1, 3, 'ar', NOW(), NOW()),
('favorites', 'المفضلة', '/user/favorites', 'fas fa-heart', 'dropdown-item', 1, 0, 1, 4, 'ar', NOW(), NOW()),
('settings', 'الإعدادات', '/user/settings', 'fas fa-cog', 'dropdown-item', 1, 0, 1, 5, 'ar', NOW(), NOW()),
('logout', 'تسجيل الخروج', '/user/logout', 'fas fa-sign-out-alt', 'dropdown-item', 1, 0, 1, 6, 'ar', NOW(), NOW()),

-- دکمه مشترک
('add_location', 'إضافة موقع جديد', '/user/locations/create', 'fas fa-plus-circle', 'btn-add-place', 1, 1, 1, 10, 'ar', NOW(), NOW());

-- 9. بررسی نتایج نهایی
SELECT '=== نتایج نهایی ===' as final_results;

-- آمار کلی
SELECT 'آمار کلی:' as type;
SELECT
    language_code,
    (SELECT COUNT(*) FROM header_settings h WHERE h.language_code = l.language_code) as header_settings_count,
    (SELECT COUNT(*) FROM button_settings b WHERE b.language_code = l.language_code) as button_settings_count
FROM (
    SELECT 'fa' as language_code
    UNION SELECT 'en' as language_code
    UNION SELECT 'ar' as language_code
) l
ORDER BY language_code;

-- تنظیمات هدر به تفکیک زبان
SELECT 'تنظیمات هدر فارسی:' as type;
SELECT setting_key, setting_value
FROM header_settings
WHERE language_code = 'fa' AND is_active = 1
ORDER BY setting_key;

SELECT 'تنظیمات هدر انگلیسی:' as type;
SELECT setting_key, setting_value
FROM header_settings
WHERE language_code = 'en' AND is_active = 1
ORDER BY setting_key;

SELECT 'تنظیمات هدر عربی:' as type;
SELECT setting_key, setting_value
FROM header_settings
WHERE language_code = 'ar' AND is_active = 1
ORDER BY setting_key;

-- دکمه‌های کاربری به تفکیک زبان
SELECT 'دکمه‌های فارسی:' as type;
SELECT button_key, button_text, show_for_guests, show_for_users
FROM button_settings
WHERE language_code = 'fa' AND is_visible = 1
ORDER BY sort_order;

SELECT 'دکمه‌های انگلیسی:' as type;
SELECT button_key, button_text, show_for_guests, show_for_users
FROM button_settings
WHERE language_code = 'en' AND is_visible = 1
ORDER BY sort_order;

SELECT 'دکمه‌های عربی:' as type;
SELECT button_key, button_text, show_for_guests, show_for_users
FROM button_settings
WHERE language_code = 'ar' AND is_visible = 1
ORDER BY sort_order;

-- 10. تأیید نهایی
SELECT '=== تأیید نهایی ===' as confirmation;

SELECT
    CASE
        WHEN (SELECT COUNT(DISTINCT language_code) FROM header_settings WHERE language_code IN ('fa', 'en', 'ar')) = 3
        AND (SELECT COUNT(DISTINCT language_code) FROM button_settings WHERE language_code IN ('fa', 'en', 'ar')) = 3
        AND (SELECT COUNT(*) FROM header_settings WHERE language_code IN ('fa', 'en', 'ar')) >= 39  -- 13 settings × 3 languages
        AND (SELECT COUNT(*) FROM button_settings WHERE language_code IN ('fa', 'en', 'ar')) >= 27   -- 9 buttons × 3 languages
        THEN '✅ داده‌های چندزبانه با موفقیت ایجاد شدند!'
        ELSE '❌ خطا در ایجاد داده‌ها - لطفاً مجدداً بررسی کنید'
    END as final_status;

-- 11. راهنمای بعدی
SELECT '=== راهنمای بعدی ===' as next_steps;

SELECT 'مراحل بعدی:
1. پاک کردن کش: php artisan cache:clear
2. تست تغییر زبان در سایت
3. بررسی نمایش صحیح متن‌ها در هر زبان
4. تست عملکرد دکمه‌ها در زبان‌های مختلف
5. بررسی RTL برای فارسی و عربی
6. تست LTR برای انگلیسی' as instructions;

SELECT '✅ آماده‌سازی چندزبانه کامل شد!' as final_message;
