<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-Frame-Options" content="SAMEORIGIN">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    <meta http-equiv="Referrer-Policy" content="strict-origin-when-cross-origin">
    <title>ثبت نام در مکان‌های ایران - عضویت رایگان</title>
    <meta name="description" content="ثبت نام رایگان در سیستم مکان‌های ایران - کشف، امتیازدهی و اشتراک‌گذاری مکان‌های جذاب">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="{{ asset('css/fonts.css') }}">

    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --warning-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
            --glass-bg: rgba(255, 255, 255, 0.25);
            --glass-border: rgba(255, 255, 255, 0.18);
            --shadow-light: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
            --shadow-heavy: 0 15px 35px rgba(0, 0, 0, 0.1);
            --border-radius: 16px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IRANSans', 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }

        /* Animated Background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><defs><radialGradient id="a" cx="50%" cy="50%"><stop offset="0%" stop-color="%23ffffff" stop-opacity="0.1"/><stop offset="100%" stop-color="%23ffffff" stop-opacity="0"/></radialGradient></defs><circle cx="150" cy="250" r="120" fill="url(%23a)"/><circle cx="850" cy="150" r="100" fill="url(%23a)"/><circle cx="250" cy="750" r="90" fill="url(%23a)"/><circle cx="750" cy="650" r="110" fill="url(%23a)"/></svg>') no-repeat center center;
            background-size: cover;
            animation: float 35s ease-in-out infinite;
            pointer-events: none;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-25px) rotate(180deg); }
        }

        .main-container {
            display: grid;
            grid-template-columns: 1fr 550px;
            gap: 3rem;
            width: 100%;
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
            align-items: start;
            min-height: 100vh;
        }

        /* Benefits Dashboard */
        .benefits-dashboard {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2.5rem;
            box-shadow: var(--shadow-light);
            animation: slideInLeft 0.8s ease-out;
            height: fit-content;
            position: sticky;
            top: 2rem;
        }

        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .benefits-header {
            text-align: center;
            margin-bottom: 2.5rem;
            color: white;
        }

        .benefits-header h2 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.75rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .benefits-header p {
            opacity: 0.9;
            font-size: 1.1rem;
            line-height: 1.6;
        }

        /* User Benefits */
        .user-benefits {
            margin-bottom: 2rem;
        }

        .benefit-item {
            display: flex;
            align-items: flex-start;
            gap: 1rem;
            padding: 1.5rem;
            margin-bottom: 1rem;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            cursor: pointer;
        }

        .benefit-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .benefit-item:hover::before {
            left: 100%;
        }

        .benefit-item:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }

        .benefit-icon {
            font-size: 2rem;
            color: #4ade80;
            margin-top: 0.25rem;
        }

        .benefit-content h4 {
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .benefit-content p {
            color: rgba(255, 255, 255, 0.8);
            font-size: 0.9rem;
            line-height: 1.5;
            margin: 0;
        }

        /* Registration Progress */
        .registration-progress {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }

        .registration-progress h4 {
            color: white;
            font-size: 1.2rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .progress-steps {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }

        .progress-step {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.75rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            transition: var(--transition);
        }

        .progress-step.active {
            background: rgba(102, 126, 234, 0.3);
            border: 1px solid rgba(102, 126, 234, 0.5);
        }

        .step-number {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .progress-step.active .step-number {
            background: var(--primary-gradient);
        }

        .step-content h5 {
            color: white;
            font-size: 0.95rem;
            margin-bottom: 0.25rem;
        }

        .step-content p {
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.8rem;
            margin: 0;
        }

        /* Community Highlights */
        .community-highlights {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1.5rem;
        }

        .community-highlights h4 {
            color: white;
            font-size: 1.2rem;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .highlights-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }

        .highlight-item {
            text-align: center;
            padding: 1rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            transition: var(--transition);
        }

        .highlight-item:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
        }

        .highlight-icon {
            font-size: 1.5rem;
            color: #fbbf24;
            margin-bottom: 0.5rem;
        }

        .highlight-value {
            font-size: 1.3rem;
            font-weight: 700;
            color: white;
            margin-bottom: 0.25rem;
        }

        .highlight-label {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.8);
        }

        /* Register Form Container */
        .register-form-container {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2.5rem;
            box-shadow: var(--shadow-light);
            animation: slideInRight 0.8s ease-out;
            height: fit-content;
        }

        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .form-header {
            text-align: center;
            margin-bottom: 2rem;
            color: white;
        }

        .form-header h2 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .form-header p {
            opacity: 0.9;
            font-size: 1rem;
            line-height: 1.5;
        }

        /* Modern Form Styles */
        .modern-form {
            margin-bottom: 1.5rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: white;
            font-weight: 600;
            margin-bottom: 0.75rem;
            font-size: 0.95rem;
        }

        .required {
            color: #ef4444;
        }

        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 12px;
            padding: 1rem 3rem 1rem 1.25rem;
            font-size: 1rem;
            color: #333;
            transition: var(--transition);
            width: 100%;
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.95);
            border-color: rgba(102, 126, 234, 0.5);
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
            transform: scale(1.02);
        }

        .form-control::placeholder {
            color: rgba(0, 0, 0, 0.5);
        }

        .form-control.is-invalid {
            border-color: #ef4444;
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
        }

        .form-control.is-valid {
            border-color: #4ade80;
            box-shadow: 0 0 0 3px rgba(74, 222, 128, 0.1);
        }

        .password-toggle {
            position: absolute;
            left: 1rem;
            background: none;
            border: none;
            color: #6b7280;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 6px;
            transition: var(--transition);
        }

        .password-toggle:hover {
            color: #374151;
            background: rgba(0, 0, 0, 0.05);
            transform: scale(1.1);
        }

        /* Field Validation */
        .field-validation {
            margin-top: 0.5rem;
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .field-validation.valid {
            color: #4ade80;
        }

        .field-validation.invalid {
            color: #ef4444;
        }

        .field-validation.info {
            color: rgba(255, 255, 255, 0.7);
        }

        /* Username Availability */
        .username-check {
            margin-top: 0.5rem;
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .username-check.available {
            color: #4ade80;
        }

        .username-check.unavailable {
            color: #ef4444;
        }

        .username-check.checking {
            color: #fbbf24;
        }

        /* Password Strength Indicator */
        .password-strength {
            margin-top: 0.75rem;
        }

        .strength-bar {
            width: 100%;
            height: 6px;
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
            overflow: hidden;
            margin-bottom: 0.5rem;
        }

        .strength-fill {
            height: 100%;
            width: 0%;
            transition: all 0.3s ease;
            border-radius: 3px;
        }

        .strength-text {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.85rem;
            text-align: center;
        }

        /* Password Requirements */
        .password-requirements {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0.5rem;
            margin-top: 0.75rem;
        }

        .requirement {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.8rem;
            transition: var(--transition);
        }

        .requirement.valid {
            color: #4ade80;
        }

        .requirement.valid i {
            color: #4ade80;
        }

        .requirement i {
            color: #ef4444;
            font-size: 0.7rem;
        }

        /* Password Match Indicator */
        .password-match {
            margin-top: 0.5rem;
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .password-match.match {
            color: #4ade80;
        }

        .password-match.no-match {
            color: #ef4444;
        }

        /* Error Messages */
        .error-message {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: #ef4444;
            font-size: 0.85rem;
            margin-top: 0.5rem;
            background: rgba(239, 68, 68, 0.1);
            padding: 0.5rem 0.75rem;
            border-radius: 6px;
            border: 1px solid rgba(239, 68, 68, 0.2);
        }

        /* Alert Styles */
        .alert {
            border-radius: 12px;
            border: none;
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
            display: flex;
            align-items: center;
            gap: 0.75rem;
            animation: slideInDown 0.5s ease-out;
        }

        @keyframes slideInDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .alert-success {
            background: rgba(76, 175, 80, 0.2);
            color: #e8f5e8;
            border: 1px solid rgba(76, 175, 80, 0.3);
        }

        .alert-danger {
            background: rgba(244, 67, 54, 0.2);
            color: #ffebee;
            border: 1px solid rgba(244, 67, 54, 0.3);
        }

        /* Form Actions */
        .form-actions {
            margin-bottom: 1.5rem;
        }

        .btn {
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            font-size: 1rem;
            border: none;
            cursor: pointer;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            text-decoration: none;
            width: 100%;
        }

        .btn-primary {
            background: var(--primary-gradient);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
            color: white;
        }

        .btn-primary:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.2);
        }

        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.6s;
        }

        .btn-primary:hover::before {
            left: 100%;
        }

        .btn-loading {
            display: none;
        }

        .btn.loading .btn-text {
            display: none;
        }

        .btn.loading .btn-loading {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        /* Login Link */
        .login-link {
            text-align: center;
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.95rem;
        }

        .login-link a {
            color: #4ade80;
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
        }

        .login-link a:hover {
            color: #22c55e;
            text-shadow: 0 0 8px rgba(74, 222, 128, 0.5);
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .main-container {
                grid-template-columns: 1fr;
                gap: 2rem;
            }

            .benefits-dashboard {
                order: 2;
                position: static;
            }

            .register-form-container {
                order: 1;
                max-width: 600px;
                margin: 0 auto;
            }
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }

            .benefits-dashboard,
            .register-form-container {
                padding: 1.5rem;
            }

            .highlights-grid {
                grid-template-columns: 1fr;
                gap: 0.75rem;
            }

            .password-requirements {
                grid-template-columns: 1fr;
            }

            .benefits-header h2,
            .form-header h2 {
                font-size: 1.5rem;
            }
        }

        @media (max-width: 480px) {
            .main-container {
                padding: 0.5rem;
            }

            .benefits-dashboard,
            .register-form-container {
                padding: 1rem;
            }

            .btn {
                padding: 0.875rem 1.5rem;
                font-size: 0.9rem;
            }
        }

        /* Enhanced Accessibility */
        @media (prefers-reduced-motion: reduce) {
            * {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }

        /* Enhanced Focus Management */
        .focus-visible {
            outline: 3px solid #667eea;
            outline-offset: 2px;
            border-radius: 4px;
        }

        /* Developer Credit Styles */
        .developer-credit {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 12px;
            padding: 0.75rem 1rem;
            color: white;
            font-size: 0.85rem;
            font-weight: 500;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: var(--transition);
            cursor: pointer;
            z-index: 1000;
        }

        .developer-credit:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
        }

        .developer-credit .dev-icon {
            color: #4facfe;
            margin-left: 0.5rem;
            font-size: 1rem;
        }

        .developer-credit .dev-name {
            font-weight: 600;
            color: #ffffff;
        }

        .developer-credit .dev-role {
            font-size: 0.75rem;
            opacity: 0.8;
            margin-top: 0.25rem;
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Benefits Dashboard -->
        <div class="benefits-dashboard">
            <div class="benefits-header">
                <h2><i class="fas fa-gift"></i> مزایای عضویت</h2>
                <p>با عضویت در پلتفرم ما از امکانات ویژه بهره‌مند شوید</p>
            </div>

            <!-- User Benefits -->
            <div class="user-benefits">
                @if(!empty($stats['user_benefits']))
                    @foreach($stats['user_benefits'] as $benefit)
                    <div class="benefit-item">
                        <i class="{{ $benefit['icon'] }} benefit-icon"></i>
                        <div class="benefit-content">
                            <h4>{{ $benefit['title'] }}</h4>
                            <p>{{ $benefit['description'] }}</p>
                        </div>
                    </div>
                    @endforeach
                @endif
            </div>

            <!-- Registration Progress -->
            @if(!empty($stats['registration_progress']))
            <div class="registration-progress">
                <h4>
                    <i class="fas fa-list-ol"></i>
                    مراحل ثبت نام
                </h4>
                <div class="progress-steps">
                    @foreach($stats['registration_progress'] as $index => $step)
                    <div class="progress-step {{ $index === 0 ? 'active' : '' }}">
                        <div class="step-number">{{ $step['step'] }}</div>
                        <div class="step-content">
                            <h5>{{ $step['title'] }}</h5>
                            <p>{{ $step['description'] }}</p>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Community Highlights -->
            @if(!empty($stats['community_highlights']))
            <div class="community-highlights">
                <h4>
                    <i class="fas fa-users"></i>
                    فعالیت جامعه
                </h4>
                <div class="highlights-grid">
                    @foreach($stats['community_highlights'] as $highlight)
                    <div class="highlight-item">
                        <i class="{{ $highlight['icon'] }} highlight-icon"></i>
                        <div class="highlight-value">{{ $highlight['value'] }}</div>
                        <div class="highlight-label">{{ $highlight['metric'] }}</div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>

        <!-- Register Form -->
        <div class="register-form-container">
            <div class="form-header">
                <h2><i class="fas fa-user-plus"></i> ثبت نام رایگان</h2>
                <p>حساب کاربری خود را ایجاد کنید و به جامعه ما بپیوندید</p>
            </div>

            @if($errors->any())
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i>
                    <ul style="margin: 0; padding-right: 1rem;">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('user.register') }}" method="POST" id="register-form" class="modern-form">
                @csrf

                <!-- Full Name Field -->
                <div class="form-group">
                    <label for="full_name" class="form-label">
                        <i class="fas fa-user"></i>
                        نام و نام خانوادگی
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="text"
                               name="full_name"
                               id="full_name"
                               class="form-control @error('full_name') is-invalid @enderror"
                               value="{{ old('full_name') }}"
                               required
                               autofocus
                               autocomplete="name"
                               placeholder="نام و نام خانوادگی خود را وارد کنید">
                    </div>
                    <div class="field-validation info" id="fullname-validation">
                        <i class="fas fa-info-circle"></i>
                        نام واقعی خود را وارد کنید
                    </div>
                    @error('full_name')
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <!-- Username Field -->
                <div class="form-group">
                    <label for="username" class="form-label">
                        <i class="fas fa-user-tag"></i>
                        نام کاربری
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="text"
                               name="username"
                               id="username"
                               class="form-control @error('username') is-invalid @enderror"
                               value="{{ old('username') }}"
                               required
                               autocomplete="username"
                               placeholder="نام کاربری منحصر به فرد انتخاب کنید">
                    </div>
                    <div class="username-check" id="username-check"></div>
                    <div class="field-validation info" id="username-validation">
                        <i class="fas fa-info-circle"></i>
                        فقط حروف انگلیسی، اعداد، - و _ مجاز است
                    </div>
                    @error('username')
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <!-- Email Field -->
                <div class="form-group">
                    <label for="email" class="form-label">
                        <i class="fas fa-envelope"></i>
                        ایمیل
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="email"
                               name="email"
                               id="email"
                               class="form-control @error('email') is-invalid @enderror"
                               value="{{ old('email') }}"
                               required
                               autocomplete="email"
                               placeholder="ایمیل معتبر خود را وارد کنید">
                    </div>
                    <div class="field-validation info" id="email-validation">
                        <i class="fas fa-info-circle"></i>
                        برای تایید حساب کاربری استفاده می‌شود
                    </div>
                    @error('email')
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <!-- Password Field -->
                <div class="form-group">
                    <label for="password" class="form-label">
                        <i class="fas fa-lock"></i>
                        رمز عبور
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="password"
                               name="password"
                               id="password"
                               class="form-control @error('password') is-invalid @enderror"
                               required
                               autocomplete="new-password"
                               placeholder="رمز عبور قوی انتخاب کنید"
                               minlength="8">
                        <button type="button" class="password-toggle" data-target="password">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                    <div class="password-strength">
                        <div class="strength-bar">
                            <div class="strength-fill" id="strength-fill"></div>
                        </div>
                        <div class="strength-text" id="strength-text">قدرت رمز عبور</div>
                    </div>
                    <div class="password-requirements">
                        <div class="requirement" id="req-length">
                            <i class="fas fa-times"></i>
                            حداقل 8 کاراکتر
                        </div>
                        <div class="requirement" id="req-uppercase">
                            <i class="fas fa-times"></i>
                            حروف بزرگ انگلیسی
                        </div>
                        <div class="requirement" id="req-lowercase">
                            <i class="fas fa-times"></i>
                            حروف کوچک انگلیسی
                        </div>
                        <div class="requirement" id="req-number">
                            <i class="fas fa-times"></i>
                            اعداد
                        </div>
                    </div>
                    @error('password')
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <!-- Confirm Password Field -->
                <div class="form-group">
                    <label for="password_confirmation" class="form-label">
                        <i class="fas fa-check-double"></i>
                        تکرار رمز عبور
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="password"
                               name="password_confirmation"
                               id="password_confirmation"
                               class="form-control"
                               required
                               autocomplete="new-password"
                               placeholder="رمز عبور را مجدداً وارد کنید">
                        <button type="button" class="password-toggle" data-target="password_confirmation">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                    <div class="password-match" id="password-match"></div>
                </div>

                <!-- Submit Button -->
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary" id="register-btn" disabled>
                        <span class="btn-text">
                            <i class="fas fa-user-plus"></i>
                            ثبت نام رایگان
                        </span>
                        <div class="btn-loading">
                            <i class="fas fa-spinner fa-spin"></i>
                            در حال ثبت نام...
                        </div>
                    </button>
                </div>
            </form>

            <!-- Login Link -->
            <div class="login-link">
                قبلاً ثبت نام کرده‌اید؟
                <a href="{{ route('user.login') }}">وارد شوید</a>
            </div>
        </div>
    </div>

    <!-- Developer Credit -->
    <div class="developer-credit" onclick="showDeveloperInfo()">
        <div class="d-flex align-items-center">
            <i class="fas fa-palette dev-icon"></i>
            <div>
                <div class="dev-name">یوسف رجستری</div>
                <div class="dev-role">UI/UX Designer & Developer</div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        class ModernUserRegister {
            constructor() {
                this.init();
                this.setupEventListeners();
                this.animatePageLoad();
                this.startProgressAnimation();
            }

            init() {
                this.form = document.getElementById('register-form');
                this.submitBtn = document.getElementById('register-btn');
                this.fullNameInput = document.getElementById('full_name');
                this.usernameInput = document.getElementById('username');
                this.emailInput = document.getElementById('email');
                this.passwordInput = document.getElementById('password');
                this.confirmPasswordInput = document.getElementById('password_confirmation');

                // UI elements
                this.strengthFill = document.getElementById('strength-fill');
                this.strengthText = document.getElementById('strength-text');
                this.passwordMatch = document.getElementById('password-match');
                this.usernameCheck = document.getElementById('username-check');

                // Requirements
                this.requirements = {
                    length: document.getElementById('req-length'),
                    uppercase: document.getElementById('req-uppercase'),
                    lowercase: document.getElementById('req-lowercase'),
                    number: document.getElementById('req-number')
                };

                // State
                this.passwordStrength = 0;
                this.isFormValid = false;
                this.usernameAvailable = false;
                this.usernameCheckTimeout = null;

                // Validation state
                this.validationState = {
                    fullName: false,
                    username: false,
                    email: false,
                    password: false,
                    passwordConfirm: false
                };
            }

            setupEventListeners() {
                // Password toggle functionality
                document.querySelectorAll('.password-toggle').forEach(toggle => {
                    toggle.addEventListener('click', (e) => this.togglePassword(e));
                });

                // Form field validations
                if (this.fullNameInput) {
                    this.fullNameInput.addEventListener('input', () => this.validateFullName());
                    this.fullNameInput.addEventListener('blur', () => this.validateFullName());
                }

                if (this.usernameInput) {
                    this.usernameInput.addEventListener('input', () => this.validateUsername());
                    this.usernameInput.addEventListener('blur', () => this.checkUsernameAvailability());
                }

                if (this.emailInput) {
                    this.emailInput.addEventListener('input', () => this.validateEmail());
                    this.emailInput.addEventListener('blur', () => this.validateEmail());
                }

                if (this.passwordInput) {
                    this.passwordInput.addEventListener('input', (e) => {
                        this.checkPasswordStrength(e.target.value);
                        this.checkPasswordMatch();
                        this.validateForm();
                    });
                }

                if (this.confirmPasswordInput) {
                    this.confirmPasswordInput.addEventListener('input', () => {
                        this.checkPasswordMatch();
                        this.validateForm();
                    });
                }

                // Form submission
                if (this.form) {
                    this.form.addEventListener('submit', (e) => this.handleSubmit(e));
                }

                // Enhanced input interactions
                document.querySelectorAll('.form-control').forEach(input => {
                    input.addEventListener('focus', (e) => this.handleInputFocus(e));
                    input.addEventListener('blur', (e) => this.handleInputBlur(e));
                    input.addEventListener('keydown', (e) => this.handleKeyDown(e));
                });

                // Benefit items interactions
                document.querySelectorAll('.benefit-item').forEach(item => {
                    item.addEventListener('click', (e) => this.handleBenefitClick(e));
                });

                // Progress step interactions
                document.querySelectorAll('.progress-step').forEach(step => {
                    step.addEventListener('click', (e) => this.handleProgressStepClick(e));
                });
            }

            togglePassword(e) {
                const button = e.currentTarget;
                const targetId = button.getAttribute('data-target');
                const input = document.getElementById(targetId);
                const icon = button.querySelector('i');

                if (input.type === 'password') {
                    input.type = 'text';
                    icon.className = 'fas fa-eye-slash';
                    button.setAttribute('aria-label', 'مخفی کردن رمز عبور');
                } else {
                    input.type = 'password';
                    icon.className = 'fas fa-eye';
                    button.setAttribute('aria-label', 'نمایش رمز عبور');
                }

                // Enhanced animation
                button.style.transform = 'scale(0.9) rotate(180deg)';
                setTimeout(() => {
                    button.style.transform = 'scale(1) rotate(0deg)';
                }, 200);
            }

            validateFullName() {
                const fullName = this.fullNameInput.value.trim();
                const validation = document.getElementById('fullname-validation');

                if (fullName.length < 2) {
                    this.setFieldValidation('fullName', false, validation, 'نام باید حداقل 2 کاراکتر باشد', 'invalid');
                    return false;
                } else if (fullName.length > 50) {
                    this.setFieldValidation('fullName', false, validation, 'نام نباید بیش از 50 کاراکتر باشد', 'invalid');
                    return false;
                } else if (!/^[\u0600-\u06FF\s]+$/.test(fullName)) {
                    this.setFieldValidation('fullName', false, validation, 'فقط حروف فارسی مجاز است', 'invalid');
                    return false;
                } else {
                    this.setFieldValidation('fullName', true, validation, 'نام معتبر است', 'valid');
                    return true;
                }
            }

            validateUsername() {
                const username = this.usernameInput.value.trim();
                const validation = document.getElementById('username-validation');

                if (username.length < 3) {
                    this.setFieldValidation('username', false, validation, 'نام کاربری باید حداقل 3 کاراکتر باشد', 'invalid');
                    return false;
                } else if (username.length > 20) {
                    this.setFieldValidation('username', false, validation, 'نام کاربری نباید بیش از 20 کاراکتر باشد', 'invalid');
                    return false;
                } else if (!/^[a-zA-Z0-9_-]+$/.test(username)) {
                    this.setFieldValidation('username', false, validation, 'فقط حروف انگلیسی، اعداد، - و _ مجاز است', 'invalid');
                    return false;
                } else {
                    this.setFieldValidation('username', true, validation, 'فرمت نام کاربری صحیح است', 'valid');
                    this.scheduleUsernameCheck();
                    return true;
                }
            }

            scheduleUsernameCheck() {
                if (this.usernameCheckTimeout) {
                    clearTimeout(this.usernameCheckTimeout);
                }

                this.usernameCheckTimeout = setTimeout(() => {
                    this.checkUsernameAvailability();
                }, 500);
            }

            checkUsernameAvailability() {
                const username = this.usernameInput.value.trim();

                if (username.length < 3) return;

                this.usernameCheck.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال بررسی...';
                this.usernameCheck.className = 'username-check checking';

                // Simulate API call (replace with actual API endpoint)
                setTimeout(() => {
                    // Simulate some usernames as taken
                    const takenUsernames = ['admin', 'user', 'test', 'demo'];
                    const isAvailable = !takenUsernames.includes(username.toLowerCase());

                    if (isAvailable) {
                        this.usernameCheck.innerHTML = '<i class="fas fa-check"></i> نام کاربری در دسترس است';
                        this.usernameCheck.className = 'username-check available';
                        this.usernameAvailable = true;
                    } else {
                        this.usernameCheck.innerHTML = '<i class="fas fa-times"></i> نام کاربری قبلاً انتخاب شده';
                        this.usernameCheck.className = 'username-check unavailable';
                        this.usernameAvailable = false;
                    }

                    this.validateForm();
                }, 1000);
            }

            validateEmail() {
                const email = this.emailInput.value.trim();
                const validation = document.getElementById('email-validation');
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

                if (!email) {
                    this.setFieldValidation('email', false, validation, 'ایمیل الزامی است', 'invalid');
                    return false;
                } else if (!emailRegex.test(email)) {
                    this.setFieldValidation('email', false, validation, 'فرمت ایمیل صحیح نیست', 'invalid');
                    return false;
                } else {
                    this.setFieldValidation('email', true, validation, 'ایمیل معتبر است', 'valid');
                    return true;
                }
            }

            checkPasswordStrength(password) {
                let score = 0;
                const checks = {
                    length: password.length >= 8,
                    uppercase: /[A-Z]/.test(password),
                    lowercase: /[a-z]/.test(password),
                    number: /[0-9]/.test(password)
                };

                // Advanced scoring
                if (password.length >= 12) score += 10;
                if (/[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/.test(password)) score += 15;

                // Update requirement indicators
                Object.keys(checks).forEach(key => {
                    const element = this.requirements[key];
                    const icon = element.querySelector('i');

                    if (checks[key]) {
                        element.classList.add('valid');
                        icon.className = 'fas fa-check';
                        score += 20;
                    } else {
                        element.classList.remove('valid');
                        icon.className = 'fas fa-times';
                    }
                });

                this.passwordStrength = Math.min(score, 100);
                this.updateStrengthBar(this.passwordStrength);

                this.validationState.password = this.passwordStrength >= 60;
                this.updateFieldState(this.passwordInput, this.validationState.password);
            }

            updateStrengthBar(score) {
                const percentage = Math.min(score, 100);
                this.strengthFill.style.width = percentage + '%';

                let color, text;
                if (score < 40) {
                    color = '#ef4444';
                    text = 'ضعیف';
                } else if (score < 70) {
                    color = '#fbbf24';
                    text = 'متوسط';
                } else if (score < 90) {
                    color = '#4ade80';
                    text = 'قوی';
                } else {
                    color = '#10b981';
                    text = 'بسیار قوی';
                }

                this.strengthFill.style.background = color;
                this.strengthText.textContent = `قدرت رمز عبور: ${text}`;
                this.strengthText.style.color = color;

                // Add glow effect
                this.strengthFill.style.boxShadow = `0 0 10px ${color}`;
            }

            checkPasswordMatch() {
                const password = this.passwordInput.value;
                const confirm = this.confirmPasswordInput.value;

                if (confirm === '') {
                    this.passwordMatch.textContent = '';
                    this.passwordMatch.className = 'password-match';
                    this.validationState.passwordConfirm = false;
                    return false;
                }

                if (password === confirm) {
                    this.passwordMatch.innerHTML = '<i class="fas fa-check"></i> رمز عبور مطابقت دارد';
                    this.passwordMatch.className = 'password-match match';
                    this.validationState.passwordConfirm = true;
                    this.updateFieldState(this.confirmPasswordInput, true);
                    return true;
                } else {
                    this.passwordMatch.innerHTML = '<i class="fas fa-times"></i> رمز عبور مطابقت ندارد';
                    this.passwordMatch.className = 'password-match no-match';
                    this.validationState.passwordConfirm = false;
                    this.updateFieldState(this.confirmPasswordInput, false);
                    return false;
                }
            }

            setFieldValidation(field, isValid, element, message, type) {
                this.validationState[field] = isValid;

                if (element) {
                    element.innerHTML = `<i class="fas fa-${type === 'valid' ? 'check' : type === 'invalid' ? 'times' : 'info'}-circle"></i> ${message}`;
                    element.className = `field-validation ${type}`;
                }

                // Update input field state
                const input = this[field + 'Input'];
                if (input) {
                    this.updateFieldState(input, isValid);
                }

                this.validateForm();
            }

            updateFieldState(input, isValid) {
                input.classList.remove('is-valid', 'is-invalid');
                if (isValid) {
                    input.classList.add('is-valid');
                } else {
                    input.classList.add('is-invalid');
                }
            }

            validateForm() {
                const allValid = Object.values(this.validationState).every(valid => valid) &&
                                this.usernameAvailable;

                this.isFormValid = allValid;
                this.submitBtn.disabled = !allValid;

                if (allValid) {
                    this.submitBtn.classList.add('valid');
                } else {
                    this.submitBtn.classList.remove('valid');
                }
            }

            handleInputFocus(e) {
                const wrapper = e.target.closest('.input-wrapper');
                if (wrapper) {
                    wrapper.style.transform = 'scale(1.02)';
                    wrapper.style.transition = 'transform 0.2s ease';
                    wrapper.classList.add('focused');
                }

                e.target.style.boxShadow = '0 0 0 3px rgba(102, 126, 234, 0.2)';
            }

            handleInputBlur(e) {
                const wrapper = e.target.closest('.input-wrapper');
                if (wrapper) {
                    wrapper.style.transform = 'scale(1)';
                    wrapper.classList.remove('focused');
                }

                e.target.style.boxShadow = '';
            }

            handleKeyDown(e) {
                if (e.key === 'Enter') {
                    const inputs = Array.from(document.querySelectorAll('.form-control'));
                    const currentIndex = inputs.indexOf(e.target);
                    const nextInput = inputs[currentIndex + 1];

                    if (nextInput) {
                        e.preventDefault();
                        nextInput.focus();
                    } else if (this.isFormValid) {
                        e.preventDefault();
                        this.submitBtn.click();
                    }
                }
            }

            handleSubmit(e) {
                if (!this.isFormValid) {
                    e.preventDefault();
                    this.showError('لطفاً تمام فیلدها را به درستی پر کنید');
                    return;
                }

                // Add loading state
                this.submitBtn.classList.add('loading');
                this.submitBtn.disabled = true;

                // Add success animation
                this.addSubmitAnimation();

                // Update progress to show completion
                this.updateProgressStep(1);
            }

            handleBenefitClick(e) {
                const benefitItem = e.currentTarget;

                // Add click animation
                benefitItem.style.transform = 'scale(0.95)';
                setTimeout(() => {
                    benefitItem.style.transform = 'scale(1)';
                }, 150);

                // Show benefit details
                const title = benefitItem.querySelector('h4').textContent;
                const description = benefitItem.querySelector('p').textContent;
                this.showNotification(`${title}: ${description}`, 'info');
            }

            handleProgressStepClick(e) {
                const step = e.currentTarget;
                const stepNumber = step.querySelector('.step-number').textContent;
                const stepTitle = step.querySelector('h5').textContent;

                // Add click animation
                step.style.transform = 'scale(0.98)';
                setTimeout(() => {
                    step.style.transform = 'scale(1)';
                }, 150);

                this.showNotification(`مرحله ${stepNumber}: ${stepTitle}`, 'info');
            }

            updateProgressStep(stepIndex) {
                const steps = document.querySelectorAll('.progress-step');
                steps.forEach((step, index) => {
                    if (index <= stepIndex) {
                        step.classList.add('active');
                    } else {
                        step.classList.remove('active');
                    }
                });
            }

            addSubmitAnimation() {
                const ripple = document.createElement('span');
                ripple.style.cssText = `
                    position: absolute;
                    border-radius: 50%;
                    background: rgba(255, 255, 255, 0.6);
                    transform: scale(0);
                    animation: ripple 0.6s linear;
                    pointer-events: none;
                    width: 100px;
                    height: 100px;
                    left: 50%;
                    top: 50%;
                    margin-left: -50px;
                    margin-top: -50px;
                `;

                this.submitBtn.appendChild(ripple);

                setTimeout(() => {
                    ripple.remove();
                }, 600);
            }

            animatePageLoad() {
                // Animate benefit items
                const benefitItems = document.querySelectorAll('.benefit-item');
                benefitItems.forEach((item, index) => {
                    item.style.opacity = '0';
                    item.style.transform = 'translateY(20px)';

                    setTimeout(() => {
                        item.style.transition = 'all 0.6s cubic-bezier(0.4, 0, 0.2, 1)';
                        item.style.opacity = '1';
                        item.style.transform = 'translateY(0)';
                    }, 200 + (index * 100));
                });

                // Animate form elements
                const formGroups = document.querySelectorAll('.form-group');
                formGroups.forEach((group, index) => {
                    group.style.opacity = '0';
                    group.style.transform = 'translateX(20px)';

                    setTimeout(() => {
                        group.style.transition = 'all 0.6s cubic-bezier(0.4, 0, 0.2, 1)';
                        group.style.opacity = '1';
                        group.style.transform = 'translateX(0)';
                    }, 400 + (index * 150));
                });
            }

            startProgressAnimation() {
                // Animate progress steps
                const progressSteps = document.querySelectorAll('.progress-step');
                progressSteps.forEach((step, index) => {
                    step.style.opacity = '0';
                    step.style.transform = 'translateX(-20px)';

                    setTimeout(() => {
                        step.style.transition = 'all 0.5s cubic-bezier(0.4, 0, 0.2, 1)';
                        step.style.opacity = '1';
                        step.style.transform = 'translateX(0)';
                    }, 300 + (index * 200));
                });

                // Animate highlight values
                const highlightValues = document.querySelectorAll('.highlight-value');
                highlightValues.forEach(value => {
                    const finalValue = parseInt(value.textContent);
                    if (finalValue > 0) {
                        this.animateCounter(value, 0, finalValue, 1500);
                    }
                });
            }

            animateCounter(element, start, end, duration) {
                const startTime = performance.now();

                const animate = (currentTime) => {
                    const elapsed = currentTime - startTime;
                    const progress = Math.min(elapsed / duration, 1);

                    const current = Math.floor(start + (end - start) * this.easeOutCubic(progress));
                    element.textContent = current;

                    if (progress < 1) {
                        requestAnimationFrame(animate);
                    }
                };

                requestAnimationFrame(animate);
            }

            easeOutCubic(t) {
                return 1 - Math.pow(1 - t, 3);
            }

            showError(message) {
                this.showNotification(message, 'error');
            }

            showSuccess(message) {
                this.showNotification(message, 'success');
            }

            showNotification(message, type) {
                const notification = document.createElement('div');
                notification.className = `alert alert-${type === 'error' ? 'danger' : type}`;
                notification.innerHTML = `<i class="fas fa-${type === 'success' ? 'check' : type === 'error' ? 'exclamation' : 'info'}-circle"></i> ${message}`;

                const formContainer = document.querySelector('.register-form-container');
                formContainer.insertBefore(notification, formContainer.firstChild);

                setTimeout(() => {
                    notification.remove();
                }, 5000);
            }
        }

        // Initialize when DOM is loaded
        document.addEventListener('DOMContentLoaded', () => {
            new ModernUserRegister();
            console.log('🚀 Modern User Register initialized');
        });

        // Developer info function
        function showDeveloperInfo() {
            const modal = document.createElement('div');
            modal.style.cssText = `
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.8);
                display: flex;
                align-items: center;
                justify-content: center;
                z-index: 10000;
                backdrop-filter: blur(8px);
                animation: fadeIn 0.3s ease;
            `;

            modal.innerHTML = `
                <div style="
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    border-radius: 20px;
                    padding: 2rem;
                    text-align: center;
                    color: white;
                    max-width: 400px;
                    width: 90%;
                    box-shadow: 0 20px 40px rgba(0,0,0,0.3);
                    transform: scale(0.9);
                    animation: modalPop 0.3s ease forwards;
                ">
                    <div style="font-size: 3rem; margin-bottom: 1rem;">🎨</div>
                    <h3 style="margin-bottom: 0.5rem; font-weight: 700;">یوسف رجستری</h3>
                    <p style="margin-bottom: 0.5rem; font-size: 1.1rem; color: #e0e7ff;">Yousof Rajestary</p>
                    <p style="margin-bottom: 1.5rem; opacity: 0.9;">UI/UX Designer & Full-Stack Developer</p>
                    <div style="background: rgba(255,255,255,0.1); border-radius: 12px; padding: 1rem; margin-bottom: 1.5rem;">
                        <p style="margin: 0; font-size: 0.9rem; line-height: 1.6;">
                            این پلتفرم مدیریت مکان‌ها از مفهوم اولیه تا اجرای کامل توسط یوسف رجستری طراحی و پیاده‌سازی شده است.
                            شامل تحقیق کاربری، طراحی تجربه کاربری، توسعه فرانت‌اند و بک‌اند، و تست‌های جامع.
                        </p>
                    </div>
                    <button onclick="this.closest('div').parentElement.remove()" style="
                        background: rgba(255,255,255,0.2);
                        border: 1px solid rgba(255,255,255,0.3);
                        border-radius: 8px;
                        color: white;
                        padding: 0.5rem 1.5rem;
                        cursor: pointer;
                        transition: all 0.3s ease;
                    " onmouseover="this.style.background='rgba(255,255,255,0.3)'" onmouseout="this.style.background='rgba(255,255,255,0.2)'">
                        بستن
                    </button>
                </div>
            `;

            modal.onclick = (e) => {
                if (e.target === modal) modal.remove();
            };

            document.body.appendChild(modal);
        }

        // Add CSS animations
        const style = document.createElement('style');
        style.textContent = `
            @keyframes ripple {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }

            @keyframes fadeIn {
                from { opacity: 0; }
                to { opacity: 1; }
            }

            @keyframes modalPop {
                from { transform: scale(0.9); opacity: 0; }
                to { transform: scale(1); opacity: 1; }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html>