@extends('layouts.app')

@section('title', 'تماس با ما')

@section('content')
<div class="container">
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header">
                    <i class="fas fa-envelope me-1"></i>
                    تماس با ما
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-5 mb-4 mb-md-0">
                            <h4 class="mb-4">اطلاعات تماس</h4>
                            
                            <div class="d-flex mb-4">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-map-marker-alt fa-2x text-primary"></i>
                                </div>
                                <div class="ms-3">
                                    <h5>آدرس</h5>
                                    <p>تهران، خیابان آزادی، پلاک 123</p>
                                </div>
                            </div>
                            
                            <div class="d-flex mb-4">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-phone-alt fa-2x text-primary"></i>
                                </div>
                                <div class="ms-3">
                                    <h5>تلفن</h5>
                                    <p>021-12345678</p>
                                </div>
                            </div>
                            
                            <div class="d-flex mb-4">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-envelope fa-2x text-primary"></i>
                                </div>
                                <div class="ms-3">
                                    <h5>ایمیل</h5>
                                    <p>info@example.com</p>
                                </div>
                            </div>
                            
                            <div class="mt-5">
                                <h4 class="mb-3">ما را در شبکه‌های اجتماعی دنبال کنید</h4>
                                <div class="social-icons">
                                    <a href="#" class="me-2 text-decoration-none">
                                        <i class="fab fa-instagram fa-2x text-danger"></i>
                                    </a>
                                    <a href="#" class="me-2 text-decoration-none">
                                        <i class="fab fa-telegram fa-2x text-primary"></i>
                                    </a>
                                    <a href="#" class="me-2 text-decoration-none">
                                        <i class="fab fa-twitter fa-2x text-info"></i>
                                    </a>
                                    <a href="#" class="text-decoration-none">
                                        <i class="fab fa-facebook fa-2x text-primary"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-7">
                            <h4 class="mb-4">فرم تماس</h4>
                            
                            <form id="contact-form" method="POST" action="{{ url('/contact/submit') }}">
                                @csrf
                                
                                @if(session('success'))
                                    <div class="alert alert-success">
                                        {{ session('success') }}
                                    </div>
                                @endif
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="name" class="form-label">نام و نام خانوادگی <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="name" name="name" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="email" class="form-label">ایمیل <span class="text-danger">*</span></label>
                                        <input type="email" class="form-control" id="email" name="email" required>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="phone" class="form-label">تلفن تماس</label>
                                    <input type="tel" class="form-control" id="phone" name="phone">
                                </div>
                                
                                <div class="mb-3">
                                    <label for="subject" class="form-label">موضوع <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="subject" name="subject" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="message" class="form-label">پیام <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
                                </div>
                                
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-paper-plane me-1"></i>
                                        ارسال پیام
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                    
                    <div class="row mt-5">
                        <div class="col-12">
                            <h4 class="mb-3">موقعیت ما روی نقشه</h4>
                            <div id="map" style="height: 400px; width: 100%;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize map
        const map = L.map('map').setView([35.6892, 51.3890], 14); // Tehran
        
        // Add OpenStreetMap tile layer
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);
        
        // Add marker
        L.marker([35.6892, 51.3890]).addTo(map)
            .bindPopup('دفتر مرکزی اَلو ایران')
            .openPopup();
            
        // Form submission
        $('#contact-form').on('submit', function(e) {
            e.preventDefault();
            
            // Show loading or disable button
            $('button[type="submit"]').prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-1"></i> در حال ارسال...');
            
            // Simulate form submission for demo (remove this in production)
            setTimeout(function() {
                // Create success message
                const successMsg = $('<div class="alert alert-success mt-3"></div>').text('پیام شما با موفقیت ارسال شد. با تشکر از تماس شما.');
                
                // Clear form and show success message
                $('#contact-form').trigger('reset').prepend(successMsg);
                
                // Re-enable submit button
                $('button[type="submit"]').prop('disabled', false).html('<i class="fas fa-paper-plane me-1"></i> ارسال پیام');
                
                // Remove success message after 5 seconds
                setTimeout(function() {
                    successMsg.fadeOut('slow', function() {
                        $(this).remove();
                    });
                }, 5000);
            }, 1500);
            
            // In a real application, you would submit the form via AJAX here
            /*
            $.ajax({
                url: $(this).attr('action'),
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    // Handle success
                },
                error: function(xhr) {
                    // Handle error
                },
                complete: function() {
                    // Re-enable button
                    $('button[type="submit"]').prop('disabled', false).html('<i class="fas fa-paper-plane me-1"></i> ارسال پیام');
                }
            });
            */
        });
    });
</script>
@endpush 