@extends('layouts.app')

@section('title', __('ثبت نظر برای') . ' ' . $location->title)

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('خانه') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('locations.show', $location->id) }}">{{ $location->title }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('ثبت نظر جدید') }}</li>
                </ol>
            </nav>

            <h1 class="mb-4">{{ __('ثبت نظر جدید') }}</h1>
            
            <div class="mb-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            @if(!empty($location->images))
                                @php
                                    $images = explode(',', $location->images);
                                    $firstImage = trim($images[0] ?? '');
                                @endphp
                                @if(!empty($firstImage))
                                    <img src="{{ $firstImage }}" alt="{{ $location->title }}" class="rounded me-3" style="width: 80px; height: 80px; object-fit: cover;">
                                @endif
                            @endif
                            <div>
                                <h5 class="card-title mb-1">{{ $location->title }}</h5>
                                @if(!empty($location->category_fa))
                                    <p class="card-text text-muted mb-1">
                                        <i class="fas fa-tag fa-sm me-1"></i> {{ $location->category_fa }}
                                    </p>
                                @endif
                                @if(!empty($location->address))
                                    <p class="card-text small mb-0">
                                        <i class="fas fa-map-marker-alt fa-sm me-1"></i> {{ $location->address }}
                                    </p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <x-rating-form :locationId="$location->id" :locationName="$location->title" />
            
            @if(session('info'))
                <div class="alert alert-info mt-4">
                    {{ session('info') }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection 