<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title') | پنل کاربری</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.css">
    <link rel="stylesheet" href="{{ asset('css/fonts.css') }}">
    <link rel="stylesheet" href="{{ asset('css/custom-map.css') }}">
    <style>
        /* Modern User Panel Styles */
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --warning-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
            --danger-gradient: linear-gradient(135deg, #fa709a 0%, #fee140 100%);

            --sidebar-width: 280px;
            --sidebar-collapsed-width: 80px;
            --header-height: 70px;

            --primary-color: #667eea;
            --secondary-color: #764ba2;
            --accent-color: #f093fb;
            --success-color: #4facfe;
            --warning-color: #43e97b;
            --danger-color: #fa709a;

            --text-primary: #2d3748;
            --text-secondary: #718096;
            --text-muted: #a0aec0;

            --bg-primary: #ffffff;
            --bg-secondary: #f7fafc;
            --bg-tertiary: #edf2f7;

            --border-color: #e2e8f0;
            --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 4px 6px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px rgba(0, 0, 0, 0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IRANSans', 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Sidebar Styles */
        .modern-sidebar {
            position: fixed;
            top: 0;
            right: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: var(--bg-primary);
            box-shadow: var(--shadow-xl);
            z-index: 1000;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border-left: 1px solid var(--border-color);
            transform: translateX(0);
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        .modern-sidebar.collapsed {
            width: var(--sidebar-collapsed-width);
        }

        .sidebar-header {
            height: var(--header-height);
            display: flex;
            align-items: center;
            justify-content: center;
            background: var(--primary-gradient);
            color: white;
            position: relative;
            overflow: hidden;
            flex-shrink: 0;
        }

        .sidebar-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/><circle cx="10" cy="50" r="0.5" fill="white" opacity="0.1"/><circle cx="90" cy="30" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }

        .sidebar-brand {
            display: flex;
            align-items: center;
            gap: 1rem;
            position: relative;
            z-index: 2;
        }

        .brand-icon {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            backdrop-filter: blur(10px);
        }

        .brand-text {
            font-size: 1.25rem;
            font-weight: 700;
            transition: all 0.3s ease;
        }

        .modern-sidebar.collapsed .brand-text {
            opacity: 0;
            transform: translateX(20px);
        }

        /* User Profile Section */
        .sidebar-user-profile {
            padding: 1.5rem;
            border-bottom: 1px solid var(--border-color);
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            flex-shrink: 0;
        }

        .user-avatar {
            width: 60px;
            height: 60px;
            border-radius: 16px;
            background: var(--primary-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            position: relative;
            overflow: hidden;
        }

        .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 16px;
        }

        .user-avatar::after {
            content: '';
            position: absolute;
            bottom: 2px;
            left: 2px;
            width: 12px;
            height: 12px;
            background: #10b981;
            border: 2px solid white;
            border-radius: 50%;
        }

        .user-info {
            transition: all 0.3s ease;
        }

        .user-name {
            font-size: 1rem;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 0.25rem;
        }

        .user-role {
            font-size: 0.875rem;
            color: var(--text-secondary);
            margin-bottom: 0.75rem;
        }

        .user-stats {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0.5rem;
        }

        .user-stat {
            text-align: center;
            padding: 0.5rem;
            background: white;
            border-radius: 8px;
            border: 1px solid var(--border-color);
        }

        .user-stat-number {
            font-size: 1rem;
            font-weight: 700;
            color: var(--primary-color);
            display: block;
        }

        .user-stat-label {
            font-size: 0.75rem;
            color: var(--text-secondary);
        }

        .modern-sidebar.collapsed .user-info {
            opacity: 0;
            transform: translateX(20px);
        }

        /* Navigation Styles */
        .sidebar-nav {
            padding: 1rem 0;
            flex: 1;
            overflow-y: auto;
            overflow-x: hidden;
            min-height: 0;
        }

        .sidebar-nav::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar-nav::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 3px;
        }

        .sidebar-nav::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
        }

        .sidebar-nav::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.5);
        }

        .nav-section {
            margin-bottom: 2rem;
        }

        .nav-section-title {
            font-size: 0.75rem;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            padding: 0 1.5rem;
            margin-bottom: 0.75rem;
            transition: all 0.3s ease;
        }

        .modern-sidebar.collapsed .nav-section-title {
            opacity: 0;
            transform: translateX(20px);
        }

        .nav-item {
            margin-bottom: 0.25rem;
            padding: 0 1rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.875rem 1rem;
            color: var(--text-secondary);
            text-decoration: none;
            border-radius: 12px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 0;
            height: 100%;
            background: var(--primary-gradient);
            transition: width 0.3s ease;
            z-index: -1;
        }

        .nav-link:hover {
            color: white;
            transform: translateX(-5px);
            box-shadow: var(--shadow-md);
        }

        .nav-link:hover::before {
            width: 100%;
        }

        .nav-link.active {
            color: white;
            background: var(--primary-gradient);
            box-shadow: var(--shadow-md);
        }

        .nav-link.active::before {
            width: 100%;
        }

        .nav-icon {
            width: 20px;
            height: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.125rem;
            flex-shrink: 0;
        }

        .nav-text {
            font-size: 0.875rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .nav-badge {
            background: var(--danger-color);
            color: white;
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
            border-radius: 12px;
            margin-right: auto;
            min-width: 20px;
            text-align: center;
            transition: all 0.3s ease;
        }

        .modern-sidebar.collapsed .nav-text,
        .modern-sidebar.collapsed .nav-badge {
            opacity: 0;
            transform: translateX(20px);
        }

        /* Logout Section */
        .sidebar-logout {
            padding: 1rem;
            border-top: 1px solid var(--border-color);
            flex-shrink: 0;
            margin-top: auto;
        }

        .logout-btn {
            width: 100%;
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.875rem 1rem;
            background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 0.875rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
        }

        .logout-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
            color: white;
        }

        .modern-sidebar.collapsed .logout-btn .nav-text {
            opacity: 0;
            transform: translateX(20px);
        }

        /* Main Content Styles */
        .main-wrapper {
            margin-right: var(--sidebar-width);
            min-height: 100vh;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            flex-direction: column;
        }

        .main-wrapper.expanded {
            margin-right: var(--sidebar-collapsed-width);
        }

        /* Top Header */
        .top-header {
            height: var(--header-height);
            background: var(--bg-primary);
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 2rem;
            box-shadow: var(--shadow-sm);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .sidebar-toggle {
            width: 40px;
            height: 40px;
            border: none;
            background: var(--bg-secondary);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            color: var(--text-secondary);
        }

        .sidebar-toggle:hover {
            background: var(--primary-color);
            color: white;
            transform: scale(1.05);
        }

        .breadcrumb-nav {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--text-secondary);
            font-size: 0.875rem;
        }

        .breadcrumb-item {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .breadcrumb-separator {
            color: var(--text-muted);
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .header-action {
            width: 40px;
            height: 40px;
            border: none;
            background: var(--bg-secondary);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            color: var(--text-secondary);
            text-decoration: none;
            position: relative;
        }

        .header-action:hover {
            background: var(--primary-color);
            color: white;
            transform: translateY(-2px);
        }

        .header-action.has-notification::after {
            content: '';
            position: absolute;
            top: 8px;
            left: 8px;
            width: 8px;
            height: 8px;
            background: var(--danger-color);
            border-radius: 50%;
            border: 2px solid white;
        }

        .user-dropdown {
            position: relative;
        }

        .user-dropdown-toggle {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem;
            background: var(--bg-secondary);
            border: none;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .user-dropdown-toggle:hover {
            background: var(--bg-tertiary);
        }

        .user-dropdown-avatar {
            width: 32px;
            height: 32px;
            border-radius: 8px;
            background: var(--primary-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 0.875rem;
            font-weight: 600;
        }

        .user-dropdown-info {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
        }

        .user-dropdown-name {
            font-size: 0.875rem;
            font-weight: 600;
            color: var(--text-primary);
        }

        .user-dropdown-role {
            font-size: 0.75rem;
            color: var(--text-secondary);
        }

        /* Main Content */
        .main-content {
            flex: 1;
            padding: 2rem;
            background: transparent;
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .modern-sidebar {
                transform: translateX(100%);
            }

            .modern-sidebar.show {
                transform: translateX(0);
            }

            .main-wrapper {
                margin-right: 0;
            }

            .main-wrapper.expanded {
                margin-right: 0;
            }
        }

        /* Ensure sidebar is visible on larger screens */
        @media (min-width: 993px) {
            .modern-sidebar {
                transform: translateX(0) !important;
                display: flex !important;
                visibility: visible !important;
                opacity: 1 !important;
            }

            .main-wrapper {
                margin-right: var(--sidebar-width);
            }

            .main-wrapper.expanded {
                margin-right: var(--sidebar-collapsed-width);
            }
        }

        /* Fix for zoom levels and viewport issues */
        @media (min-width: 1025px) {
            .modern-sidebar {
                transform: translateX(0) !important;
                display: flex !important;
                visibility: visible !important;
                opacity: 1 !important;
            }
        }

        @media (max-width: 768px) {
            .top-header {
                padding: 0 1rem;
            }

            .main-content {
                padding: 1rem;
            }

            .user-dropdown-info {
                display: none;
            }

            .breadcrumb-nav {
                display: none;
            }
        }

        /* Overlay for mobile */
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .sidebar-overlay.show {
            opacity: 1;
            visibility: visible;
        }

        /* Notification Styles */
        .notification-container {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 10000;
            display: flex;
            flex-direction: column;
            gap: 1rem;
            max-width: 400px;
        }

        .notification {
            background: white;
            border-radius: 12px;
            padding: 1rem 1.5rem;
            box-shadow: var(--shadow-lg);
            border-left: 4px solid var(--primary-color);
            display: flex;
            align-items: center;
            gap: 1rem;
            animation: slideInLeft 0.3s ease;
        }

        .notification.success {
            border-left-color: var(--success-color);
        }

        .notification.warning {
            border-left-color: var(--warning-color);
        }

        .notification.error {
            border-left-color: var(--danger-color);
        }

        @keyframes slideInLeft {
            from {
                transform: translateX(-100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
    </style>
    @yield('styles')
</head>
<body>
    <div id="app">
        <!-- Sidebar Overlay for Mobile -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <!-- Modern Sidebar -->
        <aside class="modern-sidebar" id="modernSidebar">
            <!-- Sidebar Header -->
            <div class="sidebar-header">
                <div class="sidebar-brand">
                    <div class="brand-icon">
                        <i class="fas fa-user-circle"></i>
                    </div>
                    <div class="brand-text">پنل کاربری</div>
                </div>
            </div>

            <!-- User Profile Section -->
            <div class="sidebar-user-profile">
                <div class="user-avatar">
                    @if(Auth::user()->avatar ?? false)
                        <img src="{{ Auth::user()->avatar }}" alt="{{ Auth::user()->full_name }}">
                    @else
                        {{ mb_substr(Auth::user()->full_name, 0, 1) }}
                    @endif
                </div>
                <div class="user-info">
                    <div class="user-name">{{ Auth::user()->full_name }}</div>
                    <div class="user-role">کاربر عضو</div>
                    <div class="user-stats">
                        <div class="user-stat">
                            <span class="user-stat-number" id="userLocationsCount">{{ Auth::user()->locations()->count() }}</span>
                            <span class="user-stat-label">مکان</span>
                        </div>
                        <div class="user-stat">
                            <span class="user-stat-number" id="userRatingsCount">{{ Auth::user()->ratings()->count() }}</span>
                            <span class="user-stat-label">نظر</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="sidebar-nav">
                <!-- Main Section -->
                <div class="nav-section">
                    <div class="nav-section-title">اصلی</div>

                    <div class="nav-item">
                        <a href="{{ route('user.dashboard') }}" class="nav-link {{ request()->routeIs('user.dashboard*') ? 'active' : '' }}">
                            <div class="nav-icon">
                                <i class="fas fa-tachometer-alt"></i>
                            </div>
                            <span class="nav-text">داشبورد</span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a href="{{ route('user.profile') }}" class="nav-link {{ request()->routeIs('user.profile*') ? 'active' : '' }}">
                            <div class="nav-icon">
                                <i class="fas fa-user"></i>
                            </div>
                            <span class="nav-text">پروفایل</span>
                        </a>
                    </div>
                </div>

                <!-- Content Section -->
                <div class="nav-section">
                    <div class="nav-section-title">محتوا</div>

                    <div class="nav-item">
                        <a href="{{ route('user.locations.index') }}" class="nav-link {{ request()->routeIs('user.locations.*') ? 'active' : '' }}">
                            <div class="nav-icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <span class="nav-text">مکان‌های من</span>
                            @php
                                $pendingLocations = Auth::user()->locations()->where('is_active', 0)->count();
                            @endphp
                            @if($pendingLocations > 0)
                                <span class="nav-badge">{{ $pendingLocations }}</span>
                            @endif
                        </a>
                    </div>

                    <div class="nav-item">
                        <a href="{{ route('user.ratings.index') }}" class="nav-link {{ request()->routeIs('user.ratings.*') ? 'active' : '' }}">
                            <div class="nav-icon">
                                <i class="fas fa-star"></i>
                            </div>
                            <span class="nav-text">نظرات من</span>
                            @php
                                $pendingRatings = Auth::user()->ratings()->where('status', 'pending')->count();
                            @endphp
                            @if($pendingRatings > 0)
                                <span class="nav-badge">{{ $pendingRatings }}</span>
                            @endif
                        </a>
                    </div>
                </div>

                <!-- Quick Actions Section -->
                <div class="nav-section">
                    <div class="nav-section-title">عملیات سریع</div>

                    <div class="nav-item">
                        <a href="{{ route('user.locations.create') }}" class="nav-link">
                            <div class="nav-icon">
                                <i class="fas fa-plus-circle"></i>
                            </div>
                            <span class="nav-text">ثبت مکان جدید</span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a href="{{ route('user.ratings.create') }}" class="nav-link">
                            <div class="nav-icon">
                                <i class="fas fa-comment-plus"></i>
                            </div>
                            <span class="nav-text">ثبت نظر جدید</span>
                        </a>
                    </div>
                </div>

                <!-- Settings Section -->
                <div class="nav-section">
                    <div class="nav-section-title">تنظیمات</div>

                    <div class="nav-item">
                        <a href="{{ route('user.change-password') }}" class="nav-link {{ request()->routeIs('user.change-password*') ? 'active' : '' }}">
                            <div class="nav-icon">
                                <i class="fas fa-key"></i>
                            </div>
                            <span class="nav-text">تغییر رمز عبور</span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a href="/" class="nav-link" target="_blank">
                            <div class="nav-icon">
                                <i class="fas fa-home"></i>
                            </div>
                            <span class="nav-text">بازگشت به سایت</span>
                        </a>
                    </div>
                </div>
            </nav>

            <!-- Logout Section -->
            <div class="sidebar-logout">
                <form method="POST" action="{{ route('user.logout') }}">
                    @csrf
                    <button type="submit" class="logout-btn">
                        <div class="nav-icon">
                            <i class="fas fa-sign-out-alt"></i>
                        </div>
                        <span class="nav-text">خروج از حساب</span>
                    </button>
                </form>
            </div>
        </aside>

        <!-- Main Wrapper -->
        <main class="main-wrapper" id="mainWrapper">
            <!-- Top Header -->
            <header class="top-header">
                <div class="header-left">
                    <button class="sidebar-toggle" id="sidebarToggle">
                        <i class="fas fa-bars"></i>
                    </button>

                    <nav class="breadcrumb-nav">
                        <div class="breadcrumb-item">
                            <i class="fas fa-home"></i>
                            <span>پنل کاربری</span>
                        </div>
                        <span class="breadcrumb-separator">/</span>
                        <div class="breadcrumb-item">
                            <span>@yield('title', 'داشبورد')</span>
                        </div>
                    </nav>
                </div>

                <div class="header-right">
                    <div class="header-actions">
                        <a href="/" class="header-action" title="بازگشت به سایت اصلی" target="_blank">
                            <i class="fas fa-external-link-alt"></i>
                        </a>

                        <a href="{{ route('user.locations.create') }}" class="header-action" title="ثبت مکان جدید">
                            <i class="fas fa-plus"></i>
                        </a>

                        <a href="{{ route('user.ratings.create') }}" class="header-action" title="ثبت نظر جدید">
                            <i class="fas fa-comment-plus"></i>
                        </a>

                        @php
                            $hasNotifications = Auth::user()->locations()->where('is_active', 0)->count() > 0 ||
                                              Auth::user()->ratings()->where('status', 'pending')->count() > 0;
                        @endphp
                        <button class="header-action {{ $hasNotifications ? 'has-notification' : '' }}" title="اعلان‌ها" onclick="toggleNotifications()">
                            <i class="fas fa-bell"></i>
                        </button>
                    </div>

                    <div class="user-dropdown">
                        <button class="user-dropdown-toggle" onclick="toggleUserDropdown()">
                            <div class="user-dropdown-avatar">
                                {{ mb_substr(Auth::user()->full_name, 0, 1) }}
                            </div>
                            <div class="user-dropdown-info">
                                <div class="user-dropdown-name">{{ Auth::user()->full_name }}</div>
                                <div class="user-dropdown-role">کاربر عضو</div>
                            </div>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                    </div>
                </div>
            </header>

            <!-- Main Content -->
            <div class="main-content">
                <!-- Success/Error Messages -->
                @if(session('success'))
                    <div class="notification success" id="successNotification">
                        <i class="fas fa-check-circle"></i>
                        <div>
                            <strong>موفقیت!</strong>
                            <p>{{ session('success') }}</p>
                        </div>
                        <button onclick="this.parentElement.remove()">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="notification error" id="errorNotification">
                        <i class="fas fa-exclamation-circle"></i>
                        <div>
                            <strong>خطا!</strong>
                            <p>{{ session('error') }}</p>
                        </div>
                        <button onclick="this.parentElement.remove()">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                @endif

                @if(session('warning'))
                    <div class="notification warning" id="warningNotification">
                        <i class="fas fa-exclamation-triangle"></i>
                        <div>
                            <strong>هشدار!</strong>
                            <p>{{ session('warning') }}</p>
                        </div>
                        <button onclick="this.parentElement.remove()">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                @endif

                @if ($errors->any())
                    <div class="notification error" id="validationErrors">
                        <i class="fas fa-exclamation-circle"></i>
                        <div>
                            <strong>خطاهای اعتبارسنجی:</strong>
                            <ul style="margin: 0; padding-right: 1rem;">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        <button onclick="this.parentElement.remove()">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                @endif

                @yield('content')
            </div>
        </main>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.js"></script>

    <!-- Locale Date Manager -->
    <script src="{{ asset('js/locale-date-manager.js') }}"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Modern User Panel Manager
            class ModernUserPanelManager {
                constructor() {
                    this.sidebar = document.getElementById('modernSidebar');
                    this.mainWrapper = document.getElementById('mainWrapper');
                    this.sidebarToggle = document.getElementById('sidebarToggle');
                    this.sidebarOverlay = document.getElementById('sidebarOverlay');
                    this.isMobile = window.innerWidth <= 992;

                    this.init();
                }

                init() {
                    this.initializeSidebar();
                    this.initializeNotifications();
                    this.initializeUserDropdown();
                    this.initializeResponsive();
                    this.initializeSelect2();
                    this.updateUserStats();
                    this.initializeTooltips();
                }

                // Initialize Sidebar
                initializeSidebar() {
                    if (this.sidebarToggle) {
                        this.sidebarToggle.addEventListener('click', () => {
                            this.toggleSidebar();
                        });
                    }

                    if (this.sidebarOverlay) {
                        this.sidebarOverlay.addEventListener('click', () => {
                            this.closeSidebar();
                        });
                    }

                    // Close sidebar on escape key
                    document.addEventListener('keydown', (e) => {
                        if (e.key === 'Escape' && this.isMobile) {
                            this.closeSidebar();
                        }
                    });
                }

                // Toggle Sidebar
                toggleSidebar() {
                    if (this.isMobile) {
                        this.sidebar.classList.toggle('show');
                        this.sidebarOverlay.classList.toggle('show');
                        document.body.style.overflow = this.sidebar.classList.contains('show') ? 'hidden' : '';
                    } else {
                        this.sidebar.classList.toggle('collapsed');
                        this.mainWrapper.classList.toggle('expanded');

                        // Save state to localStorage
                        localStorage.setItem('sidebarCollapsed', this.sidebar.classList.contains('collapsed'));
                    }
                }

                // Close Sidebar
                closeSidebar() {
                    if (this.isMobile) {
                        this.sidebar.classList.remove('show');
                        this.sidebarOverlay.classList.remove('show');
                        document.body.style.overflow = '';
                    }
                }

                // Initialize Notifications
                initializeNotifications() {
                    // Auto-hide notifications after 5 seconds
                    const notifications = document.querySelectorAll('.notification');
                    notifications.forEach(notification => {
                        setTimeout(() => {
                            if (notification.parentElement) {
                                notification.style.animation = 'slideOutLeft 0.3s ease forwards';
                                setTimeout(() => {
                                    notification.remove();
                                }, 300);
                            }
                        }, 5000);
                    });
                }

                // Initialize User Dropdown
                initializeUserDropdown() {
                    // This would be implemented when dropdown functionality is needed
                    console.log('User dropdown initialized');
                }

                // Initialize Responsive
                initializeResponsive() {
                    window.addEventListener('resize', () => {
                        const wasMobile = this.isMobile;
                        this.isMobile = window.innerWidth <= 992;

                        if (wasMobile !== this.isMobile) {
                            // Reset sidebar state when switching between mobile/desktop
                            this.sidebar.classList.remove('show', 'collapsed');
                            this.sidebarOverlay.classList.remove('show');
                            this.mainWrapper.classList.remove('expanded');
                            document.body.style.overflow = '';

                            // Restore collapsed state on desktop
                            if (!this.isMobile) {
                                const isCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
                                if (isCollapsed) {
                                    this.sidebar.classList.add('collapsed');
                                    this.mainWrapper.classList.add('expanded');
                                }
                            }
                        }
                    });

                    // Load saved sidebar state on desktop
                    if (!this.isMobile) {
                        const isCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
                        if (isCollapsed) {
                            this.sidebar.classList.add('collapsed');
                            this.mainWrapper.classList.add('expanded');
                        }
                    }
                }

                // Initialize Select2
                initializeSelect2() {
                    if (typeof jQuery !== 'undefined' && typeof jQuery.fn.select2 !== 'undefined') {
                        jQuery('.select2').select2({
                            dir: "rtl",
                            language: "fa",
                            theme: "bootstrap-5"
                        });
                    }
                }

                // Update User Stats
                updateUserStats() {
                    // This would fetch real-time stats via AJAX
                    this.fetchUserStats();
                }

                // Fetch User Stats
                async fetchUserStats() {
                    try {
                        // This would be an actual API call
                        // const response = await fetch('/api/user/stats');
                        // const stats = await response.json();

                        // For now, we'll use the existing values
                        console.log('User stats updated');
                    } catch (error) {
                        console.error('Error fetching user stats:', error);
                    }
                }

                // Initialize Tooltips
                initializeTooltips() {
                    // Initialize Bootstrap tooltips if available
                    if (typeof bootstrap !== 'undefined') {
                        const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                        tooltipTriggerList.map(function (tooltipTriggerEl) {
                            return new bootstrap.Tooltip(tooltipTriggerEl);
                        });
                    }
                }

                // Show Notification
                showNotification(message, type = 'info', duration = 5000) {
                    const notification = document.createElement('div');
                    notification.className = `notification ${type}`;
                    notification.innerHTML = `
                        <i class="fas fa-${this.getNotificationIcon(type)}"></i>
                        <div>
                            <strong>${this.getNotificationTitle(type)}</strong>
                            <p>${message}</p>
                        </div>
                        <button onclick="this.parentElement.remove()">
                            <i class="fas fa-times"></i>
                        </button>
                    `;

                    document.body.appendChild(notification);

                    setTimeout(() => {
                        if (notification.parentElement) {
                            notification.style.animation = 'slideOutLeft 0.3s ease forwards';
                            setTimeout(() => {
                                notification.remove();
                            }, 300);
                        }
                    }, duration);
                }

                getNotificationIcon(type) {
                    switch (type) {
                        case 'success': return 'check-circle';
                        case 'error': return 'exclamation-circle';
                        case 'warning': return 'exclamation-triangle';
                        default: return 'info-circle';
                    }
                }

                getNotificationTitle(type) {
                    switch (type) {
                        case 'success': return 'موفقیت!';
                        case 'error': return 'خطا!';
                        case 'warning': return 'هشدار!';
                        default: return 'اطلاع!';
                    }
                }
            }

            // Initialize the panel manager
            const panelManager = new ModernUserPanelManager();

            // Global functions
            window.toggleNotifications = function() {
                panelManager.showNotification('اعلان‌های جدید بررسی شد', 'info');
            };

            window.toggleUserDropdown = function() {
                console.log('User dropdown toggled');
            };

            // Add slideOutLeft animation
            const style = document.createElement('style');
            style.textContent = `
                @keyframes slideOutLeft {
                    from {
                        transform: translateX(0);
                        opacity: 1;
                    }
                    to {
                        transform: translateX(-100%);
                        opacity: 0;
                    }
                }
            `;
            document.head.appendChild(style);
        });
    </script>

    @yield('scripts')
</body>
</html>