@props(['buttons' => collect(), 'isGuest' => true, 'showUserMenu' => true])

@if($showUserMenu)
    <div class="user-buttons-container d-flex align-items-center gap-2">
        @if(!$isGuest)
            <!-- Authenticated User Dropdown -->
            <div class="dropdown">
                <button class="btn-auth dropdown-toggle d-flex align-items-center gap-2" 
                        type="button"
                        id="userDropdown" 
                        data-bs-toggle="dropdown" 
                        aria-expanded="false"
                        style="background: rgba(255,255,255,0.2); border: none; color: #2c3e50; border-radius: 25px; padding: 8px 16px; font-weight: 600;">
                    <i class="fas fa-user-circle" style="font-size: 1.2rem;"></i>
                    <span>{{ auth()->user()->name ?? 'کاربر' }}</span>
                    <i class="fas fa-chevron-down" style="font-size: 0.8rem;"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end shadow-lg border-0" 
                    aria-labelledby="userDropdown" 
                    style="border-radius: 12px; overflow: hidden; margin-top: 8px;">
                    @foreach($buttons->where('show_for_users', true)->sortBy('sort_order') as $button)
                        @if($button->is_visible)
                            <li>
                                @if($button->button_key === 'logout')
                                    <form method="POST" action="{{ $button->button_url }}" class="m-0">
                                        @csrf
                                        <button type="submit" 
                                                class="dropdown-item d-flex align-items-center w-100 border-0 bg-transparent" 
                                                style="padding: 12px 20px; transition: all 0.2s ease;">
                                            @if($button->button_icon)
                                                <i class="{{ $button->button_icon }} me-3 text-danger"></i>
                                            @endif
                                            {{ $button->button_text }}
                                        </button>
                                    </form>
                                @else
                                    <a class="dropdown-item d-flex align-items-center" 
                                       href="{{ $button->full_url }}" 
                                       style="padding: 12px 20px; transition: all 0.2s ease;">
                                        @if($button->button_icon)
                                            <i class="{{ $button->button_icon }} me-3 text-primary"></i>
                                        @endif
                                        {{ $button->button_text }}
                                    </a>
                                @endif
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        @else
            <!-- Guest User Buttons -->
            @foreach($buttons->where('show_for_guests', true)->sortBy('sort_order') as $button)
                @if($button->is_visible && $button->button_key !== 'add_location')
                    <a href="{{ $button->full_url }}" 
                       class="btn-auth d-flex align-items-center gap-2" 
                       style="background: rgba(255,255,255,0.2); border: none; color: #2c3e50; border-radius: 25px; padding: 8px 16px; font-weight: 600; text-decoration: none; margin: 0 2px;">
                        @if($button->button_icon)
                            <i class="{{ $button->button_icon }}"></i>
                        @endif
                        <span>{{ $button->button_text }}</span>
                    </a>
                @endif
            @endforeach
        @endif

        <!-- Add Location Button (Special handling) -->
        @php
            $addLocationButton = $buttons->where('button_key', 'add_location')->first();
        @endphp
        @if($addLocationButton && $addLocationButton->is_visible)
            @if(($isGuest && $addLocationButton->show_for_guests) || (!$isGuest && $addLocationButton->show_for_users))
                <a href="{{ $addLocationButton->full_url }}" 
                   class="btn-add-place d-flex align-items-center gap-2" 
                   style="background: #2c3e50; color: white; border: none; border-radius: 25px; padding: 8px 16px; font-weight: 600; text-decoration: none;">
                    @if($addLocationButton->button_icon)
                        <i class="{{ $addLocationButton->button_icon }}"></i>
                    @endif
                    <span>{{ $addLocationButton->button_text }}</span>
                </a>
            @endif
        @endif
    </div>
@endif

<style>
/* User Buttons Styles */
.user-buttons-container .btn-auth {
    transition: all 0.3s ease;
    white-space: nowrap;
}

.user-buttons-container .btn-auth:hover {
    background: rgba(255,255,255,0.4) !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.user-buttons-container .btn-add-place {
    transition: all 0.3s ease;
    white-space: nowrap;
}

.user-buttons-container .btn-add-place:hover {
    background: #1a252f !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.dropdown-menu {
    min-width: 200px;
    animation: fadeInDown 0.3s ease;
}

@keyframes fadeInDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.dropdown-item {
    transition: all 0.2s ease;
    border-bottom: 1px solid rgba(0,0,0,0.05);
}

.dropdown-item:last-child {
    border-bottom: none;
}

.dropdown-item:hover {
    background: #f8f9fa !important;
    transform: translateX(5px);
}

.dropdown-item i {
    width: 20px;
    text-align: center;
}

/* Mobile Responsive */
@media (max-width: 991.98px) {
    .user-buttons-container {
        flex-direction: column;
        gap: 8px !important;
        width: 100%;
    }
    
    .user-buttons-container .btn-auth,
    .user-buttons-container .btn-add-place {
        width: 100%;
        justify-content: center;
        padding: 12px 16px !important;
        margin: 0 !important;
    }
    
    .dropdown-menu {
        width: 100%;
        margin-top: 8px !important;
        border-radius: 8px !important;
    }
}

/* Button Icons */
.btn-auth i,
.btn-add-place i {
    transition: transform 0.3s ease;
}

.btn-auth:hover i,
.btn-add-place:hover i {
    transform: scale(1.1);
}

/* Dropdown Toggle Animation */
.dropdown-toggle::after {
    transition: transform 0.3s ease;
}

.dropdown[aria-expanded="true"] .dropdown-toggle::after {
    transform: rotate(180deg);
}

/* Loading State */
.btn-auth.loading,
.btn-add-place.loading {
    opacity: 0.7;
    pointer-events: none;
}

.btn-auth.loading::after,
.btn-add-place.loading::after {
    content: '';
    width: 16px;
    height: 16px;
    border: 2px solid transparent;
    border-top: 2px solid currentColor;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-left: 8px;
}

@keyframes spin {
    to {
        transform: rotate(360deg);
    }
}

/* Focus States for Accessibility */
.btn-auth:focus,
.btn-add-place:focus,
.dropdown-item:focus {
    outline: 2px solid #FFD700;
    outline-offset: 2px;
}

/* High Contrast Mode Support */
@media (prefers-contrast: high) {
    .btn-auth,
    .btn-add-place {
        border: 2px solid currentColor !important;
    }
    
    .dropdown-menu {
        border: 2px solid #000 !important;
    }
}
</style>
