@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مدیریت ترجمه‌ها</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.translations.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> افزودن ترجمه جدید
                        </a>
                        <form action="{{ route('admin.translations.import') }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-file-import"></i> وارد کردن از فایل‌های زبان
                            </button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filters -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <input type="text" id="search" class="form-control" placeholder="جستجو در کلید یا مقدار...">
                        </div>
                        <div class="col-md-3">
                            <select id="language" class="form-control">
                                <option value="">همه زبان‌ها</option>
                                @foreach($languages as $language)
                                    <option value="{{ $language->code }}">{{ $language->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select id="group" class="form-control">
                                <option value="">همه گروه‌ها</option>
                                @foreach($groups as $group)
                                    <option value="{{ $group }}">{{ $group }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select id="namespace" class="form-control">
                                <option value="">همه namespace ها</option>
                                @foreach($namespaces as $namespace)
                                    <option value="{{ $namespace }}">{{ $namespace }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Translations Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>کلید</th>
                                    <th>مقدار</th>
                                    <th>زبان</th>
                                    <th>گروه</th>
                                    <th>Namespace</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody id="translations-table">
                                @foreach($translations as $translation)
                                    <tr>
                                        <td>{{ $translation->key }}</td>
                                        <td>{{ $translation->value }}</td>
                                        <td>{{ $translation->language_code }}</td>
                                        <td>{{ $translation->group }}</td>
                                        <td>{{ $translation->namespace }}</td>
                                        <td>
                                            <a href="{{ route('admin.translations.edit', $translation->id) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.translations.destroy', $translation->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این ترجمه اطمینان دارید؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="mt-3" id="pagination-container">
                        {{ $translations->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    let searchTimeout;
    const searchInput = $('#search');
    const languageSelect = $('#language');
    const groupSelect = $('#group');
    const namespaceSelect = $('#namespace');
    const csrfToken = $('meta[name="csrf-token"]').attr('content');

    function loadTranslations(page = 1) {
        const search = searchInput.val();
        const language = languageSelect.val();
        const group = groupSelect.val();
        const namespace = namespaceSelect.val();

        $.ajax({
            url: '{{ route("admin.translations.index") }}',
            method: 'GET',
            data: {
                search: search,
                language: language,
                group: group,
                namespace: namespace,
                page: page
            },
            headers: {
                'X-CSRF-TOKEN': csrfToken
            },
            success: function(response) {
                const translations = response.translations.data;
                let html = '';

                translations.forEach(function(translation) {
                    html += `
                        <tr>
                            <td>${translation.key}</td>
                            <td>${translation.value}</td>
                            <td>${translation.language_code}</td>
                            <td>${translation.group || ''}</td>
                            <td>${translation.namespace || ''}</td>
                            <td>
                                <a href="/admin/translations/${translation.id}/edit" class="btn btn-sm btn-primary">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="/admin/translations/${translation.id}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این ترجمه اطمینان دارید؟')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    `;
                });

                $('#translations-table').html(html);
                updatePagination(response.pagination);
            },
            error: function(xhr) {
                console.error('Error loading translations:', xhr);
            }
        });
    }

    function updatePagination(pagination) {
        let html = '';
        const currentPage = pagination.current_page;
        const lastPage = pagination.last_page;

        // Previous button
        html += `<li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
            <a class="page-link" href="#" data-page="${currentPage - 1}">قبلی</a>
        </li>`;

        // Page numbers
        for (let i = 1; i <= lastPage; i++) {
            html += `<li class="page-item ${currentPage === i ? 'active' : ''}">
                <a class="page-link" href="#" data-page="${i}">${i}</a>
            </li>`;
        }

        // Next button
        html += `<li class="page-item ${currentPage === lastPage ? 'disabled' : ''}">
            <a class="page-link" href="#" data-page="${currentPage + 1}">بعدی</a>
        </li>`;

        $('#pagination-container').html(`<ul class="pagination">${html}</ul>`);
    }

    // Search input handler
    searchInput.on('keyup', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(function() {
            loadTranslations();
        }, 500);
    });

    // Filter change handlers
    languageSelect.on('change', loadTranslations);
    groupSelect.on('change', loadTranslations);
    namespaceSelect.on('change', loadTranslations);

    // Pagination click handler
    $(document).on('click', '.pagination .page-link', function(e) {
        e.preventDefault();
        const page = $(this).data('page');
        if (page) {
            loadTranslations(page);
        }
    });
});
</script>
@endpush
@endsection 