@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">افزودن ترجمه جدید</h1>
        <a href="{{ route('admin.translations.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right"></i> بازگشت به لیست
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-body">
            <form action="{{ route('admin.translations.store') }}" method="POST">
                @csrf
                
                <div class="form-group">
                    <label for="key">کلید ترجمه</label>
                    <input type="text" class="form-control @error('key') is-invalid @enderror" id="key" name="key" value="{{ old('key') }}" required>
                    @error('key')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="value">مقدار ترجمه</label>
                    <textarea class="form-control @error('value') is-invalid @enderror" id="value" name="value" rows="3" required>{{ old('value') }}</textarea>
                    @error('value')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="language_code">زبان</label>
                    <select class="form-control @error('language_code') is-invalid @enderror" id="language_code" name="language_code" required>
                        <option value="">انتخاب کنید</option>
                        @foreach($languages as $language)
                            <option value="{{ $language->code }}" {{ old('language_code') == $language->code ? 'selected' : '' }}>
                                {{ $language->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('language_code')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="group">گروه</label>
                    <input type="text" class="form-control @error('group') is-invalid @enderror" id="group" name="group" value="{{ old('group', '*') }}">
                    @error('group')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="namespace">فضای نام</label>
                    <input type="text" class="form-control @error('namespace') is-invalid @enderror" id="namespace" name="namespace" value="{{ old('namespace', '*') }}">
                    @error('namespace')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <button type="submit" class="btn btn-primary">ذخیره ترجمه</button>
            </form>
        </div>
    </div>
</div>
@endsection 