@extends('admin.layouts.app')

@section('title', 'تنظیمات عمومی')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تنظیمات عمومی</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.settings.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <!-- تنظیمات اصلی -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="site_title">عنوان سایت</label>
                                    <input type="text" class="form-control @error('site_title') is-invalid @enderror" 
                                           id="site_title" name="site_title" 
                                           value="{{ $settings['site_title'] ?? old('site_title') }}" required>
                                    @error('site_title')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="contact_email">ایمیل تماس</label>
                                    <input type="email" class="form-control @error('contact_email') is-invalid @enderror" 
                                           id="contact_email" name="contact_email" 
                                           value="{{ $settings['contact_email'] ?? old('contact_email') }}">
                                    @error('contact_email')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="contact_phone">شماره تماس</label>
                                    <input type="text" class="form-control @error('contact_phone') is-invalid @enderror" 
                                           id="contact_phone" name="contact_phone" 
                                           value="{{ $settings['contact_phone'] ?? old('contact_phone') }}">
                                    @error('contact_phone')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="contact_address">آدرس</label>
                                    <textarea class="form-control @error('contact_address') is-invalid @enderror" 
                                              id="contact_address" name="contact_address" rows="3">{{ $settings['contact_address'] ?? old('contact_address') }}</textarea>
                                    @error('contact_address')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- تنظیمات SEO -->
                        <h4 class="mt-4">تنظیمات SEO</h4>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="meta_title">عنوان متا</label>
                                    <input type="text" class="form-control @error('meta_title') is-invalid @enderror" 
                                           id="meta_title" name="meta_title" 
                                           value="{{ $settings['meta_title'] ?? old('meta_title') }}">
                                    @error('meta_title')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="meta_description">توضیحات متا</label>
                                    <textarea class="form-control @error('meta_description') is-invalid @enderror" 
                                              id="meta_description" name="meta_description" rows="3">{{ $settings['meta_description'] ?? old('meta_description') }}</textarea>
                                    @error('meta_description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="meta_keywords">کلمات کلیدی</label>
                                    <textarea class="form-control @error('meta_keywords') is-invalid @enderror" 
                                              id="meta_keywords" name="meta_keywords" rows="3">{{ $settings['meta_keywords'] ?? old('meta_keywords') }}</textarea>
                                    @error('meta_keywords')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- تنظیمات ظاهری -->
                        <h4 class="mt-4">تنظیمات ظاهری</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="theme_color">رنگ اصلی سایت</label>
                                    <input type="color" class="form-control @error('theme_color') is-invalid @enderror" 
                                           id="theme_color" name="theme_color" 
                                           value="{{ $settings['theme_color'] ?? old('theme_color', '#000000') }}">
                                    @error('theme_color')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="footer_text">متن فوتر</label>
                                    <textarea class="form-control @error('footer_text') is-invalid @enderror" 
                                              id="footer_text" name="footer_text" rows="3">{{ $settings['footer_text'] ?? old('footer_text') }}</textarea>
                                    @error('footer_text')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- دکمه‌های عملیات -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">ذخیره تنظیمات</button>
                                <a href="{{ route('admin.settings.index') }}" class="btn btn-secondary">بازگشت</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 