@extends('admin.layouts.app')

@section('title', 'تاریخچه ورود')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تاریخچه ورود کاربران</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>نام کاربر</th>
                                    <th>ایمیل</th>
                                    <th>آدرس IP</th>
                                    <th>مرورگر</th>
                                    <th>سیستم عامل</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ و زمان</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($loginHistory as $history)
                                    <tr>
                                        <td>{{ $history->name }}</td>
                                        <td>{{ $history->email }}</td>
                                        <td>{{ $history->ip_address }}</td>
                                        <td>{{ $history->user_agent }}</td>
                                        <td>{{ $history->platform }}</td>
                                        <td>
                                            @if($history->status === 'success')
                                                <span class="badge badge-success">موفق</span>
                                            @else
                                                <span class="badge badge-danger">ناموفق</span>
                                            @endif
                                        </td>
                                        <td>{{ jdate($history->created_at)->format('Y/m/d H:i:s') }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">هیچ رکوردی یافت نشد.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $loginHistory->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 