@extends('admin.layouts.app')

@section('title', 'افزودن منطقه جدید')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>افزودن منطقه (محله) جدید</h4>
                <a href="{{ route('admin.geography.zones.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> بازگشت به لیست مناطق
                </a>
            </div>
        </div>
        <div class="card-body">
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <form action="{{ route('admin.geography.zones.store') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="city_id">شهر <small class="text-muted">(اختیاری اگر روستا انتخاب شده باشد)</small></label>
                            <select name="city_id" id="city_id" class="form-control @error('city_id') is-invalid @enderror">
                                <option value="">-- انتخاب شهر --</option>
                                @foreach($cities as $id => $name)
                                    <option value="{{ $id }}" {{ old('city_id') == $id ? 'selected' : '' }}>
                                        {{ $name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('city_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="village_id">روستا <small class="text-muted">(اختیاری اگر شهر انتخاب شده باشد)</small></label>
                            <select name="village_id" id="village_id" class="form-control @error('village_id') is-invalid @enderror">
                                <option value="">-- انتخاب روستا --</option>
                                @foreach($villages as $id => $name)
                                    <option value="{{ $id }}" {{ old('village_id') == $id ? 'selected' : '' }}>
                                        {{ $name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('village_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="parent_zone_id">منطقه والد <small class="text-muted">(اختیاری)</small></label>
                            <select name="parent_zone_id" id="parent_zone_id" class="form-control @error('parent_zone_id') is-invalid @enderror">
                                <option value="">-- بدون منطقه والد --</option>
                                @if(isset($parentZones))
                                    @foreach($parentZones as $id => $name)
                                        <option value="{{ $id }}" {{ old('parent_zone_id') == $id ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                            @error('parent_zone_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="zone_type">نوع منطقه</label>
                            <select name="zone_type" id="zone_type" class="form-control @error('zone_type') is-invalid @enderror">
                                <option value="NEIGHBORHOOD" {{ old('zone_type') == 'NEIGHBORHOOD' ? 'selected' : '' }}>محله</option>
                                <option value="TOWNSHIP" {{ old('zone_type') == 'TOWNSHIP' ? 'selected' : '' }}>شهرک</option>
                                <option value="DISTRICT" {{ old('zone_type') == 'DISTRICT' ? 'selected' : '' }}>ناحیه</option>
                                <option value="RESIDENTIAL_COMPLEX" {{ old('zone_type') == 'RESIDENTIAL_COMPLEX' ? 'selected' : '' }}>مجتمع مسکونی</option>
                                <option value="INDUSTRIAL_ZONE" {{ old('zone_type') == 'INDUSTRIAL_ZONE' ? 'selected' : '' }}>منطقه صنعتی</option>
                                <option value="COMMERCIAL_ZONE" {{ old('zone_type') == 'COMMERCIAL_ZONE' ? 'selected' : '' }}>منطقه تجاری</option>
                                <option value="OTHER" {{ old('zone_type') == 'OTHER' ? 'selected' : '' }}>سایر</option>
                            </select>
                            @error('zone_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="name">نام منطقه <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="name_en">نام انگلیسی</label>
                            <input type="text" name="name_en" id="name_en" class="form-control @error('name_en') is-invalid @enderror" value="{{ old('name_en') }}">
                            @error('name_en')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="slug">نامک <span class="text-danger">*</span></label>
                            <input type="text" name="slug" id="slug" class="form-control @error('slug') is-invalid @enderror" value="{{ old('slug') }}" required>
                            @error('slug')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">نامک در URL استفاده خواهد شد</small>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="code">کد</label>
                            <input type="text" name="code" id="code" class="form-control @error('code') is-invalid @enderror" value="{{ old('code') }}">
                            @error('code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="population">جمعیت</label>
                            <input type="number" name="population" id="population" class="form-control @error('population') is-invalid @enderror" value="{{ old('population') }}">
                            @error('population')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="households">تعداد خانوار</label>
                            <input type="number" name="households" id="households" class="form-control @error('households') is-invalid @enderror" value="{{ old('households') }}">
                            @error('households')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="area">مساحت (کیلومتر مربع)</label>
                            <input type="text" name="area" id="area" class="form-control @error('area') is-invalid @enderror" value="{{ old('area') }}">
                            @error('area')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="postal_code">کد پستی</label>
                            <input type="text" name="postal_code" id="postal_code" class="form-control @error('postal_code') is-invalid @enderror" value="{{ old('postal_code') }}">
                            @error('postal_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label for="description">توضیحات</label>
                            <textarea name="description" id="description" rows="4" class="form-control @error('description') is-invalid @enderror">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" name="is_active" id="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">فعال</label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-primary">ذخیره منطقه</button>
                    <a href="{{ route('admin.geography.zones.index') }}" class="btn btn-secondary">انصراف</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تولید خودکار نامک از نام
        $('#name').on('keyup', function() {
            let name = $(this).val();
            let slug = name.toLowerCase()
                           .replace(/\s+/g, '-')           // جایگزینی فاصله با -
                           .replace(/[^\w\-]+/g, '')       // حذف تمام کاراکترهای غیرمجاز
                           .replace(/\-\-+/g, '-')         // جایگزینی چندین - با یک -
                           .replace(/^-+/, '')             // حذف - از ابتدای متن
                           .replace(/-+$/, '');            // حذف - از انتهای متن
            $('#slug').val(slug);
        });
        
        // منطق انتخاب شهر/روستا
        $('#city_id').on('change', function() {
            if ($(this).val()) {
                $('#village_id').val('');
            }
        });
        
        $('#village_id').on('change', function() {
            if ($(this).val()) {
                $('#city_id').val('');
            }
        });
    });
</script>
@endsection 