@extends('admin.layouts.app')

@section('title', 'ایجاد قالب دسته‌بندی جدید')

@push('styles')
<style>
    .icon-input-group .input-group-text {
        min-width: 40px;
        justify-content: center;
    }
    .form-control-color {
        max-width: 100px; /* Or adjust as needed */
        padding: .375rem .75rem; /* Match other inputs */
    }
    .feature-checkbox-group .custom-control {
        margin-bottom: 0.5rem;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0">ایجاد قالب دسته‌بندی جدید</h4>
        <a href="{{ route('admin.category-templates.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i>
            بازگشت به لیست
        </a>
    </div>

    <form action="{{ route('admin.category-templates.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>اطلاعات اصلی قالب</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="template_name" class="form-label">نام قالب <span class="text-danger">*</span></label>
                                <div class="input-group icon-input-group">
                                    <span class="input-group-text"><i class="fas fa-file-signature"></i></span>
                                    <input type="text" name="template_name" id="template_name"
                                           class="form-control @error('template_name') is-invalid @enderror"
                                           value="{{ old('template_name') }}" required placeholder="مثلا: قالب پیش‌فرض هتل">
                                </div>
                                @error('template_name')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="category_id" class="form-label">دسته‌بندی <span class="text-danger">*</span></label>
                                <div class="input-group icon-input-group">
                                    <span class="input-group-text"><i class="fas fa-sitemap"></i></span>
                                    <select name="category_id" id="category_id" class="form-select @error('category_id') is-invalid @enderror" required>
                                        <option value="">انتخاب دسته‌بندی</option>
                                        @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                            {{ $category->category_fa }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('category_id')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="template_type" class="form-label">نوع قالب <span class="text-danger">*</span></label>
                                 <div class="input-group icon-input-group">
                                    <span class="input-group-text"><i class="fas fa-puzzle-piece"></i></span>
                                    <select name="template_type" id="template_type"
                                            class="form-select @error('template_type') is-invalid @enderror" required>
                                        <option value="">انتخاب نوع</option>
                                        @foreach(config('templates.types', []) as $key => $value)
                                        <option value="{{ $key }}" {{ old('template_type') == $key ? 'selected' : '' }}>
                                            {{ $value }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('template_type')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="parent_template_id" class="form-label">قالب والد (اختیاری)</label>
                                <div class="input-group icon-input-group">
                                    <span class="input-group-text"><i class="fas fa-code-branch"></i></span>
                                    <select name="parent_template_id" id="parent_template_id"
                                            class="form-select @error('parent_template_id') is-invalid @enderror">
                                        <option value="">بدون والد</option>
                                        @foreach($templates as $parentTemplate)
                                        <option value="{{ $parentTemplate->id }}" {{ old('parent_template_id') == $parentTemplate->id ? 'selected' : '' }}>
                                            {{ $parentTemplate->template_name }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('parent_template_id')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="fas fa-palette me-2"></i>تنظیمات ظاهری</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="header_style" class="form-label">استایل هدر <span class="text-danger">*</span></label>
                                <div class="input-group icon-input-group">
                                    <span class="input-group-text"><i class="fas fa-window-maximize"></i></span>
                                    <select name="header_style" id="header_style"
                                            class="form-select @error('header_style') is-invalid @enderror" required>
                                        <option value="">انتخاب استایل</option>
                                        @foreach(config('templates.header_styles', []) as $key => $value)
                                        <option value="{{ $key }}" {{ old('header_style') == $key ? 'selected' : '' }}>
                                            {{ $value }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('header_style')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="content_layout" class="form-label">چیدمان محتوا <span class="text-danger">*</span></label>
                                <div class="input-group icon-input-group">
                                    <span class="input-group-text"><i class="fas fa-columns"></i></span>
                                    <select name="content_layout" id="content_layout"
                                            class="form-select @error('content_layout') is-invalid @enderror" required>
                                        <option value="">انتخاب چیدمان</option>
                                        @foreach(config('templates.content_layouts', []) as $key => $value)
                                        <option value="{{ $key }}" {{ old('content_layout') == $key ? 'selected' : '' }}>
                                            {{ $value }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('content_layout')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="primary_color" class="form-label">رنگ اصلی <span class="text-danger">*</span></label>
                                <input type="color" name="primary_color" id="primary_color"
                                       class="form-control form-control-color @error('primary_color') is-invalid @enderror"
                                       value="{{ old('primary_color', '#0d6efd') }}" required>
                                @error('primary_color')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="secondary_color" class="form-label">رنگ فرعی <span class="text-danger">*</span></label>
                                <input type="color" name="secondary_color" id="secondary_color"
                                       class="form-control form-control-color @error('secondary_color') is-invalid @enderror"
                                       value="{{ old('secondary_color', '#6c757d') }}" required>
                                @error('secondary_color')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                             <div class="col-md-6 mb-3">
                                <label for="icon_set" class="form-label">مجموعه آیکون <span class="text-danger">*</span></label>
                                <div class="input-group icon-input-group">
                                    <span class="input-group-text"><i class="fas fa-icons"></i></span>
                                    <select name="icon_set" id="icon_set"
                                            class="form-select @error('icon_set') is-invalid @enderror" required>
                                        <option value="">انتخاب مجموعه</option>
                                        @foreach(config('templates.icon_sets', []) as $key => $value)
                                        <option value="{{ $key }}" {{ old('icon_set') == $key ? 'selected' : '' }}>
                                            {{ $value }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('icon_set')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="background_image" class="form-label">تصویر پس‌زمینه (اختیاری)</label>
                                <input type="file" name="background_image" id="background_image"
                                       class="form-control @error('background_image') is-invalid @enderror">
                                @error('background_image')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="fas fa-cogs me-2"></i>تنظیمات پیشرفته</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="custom_css" class="form-label">CSS سفارشی (اختیاری)</label>
                            <textarea name="custom_css" id="custom_css"
                                      class="form-control @error('custom_css') is-invalid @enderror"
                                      rows="5" placeholder=".my-class {
    color: red;
}">{{ old('custom_css') }}</textarea>
                            @error('custom_css')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="custom_js" class="form-label">JavaScript سفارشی (اختیاری)</label>
                            <textarea name="custom_js" id="custom_js"
                                      class="form-control @error('custom_js') is-invalid @enderror"
                                      rows="5" placeholder="document.addEventListener('DOMContentLoaded', function() {
    // Your JS code here
});">{{ old('custom_js') }}</textarea>
                            @error('custom_js')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="fas fa-check-square me-2"></i>ویژگی‌های فعال</h5>
                    </div>
                    <div class="card-body feature-checkbox-group">
                        @if(config('templates.features') && count(config('templates.features')) > 0)
                            @foreach(config('templates.features') as $key => $feature)
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input" type="checkbox" name="features[{{ $key }}][is_enabled]"
                                           id="feature-{{ $key }}" value="1"
                                           {{ old('features.'.$key.'.is_enabled', $feature['default_enabled'] ?? false) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="feature-{{ $key }}">
                                        <i class="{{ $feature['icon'] ?? 'fas fa-star' }} me-1 text-{{ $feature['color'] ?? 'primary' }}"></i>
                                        {{ $feature['name'] }}
                                    </label>
                                </div>
                            @endforeach
                        @else
                            <p class="text-muted">هیچ ویژگی‌ای برای فعال‌سازی تعریف نشده است.</p>
                        @endif
                    </div>
                </div>

                <div class="card shadow-sm">
                    <div class="card-body text-center">
                        <button type="submit" class="btn btn-primary btn-lg w-100 mb-2">
                            <i class="fas fa-save me-1"></i>
                            ایجاد قالب
                        </button>
                        <a href="{{ route('admin.category-templates.index') }}" class="btn btn-outline-secondary w-100">
                            <i class="fas fa-times me-1"></i>
                            انصراف
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Script for custom file input label
        const fileInputs = document.querySelectorAll('input[type="file"];');
        fileInputs.forEach(input => {
            input.addEventListener('change', function(e) {
                let fileName = e.target.files[0] ? e.target.files[0].name : 'انتخاب فایل';
                let nextSibling = e.target.nextElementSibling;
                if (nextSibling && nextSibling.classList.contains('custom-file-label')) {
                    nextSibling.textContent = fileName;
                }
            });
        });

        // If you are using a specific JS library for admin panel (like select2, etc.)
        // you can initialize them here. For example:
        // if (typeof $ !== 'undefined' && $.fn.select2) {
        //     $('.form-select').select2({
        //         theme: 'bootstrap-5',
        //         dir: 'rtl'
        //     });
        // }
    });
</script>
{{-- <script src="{{ asset('js/admin/templates.js') }}"></script> --}}
{{-- Assuming templates.js is not strictly needed for this basic form or its functionality is incorporated above --}}
@endpush