@extends('layouts.admin')

@section('title', 'مدیریت تبلیغات مکان‌ها')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت تبلیغات مکان‌ها</h1>
        <a href="{{ route('admin.ads.assign-package') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50"></i> اختصاص پکیج جدید
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">لیست تبلیغات فعال</h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-left shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">فیلترها:</div>
                    <a class="dropdown-item" href="{{ route('admin.ads.location-ads', ['status' => 'active']) }}">فعال</a>
                    <a class="dropdown-item" href="{{ route('admin.ads.location-ads', ['status' => 'expired']) }}">منقضی شده</a>
                    <a class="dropdown-item" href="{{ route('admin.ads.location-ads', ['status' => 'pending']) }}">در انتظار پرداخت</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="{{ route('admin.ads.location-ads') }}">همه</a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>مکان</th>
                            <th>پکیج</th>
                            <th>تاریخ شروع</th>
                            <th>تاریخ پایان</th>
                            <th>محدوده نمایش</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($locationAds as $ad)
                            <tr>
                                <td>
                                    @if($ad->location)
                                        <a href="{{ route('locations.show', $ad->location->title_id) }}" target="_blank">
                                            {{ $ad->location->title }}
                                            <small class="d-block text-muted">{{ $ad->location->category_fa }}</small>
                                        </a>
                                    @else
                                        <span class="text-danger">مکان حذف شده</span>
                                    @endif
                                </td>
                                <td>
                                    @if($ad->package)
                                        <span class="badge" style="background-color: {{ $ad->package->badge_color }}; color: white;">
                                            {{ $ad->package->name }}
                                        </span>
                                    @else
                                        <span class="text-danger">پکیج نامشخص</span>
                                    @endif
                                </td>
                                <td>{{ verta($ad->start_date)->format('Y/m/d') }}</td>
                                <td>
                                    {{ verta($ad->end_date)->format('Y/m/d') }}
                                    @if($ad->end_date < now())
                                        <span class="badge badge-danger">منقضی شده</span>
                                    @else
                                        <small class="d-block text-muted">{{ verta($ad->end_date)->formatDifference() }} مانده</small>
                                    @endif
                                </td>
                                <td>
                                    @if($ad->geographic_scope)
                                        {{ $ad->getGeoNameAttribute() }}
                                        <small class="d-block text-muted">{{ __('ads.' . $ad->geographic_scope) }}</small>
                                    @else
                                        سراسری
                                    @endif
                                    
                                    @if($ad->category)
                                        <span class="badge badge-info">{{ $ad->category->category_fa }}</span>
                                    @endif
                                </td>
                                <td>
                                    @if($ad->is_active && $ad->end_date >= now())
                                        <span class="badge badge-success">فعال</span>
                                    @elseif($ad->end_date < now())
                                        <span class="badge badge-danger">منقضی شده</span>
                                    @elseif($ad->payment_status == 'pending')
                                        <span class="badge badge-warning">در انتظار پرداخت</span>
                                    @else
                                        <span class="badge badge-secondary">غیرفعال</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            عملیات
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#" onclick="event.preventDefault(); document.getElementById('extend-form-{{ $ad->id }}').submit();">
                                                <i class="fas fa-calendar-plus fa-sm fa-fw text-gray-400"></i> تمدید
                                            </a>
                                            <form id="extend-form-{{ $ad->id }}" action="{{ route('admin.ads.extend', $ad->id) }}" method="POST" style="display: none;">
                                                @csrf
                                            </form>
                                            
                                            @if(!$ad->is_active)
                                                <a class="dropdown-item" href="#" onclick="event.preventDefault(); document.getElementById('activate-form-{{ $ad->id }}').submit();">
                                                    <i class="fas fa-check fa-sm fa-fw text-gray-400"></i> فعال‌سازی
                                                </a>
                                                <form id="activate-form-{{ $ad->id }}" action="{{ route('admin.ads.activate', $ad->id) }}" method="POST" style="display: none;">
                                                    @csrf
                                                </form>
                                            @else
                                                <a class="dropdown-item" href="#" onclick="event.preventDefault(); document.getElementById('deactivate-form-{{ $ad->id }}').submit();">
                                                    <i class="fas fa-times fa-sm fa-fw text-gray-400"></i> غیرفعال‌سازی
                                                </a>
                                                <form id="deactivate-form-{{ $ad->id }}" action="{{ route('admin.ads.deactivate', $ad->id) }}" method="POST" style="display: none;">
                                                    @csrf
                                                </form>
                                            @endif
                                            
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item text-danger" href="#" onclick="event.preventDefault(); if(confirm('آیا از حذف این تبلیغ اطمینان دارید؟')) document.getElementById('delete-form-{{ $ad->id }}').submit();">
                                                <i class="fas fa-trash fa-sm fa-fw text-danger"></i> حذف
                                            </a>
                                            <form id="delete-form-{{ $ad->id }}" action="{{ route('admin.ads.delete', $ad->id) }}" method="POST" style="display: none;">
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            {{ $locationAds->links() }}
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "order": [[ 3, "asc" ]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json"
            }
        });
    });
</script>
@endpush 