@extends('admin.layouts.app')

@section('title', 'مدیریت کاربران ادمین')

@section('content')
<div class="container-fluid">
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">مدیریت کاربران ادمین</h6>
            <a href="{{ route('admin.admins.create') }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus"></i> افزودن ادمین جدید
            </a>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>نام کاربری</th>
                            <th>نام</th>
                            <th>ایمیل</th>
                            <th>نقش</th>
                            <th>وضعیت</th>
                            <th>آخرین ورود</th>
                            <th>تاریخ ایجاد</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($admins as $admin)
                        <tr>
                            <td>{{ $admin->id }}</td>
                            <td>{{ $admin->username }}</td>
                            <td>{{ $admin->name }}</td>
                            <td>{{ $admin->email }}</td>
                            <td>
                                <span class="badge {{ $admin->role == 'admin' ? 'badge-primary' : 'badge-info' }}">
                                    @if($admin->role == 'admin')
                                        ادمین
                                    @elseif($admin->role == 'super_admin')
                                        مدیر کل
                                    @else
                                        {{ ucfirst($admin->role) }}
                                    @endif
                                </span>
                            </td>
                            <td>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input toggle-active" 
                                        id="status_{{ $admin->id }}" 
                                        data-id="{{ $admin->id }}" 
                                        {{ $admin->is_active ? 'checked' : '' }} 
                                        {{ $admin->role == 'super_admin' ? 'disabled' : '' }}>
                                    <label class="custom-control-label" for="status_{{ $admin->id }}"></label>
                                </div>
                            </td>
                            <td>{{ $admin->last_login ? $admin->last_login->format('Y-m-d H:i') : 'هرگز' }}</td>
                            <td>{{ $admin->created_at->format('Y-m-d') }}</td>
                            <td>
                                <a href="{{ route('admin.admins.edit', $admin->id) }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if($admin->role != 'super_admin' && $admin->id != auth()->guard('admin')->id())
                                <button type="button" class="btn btn-sm btn-danger delete-btn" data-id="{{ $admin->id }}">
                                    <i class="fas fa-trash"></i>
                                </button>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $admins->links() }}
            </div>
        </div>
    </div>
</div>

<!-- مودال حذف -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">تأیید حذف</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                آیا از حذف این کاربر ادمین اطمینان دارید؟ این عملیات قابل بازگشت نیست.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">حذف</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        let adminId = null;
        
        // مدیریت کلیک دکمه حذف
        $('.delete-btn').on('click', function() {
            adminId = $(this).data('id');
            $('#deleteModal').modal('show');
        });
        
        // مدیریت کلیک دکمه تأیید حذف
        $('#confirmDelete').on('click', function() {
            if (adminId) {
                $.ajax({
                    url: `/admin/admin-users/${adminId}`,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#deleteModal').modal('hide');
                            toastr.success(response.message);
                            setTimeout(() => {
                                window.location.reload();
                            }, 1000);
                        } else {
                            toastr.error(response.message);
                        }
                    },
                    error: function() {
                        toastr.error('خطایی در حذف کاربر ادمین رخ داد.');
                    }
                });
            }
        });
        
        // مدیریت تغییر وضعیت فعال بودن
        $('.toggle-active').on('change', function() {
            const id = $(this).data('id');
            const checkbox = $(this);
            
            $.ajax({
                url: `/admin/admin-users/${id}/toggle-active`,
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                        checkbox.prop('checked', response.is_active);
                    } else {
                        toastr.error(response.message);
                        checkbox.prop('checked', !checkbox.prop('checked')); // برگرداندن تغییر
                    }
                },
                error: function() {
                    toastr.error('خطایی در بروزرسانی وضعیت رخ داد.');
                    checkbox.prop('checked', !checkbox.prop('checked')); // برگرداندن تغییر
                }
            });
        });
    });
</script>
@endsection