<?php

return [
    /*
    |--------------------------------------------------------------------------
    | انواع قالب‌ها
    |--------------------------------------------------------------------------
    |
    | این آرایه انواع مختلف قالب‌های موجود در سیستم را تعریف می‌کند.
    |
    */
    'types' => [
        'default' => 'پیش‌فرض',
        'hotel' => 'هتل',
        'restaurant' => 'رستوران',
        'shop' => 'فروشگاه',
        'event' => 'رویداد',
        'tour' => 'تور',
        'museum' => 'موزه',
        'park' => 'پارک',
        'beach' => 'ساحل',
        'mountain' => 'کوهستان',
        'historical' => 'تاریخی',
    ],

    /*
    |--------------------------------------------------------------------------
    | استایل‌های هدر
    |--------------------------------------------------------------------------
    |
    | این آرایه استایل‌های مختلف هدر را تعریف می‌کند.
    |
    */
    'header_styles' => [
        'default' => 'پیش‌فرض',
        'modern' => 'مدرن',
        'classic' => 'کلاسیک',
        'minimal' => 'مینیمال',
        'creative' => 'خلاقانه',
        'corporate' => 'شرکتی',
        'elegant' => 'زیبا',
        'bold' => 'جسورانه',
        'playful' => 'بازیگوش',
        'luxury' => 'لوکس',
    ],

    /*
    |--------------------------------------------------------------------------
    | چیدمان‌های محتوا
    |--------------------------------------------------------------------------
    |
    | این آرایه چیدمان‌های مختلف محتوا را تعریف می‌کند.
    |
    */
    'content_layouts' => [
        'default' => 'پیش‌فرض',
        'grid' => 'شبکه‌ای',
        'list' => 'لیستی',
        'masonry' => 'آبشاری',
        'timeline' => 'زمانی',
        'carousel' => 'اسلایدر',
        'tabs' => 'تب‌بندی',
        'accordion' => 'آکاردئونی',
        'cards' => 'کارت‌ها',
        'magazine' => 'مجله‌ای',
    ],

    /*
    |--------------------------------------------------------------------------
    | مجموعه‌های آیکون
    |--------------------------------------------------------------------------
    |
    | این آرایه مجموعه‌های مختلف آیکون را تعریف می‌کند.
    |
    */
    'icon_sets' => [
        'fontawesome' => 'Font Awesome',
        'material' => 'Material Icons',
        'bootstrap' => 'Bootstrap Icons',
        'feather' => 'Feather Icons',
        'ionicons' => 'Ionicons',
        'remix' => 'Remix Icons',
        'boxicons' => 'Boxicons',
        'heroicons' => 'Heroicons',
        'lineawesome' => 'Line Awesome',
        'themify' => 'Themify Icons',
    ],

    /*
    |--------------------------------------------------------------------------
    | ویژگی‌ها
    |--------------------------------------------------------------------------
    |
    | این آرایه ویژگی‌های مختلف قابل فعال‌سازی در قالب‌ها را تعریف می‌کند.
    |
    */
    'features' => [
        'booking' => [
            'name' => 'رزرو',
            'description' => 'امکان رزرو خدمات',
            'default_settings' => [
                'enable_calendar' => true,
                'enable_time_slots' => true,
                'enable_guests' => true,
                'enable_services' => true,
                'enable_pricing' => true,
            ],
        ],
        'payment' => [
            'name' => 'پرداخت',
            'description' => 'امکان پرداخت آنلاین',
            'default_settings' => [
                'enable_online_payment' => true,
                'enable_cash_payment' => true,
                'enable_wallet' => true,
                'enable_coupon' => true,
                'enable_invoice' => true,
            ],
        ],
        'gallery' => [
            'name' => 'گالری',
            'description' => 'نمایش تصاویر و ویدیوها',
            'default_settings' => [
                'enable_lightbox' => true,
                'enable_slideshow' => true,
                'enable_categories' => true,
                'enable_filters' => true,
                'enable_sharing' => true,
            ],
        ],
        'comments' => [
            'name' => 'نظرات',
            'description' => 'امکان ثبت نظرات',
            'default_settings' => [
                'enable_ratings' => true,
                'enable_replies' => true,
                'enable_moderation' => true,
                'enable_notifications' => true,
                'enable_reporting' => true,
            ],
        ],
        'map' => [
            'name' => 'نقشه',
            'description' => 'نمایش موقعیت مکانی',
            'default_settings' => [
                'enable_directions' => true,
                'enable_markers' => true,
                'enable_clusters' => true,
                'enable_search' => true,
                'enable_street_view' => true,
            ],
        ],
        'opening_hours' => [
            'name' => 'ساعات کاری',
            'description' => 'نمایش ساعات کاری',
            'default_settings' => [
                'enable_holidays' => true,
                'enable_special_hours' => true,
                'enable_notifications' => true,
                'enable_booking' => true,
                'enable_status' => true,
            ],
        ],
        'social_media' => [
            'name' => 'شبکه‌های اجتماعی',
            'description' => 'ارتباط با شبکه‌های اجتماعی',
            'default_settings' => [
                'enable_sharing' => true,
                'enable_following' => true,
                'enable_feed' => true,
                'enable_comments' => true,
                'enable_likes' => true,
            ],
        ],
        'contact_form' => [
            'name' => 'فرم تماس',
            'description' => 'فرم ارتباط با ما',
            'default_settings' => [
                'enable_captcha' => true,
                'enable_notifications' => true,
                'enable_auto_reply' => true,
                'enable_file_upload' => true,
                'enable_custom_fields' => true,
            ],
        ],
        'reviews' => [
            'name' => 'بررسی‌ها',
            'description' => 'نمایش نظرات و امتیازات',
            'default_settings' => [
                'enable_ratings' => true,
                'enable_photos' => true,
                'enable_verification' => true,
                'enable_replies' => true,
                'enable_reporting' => true,
            ],
        ],
        'related_items' => [
            'name' => 'موارد مرتبط',
            'description' => 'نمایش موارد مرتبط',
            'default_settings' => [
                'enable_categories' => true,
                'enable_tags' => true,
                'enable_location' => true,
                'enable_similarity' => true,
                'enable_recommendations' => true,
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | تنظیمات پیش‌فرض
    |--------------------------------------------------------------------------
    |
    | این آرایه تنظیمات پیش‌فرض برای قالب‌های جدید را تعریف می‌کند.
    |
    */
    'defaults' => [
        'header_style' => 'default',
        'content_layout' => 'default',
        'primary_color' => '#007bff',
        'secondary_color' => '#6c757d',
        'icon_set' => 'fontawesome',
        'features' => [],
        'feature_settings' => [],
        'is_active' => true
    ]
]; 