<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use App\Services\SiteSettingService;

class HelperServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // ثبت دایرکتیو blade برای site_setting
        Blade::directive('site_setting', function ($expression) {
            return "<?php echo app(App\Services\SiteSettingService::class)->getSetting($expression); ?>";
        });
    }
} 