<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RatingHelpfulVote extends Model
{
    protected $table = 'rating_helpful_votes';
    
    protected $fillable = [
        'rating_id',
        'user_ip',
        'user_agent',
        'vote_type'
    ];

    protected $casts = [
        'rating_id' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationships
    public function rating()
    {
        return $this->belongsTo(LocationRating::class, 'rating_id');
    }

    // Scopes
    public function scopeHelpful($query)
    {
        return $query->where('vote_type', 'helpful');
    }

    public function scopeNotHelpful($query)
    {
        return $query->where('vote_type', 'not_helpful');
    }

    public function scopeForRating($query, $ratingId)
    {
        return $query->where('rating_id', $ratingId);
    }

    public function scopeForIp($query, $ip)
    {
        return $query->where('user_ip', $ip);
    }

    // Static methods
    public static function hasUserVoted($ratingId, $userIp)
    {
        return static::forRating($ratingId)
            ->forIp($userIp)
            ->exists();
    }

    public static function getUserVote($ratingId, $userIp)
    {
        return static::forRating($ratingId)
            ->forIp($userIp)
            ->first();
    }

    public static function getHelpfulCount($ratingId)
    {
        return static::forRating($ratingId)
            ->helpful()
            ->count();
    }

    public static function getNotHelpfulCount($ratingId)
    {
        return static::forRating($ratingId)
            ->notHelpful()
            ->count();
    }

    // Helper methods
    public function isHelpful()
    {
        return $this->vote_type === 'helpful';
    }

    public function isNotHelpful()
    {
        return $this->vote_type === 'not_helpful';
    }
}
