<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DisplaySetting extends Model
{
    protected $fillable = [
        'page_key',
        'section_key',
        'desktop_items',
        'mobile_items',
        'load_more_text',
        'is_active',
        'hero_section',
        'featured_section',
        'categories_section',
        'latest_section',
        'popular_section',
        'map_section',
        'sidebar_position',
        'items_per_page',
        'show_ratings',
        'show_comments',
        'show_share_buttons'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'desktop_items' => 'integer',
        'mobile_items' => 'integer',
        'hero_section' => 'boolean',
        'featured_section' => 'boolean',
        'categories_section' => 'boolean',
        'latest_section' => 'boolean',
        'popular_section' => 'boolean',
        'map_section' => 'boolean',
        'items_per_page' => 'integer',
        'show_ratings' => 'boolean',
        'show_comments' => 'boolean',
        'show_share_buttons' => 'boolean'
    ];
}
