<?php

namespace App\Models;

use App\Traits\HasTranslatedName;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class County extends Model
{
    use HasFactory, SoftDeletes, HasTranslatedName;

    protected $table = 'state3_counties';

    protected $fillable = [
        'province_id',
        'name',
        'name_en',
        'code',
        'slug',
        'global_slug',
        'center_city_name',
        'area',
        'population',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'area' => 'decimal:2',
        'population' => 'integer',
        'deleted_at' => 'datetime',
    ];

    // Relationships
    public function province()
    {
        return $this->belongsTo(Province::class);
    }

    public function districts()
    {
        return $this->hasMany(District::class);
    }

    public function cities()
    {
        return $this->hasMany(City::class);
    }

    public function villages()
    {
        return $this->hasMany(Village::class);
    }

    public function locations()
    {
        return $this->hasMany(Location::class);
    }
}
